/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.actions.defaultImpl;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import dev.foxikle.customnpcs.actions.Action;
import dev.foxikle.customnpcs.actions.conditions.Condition;
import dev.foxikle.customnpcs.internal.CustomNPCs;
import dev.foxikle.customnpcs.internal.interfaces.InternalNpc;
import dev.foxikle.customnpcs.internal.menu.MenuUtils;
import dev.foxikle.customnpcs.internal.runnables.ServerRunnable;
import dev.foxikle.customnpcs.internal.utils.Msg;
import dev.foxikle.customnpcs.internal.utils.WaitingType;
import io.github.mqzen.menus.base.Content;
import io.github.mqzen.menus.base.Menu;
import io.github.mqzen.menus.misc.Capacity;
import io.github.mqzen.menus.misc.DataRegistry;
import io.github.mqzen.menus.misc.button.Button;
import io.github.mqzen.menus.misc.button.actions.ButtonClickAction;
import io.github.mqzen.menus.misc.itembuilder.ComponentItemBuilder;
import io.github.mqzen.menus.misc.itembuilder.ItemBuilder;
import io.github.mqzen.menus.titles.MenuTitle;
import io.github.mqzen.menus.titles.MenuTitles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class SendServer
extends Action {
    private String server;

    public SendServer(String server, int delay, Condition.SelectionMode mode, List<Condition> conditionals, int cooldown) {
        super(delay, mode, conditionals, cooldown);
        this.server = server;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.9")
    public SendServer(String server, int delay, Condition.SelectionMode mode, List<Condition> conditionals) {
        super(delay, mode, conditionals, 0);
        this.server = server;
    }

    public static Button creationButton(Player player) {
        return Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.GRASS_BLOCK).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.favicons.server", new Object[0]))).setLore((Object[])Msg.lore(player.locale(), "customnpcs.favicons.server.description", new Object[0]))).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
            event.setCancelled(true);
            Player p = (Player)event.getWhoClicked();
            p.playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            SendServer actionImpl = new SendServer("server", 0, Condition.SelectionMode.ONE, new ArrayList<Condition>(), 0);
            CustomNPCs.getInstance().editingActions.put(p.getUniqueId(), actionImpl);
            menuView.getAPI().openMenu(p, actionImpl.getMenu());
        }));
    }

    public static <T extends Action> T deserialize(String serialized, Class<T> clazz) {
        if (!clazz.equals(SendServer.class)) {
            throw new IllegalArgumentException("Cannot deserialize " + clazz.getName() + " to " + SendServer.class.getName());
        }
        String server = SendServer.parseString(serialized, "server");
        Action.ParseResult pr = SendServer.parseBase(serialized);
        SendServer message = new SendServer(server, pr.delay(), pr.mode(), pr.conditions(), pr.cooldown());
        return (T)((Action)clazz.cast(message));
    }

    @Override
    public void perform(InternalNpc npc, Menu menu, Player player) {
        if (!this.processConditions(player)) {
            return;
        }
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF("ConnectOther");
        out.writeUTF(player.getName());
        out.writeUTF(this.server);
        player.sendPluginMessage((Plugin)CustomNPCs.getInstance(), "BungeeCord", out.toByteArray());
        this.activateCooldown(player.getUniqueId());
    }

    @Override
    public String serialize() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("server", this.server);
        return this.generateSerializedString("SendServer", params);
    }

    @Override
    public ItemStack getFavicon(Player player) {
        return ((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.GRASS_BLOCK).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.favicons.server", new Object[0]))).setLore((Object[])new Component[]{Msg.translate(player.locale(), "customnpcs.favicons.delay", this.getDelay()), Msg.format(""), Msg.translate(player.locale(), "customnpcs.favicons.server.target", this.server), Msg.format(""), Msg.translate(player.locale(), "customnpcs.favicons.edit", new Object[0]), Msg.translate(player.locale(), "customnpcs.favicons.remove", new Object[0])})).build();
    }

    @Override
    public Menu getMenu() {
        return new SendServerCustomizer(this);
    }

    @Override
    public Action clone() {
        return new SendServer(this.server, this.getDelay(), this.getMode(), this.getConditions(), this.getCooldown());
    }

    @Generated
    public String getServer() {
        return this.server;
    }

    @Generated
    public void setServer(String server) {
        this.server = server;
    }

    public class SendServerCustomizer
    implements Menu {
        private final SendServer action;

        public SendServerCustomizer(SendServer action) {
            this.action = action;
        }

        public String getName() {
            return "SEND_SERVER_CUSTOMIZER";
        }

        @NotNull
        public MenuTitle getTitle(DataRegistry dataRegistry, Player player) {
            return MenuTitles.createModern((Component)Msg.translate(player.locale(), "customnpcs.menus.action_customizer.title", new Object[0]));
        }

        @NotNull
        public Capacity getCapacity(DataRegistry dataRegistry, Player player) {
            return Capacity.ofRows((int)5);
        }

        @NotNull
        public Content getContent(DataRegistry dataRegistry, Player player, Capacity capacity) {
            return MenuUtils.actionBase(this.action, player).setButton(22, Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.OAK_HANGING_SIGN).setDisplay((Object)Component.text((String)SendServer.this.getServer()))).setLore((Object[])new Component[]{Msg.translate(player.locale(), "customnpcs.items.click_to_change", new Object[0])})).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                CustomNPCs plugin = CustomNPCs.getInstance();
                Player p = (Player)event.getWhoClicked();
                p.closeInventory();
                plugin.wait(p, WaitingType.SERVER);
                new ServerRunnable(p, plugin).runTaskTimer((Plugin)plugin, 0L, 10L);
                event.setCancelled(true);
                player.playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            }))).build();
        }
    }
}

