/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.actions.defaultImpl;

import dev.foxikle.customnpcs.actions.Action;
import dev.foxikle.customnpcs.actions.conditions.Condition;
import dev.foxikle.customnpcs.internal.CustomNPCs;
import dev.foxikle.customnpcs.internal.interfaces.InternalNpc;
import dev.foxikle.customnpcs.internal.menu.MenuItems;
import dev.foxikle.customnpcs.internal.menu.MenuUtils;
import dev.foxikle.customnpcs.internal.utils.Msg;
import io.github.mqzen.menus.base.Content;
import io.github.mqzen.menus.base.Menu;
import io.github.mqzen.menus.misc.Capacity;
import io.github.mqzen.menus.misc.DataRegistry;
import io.github.mqzen.menus.misc.button.Button;
import io.github.mqzen.menus.misc.button.actions.ButtonClickAction;
import io.github.mqzen.menus.misc.itembuilder.ComponentItemBuilder;
import io.github.mqzen.menus.misc.itembuilder.ItemBuilder;
import io.github.mqzen.menus.titles.MenuTitle;
import io.github.mqzen.menus.titles.MenuTitles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class Teleport
extends Action {
    private double x;
    private double y;
    private double z;
    private float pitch;
    private float yaw;

    public Teleport(double x, double y, double z, float pitch, float yaw, int delay, Condition.SelectionMode mode, List<Condition> conditionals, int cooldown) {
        super(delay, mode, conditionals, cooldown);
        this.x = x;
        this.y = y;
        this.z = z;
        this.pitch = pitch;
        this.yaw = yaw;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.9")
    public Teleport(double x, double y, double z, float pitch, float yaw, int delay, Condition.SelectionMode mode, List<Condition> conditionals) {
        super(delay, mode, conditionals, 0);
        this.x = x;
        this.y = y;
        this.z = z;
        this.pitch = pitch;
        this.yaw = yaw;
    }

    public static Button creationButton(Player player) {
        return Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.ENDER_PEARL).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.favicons.teleport", new Object[0]))).setLore((Object[])Msg.lore(player.locale(), "customnpcs.favicons.teleport.description", new Object[0]))).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
            event.setCancelled(true);
            Player p = (Player)event.getWhoClicked();
            p.playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            Teleport actionImpl = new Teleport(0.0, 0.0, 0.0, 0.0f, 0.0f, 0, Condition.SelectionMode.ONE, new ArrayList<Condition>(), 0);
            CustomNPCs.getInstance().editingActions.put(p.getUniqueId(), actionImpl);
            menuView.getAPI().openMenu(p, actionImpl.getMenu());
        }));
    }

    public static <T extends Action> T deserialize(String serialized, Class<T> clazz) {
        if (!clazz.equals(Teleport.class)) {
            throw new IllegalArgumentException("Cannot deserialize " + clazz.getName() + " to " + Teleport.class.getName());
        }
        double x = Teleport.parseDouble(serialized, "x");
        double y = Teleport.parseDouble(serialized, "y");
        double z = Teleport.parseDouble(serialized, "z");
        float pitch = Teleport.parseFloat(serialized, "pitch");
        float yaw = Teleport.parseFloat(serialized, "yaw");
        Action.ParseResult pr = Teleport.parseBase(serialized);
        Teleport message = new Teleport(x, y, z, pitch, yaw, pr.delay(), pr.mode(), pr.conditions(), pr.cooldown());
        return (T)((Action)clazz.cast(message));
    }

    @Override
    public ItemStack getFavicon(Player player) {
        return ((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.ENDER_PEARL).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.favicons.teleport", new Object[0]))).setLore((Object[])new Component[]{Msg.translate(player.locale(), "customnpcs.favicons.delay", this.getDelay()), Msg.format(""), Msg.translate(player.locale(), "customnpcs.menus.action.teleport.display.x", this.x), Msg.translate(player.locale(), "customnpcs.menus.action.teleport.display.y", this.y), Msg.translate(player.locale(), "customnpcs.menus.action.teleport.display.z", this.z), Msg.translate(player.locale(), "customnpcs.menus.action.teleport.display.pitch", Float.valueOf(this.pitch)), Msg.translate(player.locale(), "customnpcs.menus.action.teleport.display.yaw", Float.valueOf(this.yaw)), Msg.format(""), Msg.translate(player.locale(), "customnpcs.favicons.edit", new Object[0]), Msg.translate(player.locale(), "customnpcs.favicons.remove", new Object[0])})).build();
    }

    @Override
    public Menu getMenu() {
        return new TeleportCustomizer(this);
    }

    @Override
    public void perform(InternalNpc npc, Menu menu, Player player) {
        if (!this.processConditions(player)) {
            return;
        }
        player.teleportAsync(new Location(npc.getWorld(), this.x, this.y, this.z, this.yaw, this.pitch));
        this.activateCooldown(player.getUniqueId());
    }

    @Override
    public String serialize() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("x", this.x);
        params.put("y", this.y);
        params.put("z", this.z);
        params.put("yaw", Float.valueOf(this.yaw));
        params.put("pitch", Float.valueOf(this.pitch));
        return this.generateSerializedString("Teleport", params);
    }

    @Override
    public Action clone() {
        return new Teleport(this.getX(), this.getY(), this.getZ(), this.getPitch(), this.getYaw(), this.getDelay(), this.getMode(), this.getConditions(), this.getCooldown());
    }

    @Generated
    public double getX() {
        return this.x;
    }

    @Generated
    public double getY() {
        return this.y;
    }

    @Generated
    public double getZ() {
        return this.z;
    }

    @Generated
    public float getPitch() {
        return this.pitch;
    }

    @Generated
    public float getYaw() {
        return this.yaw;
    }

    @Generated
    public void setX(double x) {
        this.x = x;
    }

    @Generated
    public void setY(double y) {
        this.y = y;
    }

    @Generated
    public void setZ(double z) {
        this.z = z;
    }

    @Generated
    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    @Generated
    public void setYaw(float yaw) {
        this.yaw = yaw;
    }

    public static class TeleportCustomizer
    implements Menu {
        private final Teleport action;
        Component displayLore;

        public TeleportCustomizer(Teleport action) {
            this.action = action;
        }

        public String getName() {
            return "TELEPORT_CUSTOMIZER";
        }

        @NotNull
        public MenuTitle getTitle(DataRegistry dataRegistry, Player player) {
            return MenuTitles.createModern((Component)Msg.translate(player.locale(), "customnpcs.menus.action_customizer.title", new Object[0]));
        }

        @NotNull
        public Capacity getCapacity(DataRegistry dataRegistry, Player player) {
            return Capacity.ofRows((int)5);
        }

        @NotNull
        public Content getContent(DataRegistry dataRegistry, Player player, Capacity capacity) {
            this.displayLore = Msg.translate(player.locale(), "customnpcs.menus.action.teleport.in_blocks", new Object[0]);
            Object[] incLore = Msg.lore(player.locale(), "customnpcs.menus.action_customizer.delay.increment.description", new Object[0]);
            Object[] decLore = Msg.lore(player.locale(), "customnpcs.menus.action_customizer.delay.decrement.description", new Object[0]);
            return MenuUtils.actionBase(this.action, player).setButton(19, Button.clickable((ItemStack)MenuItems.genericDisplay(Msg.translate(player.locale(), "customnpcs.menus.action.teleport.display.x", this.action.getX()), this.displayLore), (ButtonClickAction)ButtonClickAction.plain((menu, event) -> event.setCancelled(true)))).setButton(20, Button.clickable((ItemStack)MenuItems.genericDisplay(Msg.translate(player.locale(), "customnpcs.menus.action.teleport.display.y", this.action.getY()), this.displayLore), (ButtonClickAction)ButtonClickAction.plain((menu, event) -> event.setCancelled(true)))).setButton(21, Button.clickable((ItemStack)MenuItems.genericDisplay(Msg.translate(player.locale(), "customnpcs.menus.action.teleport.display.z", this.action.getZ()), this.displayLore), (ButtonClickAction)ButtonClickAction.plain((menu, event) -> event.setCancelled(true)))).setButton(23, this.compassDisplay(Msg.translate(player.locale(), "customnpcs.menus.action.teleport.display.pitch", Float.valueOf(this.action.getPitch())))).setButton(24, this.compassDisplay(Msg.translate(player.locale(), "customnpcs.menus.action.teleport.display.yaw", Float.valueOf(this.action.getYaw())))).setButton(10, Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.LIME_DYE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.action.teleport.increase_x", new Object[0]))).setLore(incLore)).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                event.setCancelled(true);
                player.playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                if (event.isShiftClick()) {
                    this.action.setX(this.action.getX() + 20.0);
                } else if (event.isLeftClick()) {
                    this.action.setX(this.action.getX() + 1.0);
                } else if (event.isRightClick()) {
                    this.action.setX(this.action.getX() + 5.0);
                }
                menuView.updateButton(19, button -> button.setItem(MenuItems.genericDisplay(Msg.translate(player.locale(), "customnpcs.menus.action.teleport.display.x", this.action.getX()), this.displayLore)));
            }))).setButton(11, Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.LIME_DYE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.action.teleport.increase_y", new Object[0]))).setLore(incLore)).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                event.setCancelled(true);
                player.playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                if (event.isShiftClick()) {
                    this.action.setY(this.action.getY() + 20.0);
                } else if (event.isLeftClick()) {
                    this.action.setY(this.action.getY() + 1.0);
                } else if (event.isRightClick()) {
                    this.action.setY(this.action.getY() + 5.0);
                }
                menuView.updateButton(20, button -> button.setItem(MenuItems.genericDisplay(Msg.translate(player.locale(), "customnpcs.menus.action.teleport.display.y", this.action.getY()), this.displayLore)));
            }))).setButton(12, Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.LIME_DYE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.action.teleport.increase_z", new Object[0]))).setLore(incLore)).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                event.setCancelled(true);
                player.playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                if (event.isShiftClick()) {
                    this.action.setZ(this.action.getZ() + 20.0);
                } else if (event.isLeftClick()) {
                    this.action.setZ(this.action.getZ() + 1.0);
                } else if (event.isRightClick()) {
                    this.action.setZ(this.action.getZ() + 5.0);
                }
                menuView.updateButton(21, button -> button.setItem(MenuItems.genericDisplay(Msg.translate(player.locale(), "customnpcs.menus.action.teleport.display.z", this.action.getZ()), this.displayLore)));
            }))).setButton(14, Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.LIME_DYE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.action.teleport.increase_pitch", new Object[0]))).setLore(incLore)).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                event.setCancelled(true);
                player.playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                if (this.action.getPitch() == 90.0f) {
                    event.getWhoClicked().sendMessage(Msg.translate(player.locale(), "customnpcs.menus.action.teleport.pitch_over_90", new Object[0]));
                    return;
                }
                if (event.isShiftClick()) {
                    this.action.setPitch(Math.min(this.action.getPitch() + 20.0f, 90.0f));
                } else if (event.isLeftClick()) {
                    this.action.setPitch(Math.min(this.action.getPitch() + 1.0f, 90.0f));
                } else if (event.isRightClick()) {
                    this.action.setPitch(Math.min(this.action.getPitch() + 5.0f, 90.0f));
                }
                menuView.updateButton(23, button -> button.setItem(this.compassDisplay(Msg.translate(player.locale(), "customnpcs.menus.action.teleport.display.pitch", Float.valueOf(this.action.getPitch()))).getItem()));
            }))).setButton(15, Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.LIME_DYE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.action.teleport.increase_yaw", new Object[0]))).setLore(incLore)).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                event.setCancelled(true);
                player.playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                if (this.action.getYaw() == 180.0f) {
                    player.sendMessage(Msg.translate(player.locale(), "customnpcs.menus.action.teleport.yaw_over_180", new Object[0]));
                    return;
                }
                if (event.isShiftClick()) {
                    this.action.setYaw(Math.min(this.action.getYaw() + 20.0f, 180.0f));
                } else if (event.isLeftClick()) {
                    this.action.setYaw(Math.min(this.action.getYaw() + 1.0f, 180.0f));
                } else if (event.isRightClick()) {
                    this.action.setYaw(Math.min(this.action.getYaw() + 5.0f, 180.0f));
                }
                menuView.updateButton(24, button -> button.setItem(this.compassDisplay(Msg.translate(player.locale(), "customnpcs.menus.action.teleport.display.yaw", Float.valueOf(this.action.getYaw()))).getItem()));
            }))).setButton(28, Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.RED_DYE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.action.teleport.decrease_x", new Object[0]))).setLore(decLore)).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                event.setCancelled(true);
                player.playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                if (event.isShiftClick()) {
                    this.action.setX(this.action.getX() - 20.0);
                } else if (event.isLeftClick()) {
                    this.action.setX(this.action.getX() - 1.0);
                } else if (event.isRightClick()) {
                    this.action.setX(this.action.getX() - 5.0);
                }
                menuView.updateButton(19, button -> button.setItem(MenuItems.genericDisplay(Msg.translate(player.locale(), "customnpcs.menus.action.teleport.display.x", this.action.getX()), this.displayLore)));
            }))).setButton(29, Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.RED_DYE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.action.teleport.decrease_y", new Object[0]))).setLore(decLore)).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                event.setCancelled(true);
                player.playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                if (event.isShiftClick()) {
                    this.action.setY(this.action.getY() - 20.0);
                } else if (event.isLeftClick()) {
                    this.action.setY(this.action.getY() - 1.0);
                } else if (event.isRightClick()) {
                    this.action.setY(this.action.getY() - 5.0);
                }
                menuView.updateButton(20, button -> button.setItem(MenuItems.genericDisplay(Msg.translate(player.locale(), "customnpcs.menus.action.teleport.display.y", this.action.getY()), this.displayLore)));
            }))).setButton(30, Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.RED_DYE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.action.teleport.decrease_z", new Object[0]))).setLore(decLore)).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                event.setCancelled(true);
                player.playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                if (event.isShiftClick()) {
                    this.action.setZ(this.action.getZ() - 20.0);
                } else if (event.isLeftClick()) {
                    this.action.setZ(this.action.getZ() - 1.0);
                } else if (event.isRightClick()) {
                    this.action.setZ(this.action.getZ() - 5.0);
                }
                menuView.updateButton(21, button -> button.setItem(MenuItems.genericDisplay(Msg.translate(player.locale(), "customnpcs.menus.action.teleport.display.z", this.action.getZ()), this.displayLore)));
            }))).setButton(32, Button.clickable((ItemStack)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.RED_DYE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.action.teleport.decrease_pitch", new Object[0]))).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                event.setCancelled(true);
                player.playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                if (this.action.getPitch() == -90.0f) {
                    player.sendMessage(Msg.translate(player.locale(), "customnpcs.menus.action.teleport.pitch_under_90", new Object[0]));
                    return;
                }
                if (event.isShiftClick()) {
                    this.action.setPitch(Math.max(this.action.getPitch() - 20.0f, -90.0f));
                } else if (event.isLeftClick()) {
                    this.action.setPitch(Math.max(this.action.getPitch() - 1.0f, -90.0f));
                } else if (event.isRightClick()) {
                    this.action.setPitch(Math.max(this.action.getPitch() - 5.0f, -90.0f));
                }
                menuView.updateButton(23, button -> button.setItem(this.compassDisplay(Msg.translate(player.locale(), "customnpcs.menus.action.teleport.display.pitch", Float.valueOf(this.action.getPitch()))).getItem()));
            }))).setButton(33, Button.clickable((ItemStack)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.RED_DYE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.action.teleport.decrease_yaw", new Object[0]))).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                event.setCancelled(true);
                player.playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                if (this.action.getYaw() == -180.0f) {
                    player.sendMessage(Msg.translate(player.locale(), "customnpcs.menus.action.teleport.yaw_under_180", new Object[0]));
                    return;
                }
                if (event.isShiftClick()) {
                    this.action.setYaw(Math.max(this.action.getYaw() - 20.0f, -180.0f));
                } else if (event.isLeftClick()) {
                    this.action.setYaw(Math.max(this.action.getYaw() - 1.0f, -180.0f));
                } else if (event.isRightClick()) {
                    this.action.setYaw(Math.max(this.action.getYaw() - 5.0f, -180.0f));
                }
                menuView.updateButton(24, button -> button.setItem(this.compassDisplay(Msg.translate(player.locale(), "customnpcs.menus.action.teleport.display.yaw", Float.valueOf(this.action.getYaw()))).getItem()));
            }))).build();
        }

        private Button compassDisplay(Component display) {
            return Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.COMPASS).setDisplay((Object)display)).setLore((Object[])new Component[]{this.displayLore})).build(), (ButtonClickAction)ButtonClickAction.plain((menu, event) -> event.setCancelled(true)));
        }
    }
}

