/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.internal;

import dev.foxikle.customnpcs.actions.Action;
import dev.foxikle.customnpcs.actions.ActionType;
import dev.foxikle.customnpcs.actions.LegacyAction;
import dev.foxikle.customnpcs.actions.conditions.Condition;
import dev.foxikle.customnpcs.api.Pose;
import dev.foxikle.customnpcs.data.Equipment;
import dev.foxikle.customnpcs.data.Settings;
import dev.foxikle.customnpcs.internal.CustomNPCs;
import dev.foxikle.customnpcs.internal.interfaces.InternalNpc;
import dev.foxikle.customnpcs.internal.utils.SkinUtils;
import dev.foxikle.customnpcs.internal.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileManager {
    public static final int CONFIG_FILE_VERSION = 6;
    public static final double NPC_FILE_VERSION = 1.9;
    public static File PARENT_DIRECTORY = new File("plugins/CustomNPCs/");
    private final Map<UUID, String> brokenNPCs = new HashMap<UUID, String>();
    private final List<UUID> validNPCs = new ArrayList<UUID>();
    private final CustomNPCs plugin;

    public FileManager(CustomNPCs plugin) {
        this.plugin = plugin;
    }

    public boolean createFiles() {
        ConfigurationSection section;
        Set npcs;
        BackupResult br;
        int version;
        if (!new File(PARENT_DIRECTORY, "/npcs.yml").exists()) {
            this.plugin.saveResource("npcs.yml", false);
        }
        if (!new File(PARENT_DIRECTORY, "config.yml").exists()) {
            this.plugin.saveResource("config.yml", false);
            return true;
        }
        File file = new File(PARENT_DIRECTORY, "config.yml");
        YamlConfiguration yml = YamlConfiguration.loadConfiguration((File)file);
        if (!yml.contains("Skins")) {
            BackupResult br2 = this.createBackup(file);
            if (br2.success) {
                this.plugin.getLogger().warning("The config is irreparably damaged! Resetting config. Your old config was saved to the file \"" + br2.filePath.toString() + "\"");
                this.plugin.saveResource("config.yml", true);
            }
        }
        if ((version = yml.getInt("CONFIG_VERSION")) < 6) {
            BackupResult br3 = this.createBackup(file);
            if (!br3.success()) {
                throw new RuntimeException("Failed to create a backup of the config file before updating it!");
            }
            this.plugin.getLogger().info("Created backup of config.yml before updating it! A copy of your existing config was saved to " + br3.filePath().toString());
        }
        if (version == 0) {
            this.plugin.getLogger().log(Level.WARNING, String.format("Outdated Config version! Converting config (%d -> %d).", version, 1));
            yml.set("CONFIG_VERSION", (Object)1);
            yml.setComments("CONFIG_VERSION", List.of(" DO NOT, under ANY circumstances modify the 'CONFIG_VERSION' field. Doing so can cause catastrophic data loss.", ""));
            yml.set("ClickText", (Object)"&e&lCLICK");
            yml.setComments("ClickText", List.of("ClickText -> The hologram displayed above the NPC if it is interactable", " NOTE: Due to Minecraft limitations, this cannot be more than 16 characters INCLUDING color and format codes.", " (But not the &)", ""));
            yml.set("DisplayClickText", (Object)true);
            yml.setComments("DisplayClickText", List.of(" DisplayClickText -> Should the plugin display a hologram above the NPC's head if it is interactable?", ""));
            try {
                yml.save(file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (version < 2) {
            this.plugin.getLogger().log(Level.WARNING, String.format("Outdated Config version! Converting config (%d -> %d).", version, 2));
            yml.set("CONFIG_VERSION", (Object)2);
            yml.set("AlertOnUpdate", (Object)true);
            try {
                yml.save(file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (version < 3) {
            this.plugin.getLogger().log(Level.WARNING, String.format("Outdated Config version! Converting config (%d -> %d).", version, 3));
            yml.set("CONFIG_VERSION", (Object)3);
            yml.set("ClickText", this.plugin.getMiniMessage().serialize((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(Objects.requireNonNull(yml.getString("ClickText")))));
            try {
                yml.save(file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (version < 4) {
            this.plugin.getLogger().log(Level.WARNING, String.format("Outdated Config version! Converting config (%d -> %d).", version, 4));
            yml.set("CONFIG_VERSION", (Object)4);
            yml.set("DisableCollisions", (Object)true);
            try {
                yml.save(file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (version < 5) {
            this.plugin.getLogger().log(Level.WARNING, String.format("Outdated Config version! Converting config (%d -> %d).", version, 5));
            yml.set("CONFIG_VERSION", (Object)5);
            yml.set("NameReferenceMessages", (Object)true);
            try {
                yml.save(file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (version < 6) {
            this.plugin.getLogger().log(Level.WARNING, String.format("Outdated Config version! Converting config (%d -> %d).", version, 6));
            yml.set("CONFIG_VERSION", (Object)6);
            yml.set("InjectionDistance", (Object)48);
            yml.set("InjectionInterval", (Object)10);
            yml.set("HologramUpdateInterval", (Object)200);
            yml.set("LookInterval", (Object)5);
            try {
                yml.save(file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (version < 7) {
            this.plugin.getLogger().log(Level.WARNING, String.format("Outdated Config version! Converting config (%d -> %d).", version, 7));
            yml.set("CONFIG_VERSION", (Object)7);
            yml.set("DefaultInterpolationDuration", (Object)5);
            yml.setComments("DefaultInterpolationDuration", List.of("DefaultInterpolationDuration -> How long should moving NPCs interpolate their Nametags moving?"));
            try {
                yml.save(file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (version < 8) {
            this.plugin.getLogger().log(Level.WARNING, String.format("Outdated Config version! Converting config (%d -> %d).", version, 8));
            yml.set("CONFIG_VERSION", (Object)8);
            ConfigurationSection section2 = yml.createSection("MineSkin");
            yml.setComments("MineSkin", List.of(" ############################", " #        Skin API          #", " ############################", "This plugin uses Mineskin.org's free skin api to generate skins from urls and player names. CustomNPCs comes with an api", "key embedded, but the same key is used by every other person using the plugin, so it will likely be reaching the rate limit", "nearly constantly. To combat this, you can use your own API key. You can get one here: https://account.mineskin.org/keys/"));
            section2.set("ApiKey", (Object)"");
            section2.setInlineComments("ApiKey", List.of("Put your api key here, if desired"));
            section2.set("ApiUrl", (Object)"");
            section2.setInlineComments("ApiUrl", List.of("Alternatively you can specify a proxied host to use instead: https://docs.mineskin.org/docs/guides/api-best-practises#use-a-proxy-server"));
            try {
                yml.save(file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        SkinUtils.setup(yml.getString("MineSkin.ApiKey"), yml.getString("MineSkin.ApiUrl"));
        boolean changed = false;
        File file2 = new File(PARENT_DIRECTORY, "npcs.yml");
        YamlConfiguration yml2 = YamlConfiguration.loadConfiguration((File)file2);
        String version2 = yml2.getString("version");
        if (version2 == null) {
            this.plugin.getLogger().warning("Old NPC file version found! Bumping version! (unknown version -> 1.3)");
            br = this.createBackup(file2);
            if (!br.success) {
                this.plugin.getLogger().warning("Could not create backup before updating npcs.yml!");
                return false;
            }
            yml2.set("version", (Object)"1.3");
            version2 = "1.3";
            this.plugin.getLogger().warning("Adding delay to old actions.");
            for (UUID uUID : this.getNPCIds()) {
                ConfigurationSection s2 = yml2.getConfigurationSection(uUID.toString());
                assert (s2 != null);
                List strings = s2.getStringList("actions");
                ArrayList<String> convertedActions = new ArrayList<String>();
                for (String string : strings) {
                    List<String> split = Utils.list(string.split("%::%"));
                    String sub = split.get(0);
                    split.remove(0);
                    int delay = 0;
                    LegacyAction actionImpl = new LegacyAction(ActionType.valueOf(sub), split, delay, Condition.SelectionMode.ONE, new ArrayList<Condition>());
                    convertedActions.add(actionImpl.toJson());
                }
                s2.set("actions", convertedActions);
            }
            try {
                yml2.save(file2);
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "An error occurred saving the npcs.yml file after saving a list of converted actions. Please report the following stacktrace to Foxikle.", e);
            }
        }
        if (version2.equalsIgnoreCase("1.3")) {
            this.plugin.getLogger().warning("Old NPC file version found! Bumping version! (1.3-> 1.4)");
            br = this.createBackup(file2);
            if (!br.success) {
                this.plugin.getLogger().warning("Could not create backup before updating npcs.yml!");
                return false;
            }
            yml2.set("version", (Object)"1.4");
            version2 = "1.4";
            npcs = yml2.getKeys(false);
            for (String npc : npcs) {
                if (npc.equals("version")) continue;
                section = yml2.getConfigurationSection(npc);
                this.plugin.getLogger().warning("Old Actions found. Converting to json.");
                List legacyActions = section.getStringList("actions");
                ArrayList newActions = new ArrayList();
                legacyActions.forEach(s -> {
                    LegacyAction a;
                    if (s != null && (a = LegacyAction.of(s)) != null) {
                        newActions.add(a.toJson());
                    }
                });
                section.set("actions", newActions);
                try {
                    yml2.save(file2);
                }
                catch (IOException e) {
                    this.plugin.getLogger().severe("An error occurred whilst saving the converted actions. Please report the following stacktrace to Foxikle. \n" + Arrays.toString(e.getStackTrace()));
                }
            }
        }
        if (version2.equalsIgnoreCase("1.4")) {
            this.plugin.getLogger().warning("Old NPC file version found! Bumping version! (1.4 -> 1.5)");
            br = this.createBackup(file2);
            if (!br.success) {
                this.plugin.getLogger().warning("Could not create backup before updating npcs.yml!");
                return false;
            }
            yml2.set("version", (Object)"1.5");
            version2 = "1.5";
            npcs = yml2.getKeys(false);
            for (String npc : npcs) {
                if (npc.equals("version")) continue;
                section = yml2.getConfigurationSection(npc);
                section.set("tunnelvision", (Object)false);
                try {
                    yml2.save(file2);
                }
                catch (IOException e) {
                    this.plugin.getLogger().severe("An error occurred whilst saving the tunelvision status to the config. Please report the following stacktrace to Foxikle. \n" + Arrays.toString(e.getStackTrace()));
                }
            }
        }
        if (version2.equalsIgnoreCase("1.5")) {
            this.plugin.getLogger().warning("Old NPC file version found! Bumping version! (1.5-> 1.6)");
            br = this.createBackup(file2);
            if (!br.success) {
                this.plugin.getLogger().warning("Could not create backup before updating npcs.yml!");
                return false;
            }
            yml2.set("version", (Object)"1.6");
            version2 = "1.6";
            npcs = yml2.getKeys(false);
            for (String npc : npcs) {
                if (npc.equals("version")) continue;
                section = yml2.getConfigurationSection(npc);
                section.set("customHologram", (Object)false);
                section.set("hideInteractableHologram", (Object)"");
                try {
                    yml2.save(file2);
                }
                catch (IOException e) {
                    this.plugin.getLogger().severe("An error occurred whilst saving the tunelvision status to the config. Please report the following stacktrace to Foxikle. \n" + Arrays.toString(e.getStackTrace()));
                }
            }
        }
        if (version2.equals("1.6")) {
            this.plugin.getLogger().warning("Old NPC file version found! Bumping version! (1.6 -> 1.7)");
            br = this.createBackup(file2);
            if (!br.success) {
                this.plugin.getLogger().warning("Could not create backup before updating npcs.yml!");
                return false;
            }
            yml2.set("version", (Object)"1.7");
            version2 = "1.7";
            npcs = yml2.getKeys(false);
            for (String npc : npcs) {
                Object a;
                Object actionStr22;
                if (npc.equals("version")) continue;
                section = yml2.getConfigurationSection(npc);
                List actionStrs = section.getStringList("actions");
                ArrayList<Action> list = new ArrayList<Action>();
                for (Object actionStr22 : actionStrs) {
                    a = LegacyAction.of((String)actionStr22);
                    if (a == null) {
                        this.plugin.getLogger().warning("Found an invalid action in the config. Please report the following action string to Foxikle. \n" + (String)actionStr22);
                        continue;
                    }
                    if (((LegacyAction)a).getActionType() == ActionType.TOGGLE_FOLLOWING) {
                        this.plugin.getLogger().warning("Found an action of the type `TOGGLE_FOLLOWING`. This action has been removed in 1.7.");
                        continue;
                    }
                    list.add(((LegacyAction)a).toAction());
                }
                ArrayList<String> newActions = new ArrayList<String>();
                actionStr22 = list.iterator();
                while (actionStr22.hasNext()) {
                    a = (Action)actionStr22.next();
                    if (a == null) {
                        this.plugin.getLogger().warning("Found an invalid action in the config.");
                        continue;
                    }
                    newActions.add(((Action)a).serialize());
                }
                section.set("actions", newActions);
            }
            try {
                yml2.save(file2);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        if (version2.equals("1.7")) {
            this.plugin.getLogger().warning("Old NPC file version found! Bumping version! (1.7 -> 1.8)");
            br = this.createBackup(file2);
            if (!br.success) {
                this.plugin.getLogger().warning("Could not create backup before updating npcs.yml!");
                return false;
            }
            yml2.set("version", (Object)"1.8");
            npcs = yml2.getKeys(false);
            for (String npc : npcs) {
                if (npc.equals("version")) continue;
                section = yml2.getConfigurationSection(npc);
                assert (section != null) : "Section is null -- Upgrading NPC file from 1.7 to 1.8";
                double dir = section.getDouble("direction");
                Location loc = section.getLocation("location");
                assert (loc != null) : "Location is null -- Upgrading NPC file from 1.7 to 1.8";
                loc.setYaw((float)dir);
                section.set("location", (Object)loc);
                section.set("direction", null);
            }
            try {
                yml2.save(file2);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        if (version2.equals("1.8")) {
            this.plugin.getLogger().warning("Old NPC file version found! Bumping version! (1.8 -> 1.9)");
            br = this.createBackup(file2);
            if (!br.success) {
                this.plugin.getLogger().warning("Could not create backup before updating npcs.yml!");
                return false;
            }
            yml2.set("version", (Object)"1.9");
            npcs = yml2.getKeys(false);
            for (String npc : npcs) {
                if (npc.equals("version")) continue;
                section = yml2.getConfigurationSection(npc);
                assert (section != null) : "Section is null -- Upgrading NPC file from 1.8 to 1.9";
                String[] lines = new String[]{section.getString("name")};
                section.set("lines", (Object)lines);
                section.set("name", null);
                section.set("pose", (Object)Pose.STANDING.name());
            }
            try {
                yml2.save(file2);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        boolean found = false;
        npcs = yml2.getKeys(false);
        for (String npc : npcs) {
            if (npc.equals("version")) continue;
            section = yml2.getConfigurationSection(npc);
            boolean err = false;
            boolean exists = false;
            UUID uuid = UUID.fromString(npc);
            try {
                Location sec = section.getLocation("location");
                exists = sec != null;
            }
            catch (Exception e) {
                err = true;
            }
            if (err || !exists) {
                found = true;
                String rawName = this.plugin.getMiniMessage().stripTags((String)section.getStringList("lines").get(0));
                this.brokenNPCs.put(UUID.fromString(npc), rawName);
                continue;
            }
            this.validNPCs.add(UUID.fromString(npc));
        }
        if (found) {
            this.printInvalidConfig();
        }
        return true;
    }

    public void addNPC(InternalNpc npc) {
        File file = new File("plugins/CustomNPCs/npcs.yml");
        YamlConfiguration yml = YamlConfiguration.loadConfiguration((File)file);
        yml.createSection(npc.getUniqueID().toString());
        ConfigurationSection section = yml.getConfigurationSection(npc.getUniqueID().toString());
        ArrayList actions = new ArrayList();
        npc.getActions().forEach(action -> actions.add(action.serialize()));
        assert (section != null);
        section.addDefault("value", (Object)npc.getSettings().getValue());
        section.addDefault("signature", (Object)npc.getSettings().getSignature());
        section.addDefault("skin", (Object)npc.getSettings().getSkinName());
        section.addDefault("clickable", (Object)npc.getSettings().isInteractable());
        section.addDefault("customHologram", (Object)npc.getSettings().getCustomInteractableHologram());
        section.addDefault("hideInteractableHologram", (Object)npc.getSettings().isHideClickableHologram());
        section.addDefault("location", (Object)npc.getSpawnLoc());
        section.addDefault("actions", actions);
        section.addDefault("handItem", (Object)npc.getEquipment().getHand());
        section.addDefault("offhandItem", (Object)npc.getEquipment().getOffhand());
        section.addDefault("headItem", (Object)npc.getEquipment().getHead());
        section.addDefault("chestItem", (Object)npc.getEquipment().getChest());
        section.addDefault("legsItem", (Object)npc.getEquipment().getLegs());
        section.addDefault("feetItem", (Object)npc.getEquipment().getBoots());
        section.addDefault("lines", (Object)npc.getSettings().getRawHolograms());
        section.addDefault("pose", (Object)npc.getSettings().getPose().name());
        section.addDefault("world", (Object)npc.getWorld().getName());
        section.addDefault("tunnelvision", (Object)npc.getSettings().isTunnelvision());
        section.addDefault("upsideDown", (Object)npc.getSettings().isUpsideDown());
        yml.options().copyDefaults(true);
        try {
            yml.save(file);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "An error occurred saving the npcs.yml file after creating a new section. Please report the following stacktrace to Foxikle.", e);
        }
    }

    public void loadNPC(UUID uuid) {
        Location location;
        World world;
        File file = new File("plugins/CustomNPCs/npcs.yml");
        YamlConfiguration yml = YamlConfiguration.loadConfiguration((File)file);
        ConfigurationSection section = yml.getConfigurationSection(uuid.toString());
        if (section == null) {
            throw new IllegalArgumentException("NPC uuid cannot be null.");
        }
        ArrayList<LegacyAction> actionImpls = new ArrayList<LegacyAction>();
        if (section.getConfigurationSection("actions") == null && section.getString("command") != null) {
            Bukkit.getLogger().info("Converting legacy commands to Actions.");
            String command = section.getString("command");
            assert (command != null);
            LegacyAction actionImpl = new LegacyAction(ActionType.RUN_COMMAND, Utils.list(command.split(" ")), 0, Condition.SelectionMode.ONE, new ArrayList<Condition>());
            actionImpls.add(actionImpl);
            section.set("actions", actionImpls);
            section.set("command", null);
            try {
                yml.save(file);
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "An error occurred saving the npcs.yml file after converting legacy commands to actions. Please report the following stacktrace to Foxikle.", e);
            }
        }
        List rawLines = section.getStringList("lines");
        for (int i = 0; i < rawLines.size(); ++i) {
            String line = (String)rawLines.get(i);
            if (line.contains("\u00a7")) {
                rawLines.set(i, (String)this.plugin.getMiniMessage().serialize((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(Objects.requireNonNull(line))));
            }
            try {
                yml.save(file);
                continue;
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "An error occurred saving the npcs.yml file after converting legacy names to minimessage. Please report the following stacktrace to Foxikle.", e);
            }
        }
        String rawName = this.plugin.getMiniMessage().stripTags((String)section.getStringList("lines").get(0));
        try {
            world = Bukkit.getWorld((String)Objects.requireNonNull(section.getString("world")));
        }
        catch (IllegalArgumentException ex) {
            this.printInvalidConfig();
            this.brokenNPCs.put(uuid, rawName);
            return;
        }
        try {
            location = section.getLocation("location");
        }
        catch (Exception ex) {
            this.brokenNPCs.put(uuid, rawName);
            this.printInvalidConfig();
            return;
        }
        if (world == null) {
            this.printInvalidConfig();
            this.brokenNPCs.put(uuid, rawName);
            return;
        }
        if (location == null) {
            this.printInvalidConfig();
            this.brokenNPCs.put(uuid, rawName);
            return;
        }
        ArrayList<Action> actions = new ArrayList<Action>();
        for (String s : section.getStringList("actions")) {
            actions.add(Action.parse(s));
        }
        InternalNpc npc = this.plugin.createNPC(world, location, new Equipment(section.getItemStack("headItem"), section.getItemStack("chestItem"), section.getItemStack("legsItem"), section.getItemStack("feetItem"), section.getItemStack("handItem"), section.getItemStack("offhandItem")), new Settings(section.getBoolean("clickable"), section.getBoolean("tunnelvision"), true, location.getYaw(), section.getString("value"), section.getString("signature"), section.getString("skin"), section.getStringList("lines").toArray(new String[0]), section.getString("customHologram"), section.getBoolean("hideInteractableHologram"), this.parsePose(section.getString("pose")), section.getBoolean("upsideDown")), uuid, null, actions);
        if (npc != null) {
            npc.createNPC();
        } else {
            this.plugin.getLogger().severe("The NPC '{name}' could not be created!".replace("{name}", Objects.requireNonNull((String)section.getStringList("lines").get(0))));
        }
    }

    @NotNull
    private Pose parsePose(String str) {
        if (str == null) {
            return Pose.STANDING;
        }
        try {
            return Pose.valueOf(str.toUpperCase());
        }
        catch (Exception e) {
            return Pose.STANDING;
        }
    }

    @Nullable
    public YamlConfiguration getNpcYaml() {
        File file = new File(PARENT_DIRECTORY, "npcs.yml");
        return YamlConfiguration.loadConfiguration((File)file);
    }

    public void saveNpcFile(YamlConfiguration section) {
        File file = new File(PARENT_DIRECTORY, "npcs.yml");
        section.save(file);
    }

    public Set<UUID> getNPCIds() {
        YamlConfiguration yml;
        File file = new File("plugins/CustomNPCs/npcs.yml");
        try {
            yml = YamlConfiguration.loadConfiguration((File)file);
        }
        catch (Exception ex) {
            this.printInvalidConfig();
            return new HashSet<UUID>();
        }
        HashSet<UUID> uuids = new HashSet<UUID>();
        for (String str : yml.getKeys(false)) {
            if (str.equalsIgnoreCase("version")) continue;
            uuids.add(UUID.fromString(str));
        }
        return uuids;
    }

    public void remove(UUID uuid) {
        File file = new File("plugins/CustomNPCs/npcs.yml");
        YamlConfiguration yml = YamlConfiguration.loadConfiguration((File)file);
        yml.set(uuid.toString(), null);
        try {
            yml.save(file);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "An error occurred saving the npcs.yml file after removing an npc. Please report the following stacktrace to Foxikle.", e);
        }
    }

    private BackupResult createBackup(File file) {
        YamlConfiguration yml = YamlConfiguration.loadConfiguration((File)file);
        File f = new File(PARENT_DIRECTORY, new Date().toString().replace(" ", "_").replace(":", "_") + "_backup_of_" + file.getName() + Instant.now().hashCode());
        try {
            if (!f.createNewFile()) {
                throw new RuntimeException("A duplicate file of file '" + f.getName() + "' exists! This means the plugin attempted to back up the file '" + file.getName() + "' multiple times within this millisecond! This is a serious issue that should be reported to @foxikle on discord!");
            }
            yml.save(f);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "An error occurred whilst creating a backup of the file '" + file.getName() + "'", e);
            return new BackupResult(null, false);
        }
        return new BackupResult(f.toPath(), true);
    }

    private void printInvalidConfig() {
        this.plugin.getLogger().severe("");
        this.plugin.getLogger().severe("+------------------------------------------------------------------------------+");
        this.plugin.getLogger().severe("|                 NPC with an invalid configuration detected!                  |");
        this.plugin.getLogger().severe("|                 ** THIS IS NOT AN ERROR WITH CUSTOMNPCS **                   |");
        this.plugin.getLogger().severe("|         This is most likely a configuration error as a result of             |");
        this.plugin.getLogger().severe("|                       modifying the `npcs.yml` file.                         |");
        this.plugin.getLogger().severe("+------------------------------------------------------------------------------+");
        this.plugin.getLogger().severe("");
    }

    @Generated
    public Map<UUID, String> getBrokenNPCs() {
        return this.brokenNPCs;
    }

    @Generated
    public List<UUID> getValidNPCs() {
        return this.validNPCs;
    }

    private record BackupResult(Path filePath, boolean success) {
    }
}

