/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.internal.commands;

import dev.foxikle.customnpcs.internal.CustomNPCs;
import dev.foxikle.customnpcs.internal.FileManager;
import dev.foxikle.customnpcs.internal.commands.CommandUtils;
import dev.foxikle.customnpcs.internal.commands.enums.FixConfigWorldStrategy;
import dev.foxikle.customnpcs.internal.utils.Msg;
import dev.velix.imperat.BukkitSource;
import dev.velix.imperat.annotations.Default;
import dev.velix.imperat.annotations.Named;
import dev.velix.imperat.annotations.Permission;
import dev.velix.imperat.annotations.SubCommand;
import dev.velix.imperat.annotations.Suggest;
import dev.velix.imperat.annotations.SuggestionProvider;
import dev.velix.imperat.annotations.Usage;
import dev.velix.imperat.command.AttachmentMode;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.ComponentLike;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

@SubCommand(value={"fixconfig"}, attachment=AttachmentMode.MAIN)
@Permission(value="customnpcs.commands.fix_config")
public class FixConfigCommand {
    @Usage
    public void execute(BukkitSource source) {
        Locale locale = CommandUtils.getLocale(source);
        source.reply((ComponentLike)Msg.translate(locale, "customnpcs.commands.fix_config.usage", new Object[0]));
    }

    @Usage
    public void execute(BukkitSource source, @Named(value="mode") @Suggest(value={"world"}) String mode, @SuggestionProvider(value="worlds") @Default(value="world") @Named(value="world") String world, @Suggest(value={"NONE", "SAFE_LOCATION"}) @Default(value="NONE") @Named(value="strategy") String strategy, @Suggest(value={"all"}) @SuggestionProvider(value="broken_npc") @Default(value="all") @Named(value="target") String target) {
        Locale locale = CommandUtils.getLocale(source);
        int totalFixed = 0;
        int movedbyStrategy = 0;
        int failedToFix = 0;
        int nonExistentNpcs = 0;
        if (!mode.equalsIgnoreCase("world")) {
            this.execute(source);
            return;
        }
        if (Bukkit.getWorld((String)world) == null) {
            source.reply("INVALID_WORLD");
            return;
        }
        World w = Bukkit.getWorld((String)world);
        assert (w != null);
        FixConfigWorldStrategy strat = FixConfigWorldStrategy.parse(strategy);
        if (strat == null) {
            source.reply("INVALID_STRATEGY");
            return;
        }
        CustomNPCs plugin = CustomNPCs.getInstance();
        FileManager fileManager = plugin.getFileManager();
        if (target.equalsIgnoreCase("all")) {
            for (UUID uuid : fileManager.getBrokenNPCs().keySet()) {
                Object locString;
                Location loc;
                YamlConfiguration yml = fileManager.getNpcYaml();
                ConfigurationSection parent = yml.getConfigurationSection(uuid.toString());
                if (parent == null) {
                    ++nonExistentNpcs;
                    continue;
                }
                ConfigurationSection location = parent.getConfigurationSection("location");
                if (location != null) {
                    assert (location != null) : "Location is null";
                    double x = location.getDouble("x");
                    double y = location.getDouble("y");
                    double z = location.getDouble("z");
                    float pitch = (float)location.getDouble("pitch");
                    float yaw = (float)location.getDouble("yaw");
                    loc = new Location(w, x, y, z, pitch, yaw);
                    locString = "(" + x + "," + y + "," + z + ")";
                } else {
                    loc = new Location(w, 0.0, 0.0, 0.0, 0.0f, 0.0f);
                    locString = "(0, 0, 0)";
                    plugin.getLogger().warning("Fixed an NPC whose location data was wiped by Bukkit's configuration API. Its location was set to (0,0,0)");
                    source.reply((ComponentLike)Msg.translate(locale, "customnpcs.commands.fix_config.bukkit_wiped_data", new Object[0]));
                }
                if (strat == FixConfigWorldStrategy.SAFE_LOCATION) {
                    if (w.getBlockAt(loc).isSolid() || w.getBlockAt(loc.add(0.0, 1.0, 0.0)).isSolid()) {
                        RayTraceResult traceResult = w.rayTraceBlocks(loc.add(0.0, 329.0 - loc.y(), 0.0), new Vector(0, -1, 0), 320.0, FluidCollisionMode.NEVER);
                        if (traceResult == null) {
                            plugin.getLogger().warning("Failed to fix npc " + String.valueOf(uuid) + " at " + (String)locString + " -- Location cannot be made safe.");
                            ++failedToFix;
                            continue;
                        }
                        loc.setY((double)(traceResult.getHitBlock().getY() + 1));
                    }
                    ++movedbyStrategy;
                }
                parent.set("location", (Object)loc);
                ++totalFixed;
                fileManager.saveNpcFile(yml);
            }
        } else {
            try {
                Object locString;
                Location loc;
                if (!fileManager.getBrokenNPCs().containsValue(target)) {
                    source.reply((ComponentLike)Msg.translate(locale, "customnpcs.commands.invalid_name_or_uuid ", new Object[0]));
                    return;
                }
                UUID uuid = null;
                for (Map.Entry<UUID, String> entry : fileManager.getBrokenNPCs().entrySet()) {
                    if (!entry.getValue().equals(target)) continue;
                    uuid = entry.getKey();
                    break;
                }
                if (uuid == null) {
                    source.reply((ComponentLike)Msg.translate(locale, "customnpcs.commands.invalid_name_or_uuid", new Object[0]));
                    return;
                }
                YamlConfiguration yml = fileManager.getNpcYaml();
                ConfigurationSection parent = yml.getConfigurationSection(uuid.toString());
                if (parent == null) {
                    ++nonExistentNpcs;
                    throw new RuntimeException("Catch me!");
                }
                ConfigurationSection location = parent.getConfigurationSection("location");
                if (location != null) {
                    assert (location != null) : "Location is null";
                    double x = location.getDouble("x");
                    double y = location.getDouble("y");
                    double z = location.getDouble("z");
                    float pitch = (float)location.getDouble("pitch");
                    float yaw = (float)location.getDouble("yaw");
                    loc = new Location(w, x, y, z, pitch, yaw);
                    locString = "(" + x + "," + y + "," + z + ")";
                } else {
                    loc = new Location(w, 0.0, 0.0, 0.0, 0.0f, 0.0f);
                    locString = "(0, 0, 0)";
                    plugin.getLogger().warning("Fixed an NPC whose location data was wiped by Bukkit's configuration API. Its location was set to (0,0,0)");
                    source.reply((ComponentLike)Msg.translate(locale, "customnpcs.commands.fix_config.bukkit_wiped_data", new Object[0]));
                }
                if (strat == FixConfigWorldStrategy.SAFE_LOCATION) {
                    if (w.getBlockAt(loc).isSolid() || w.getBlockAt(loc.add(0.0, 1.0, 0.0)).isSolid()) {
                        RayTraceResult traceResult = w.rayTraceBlocks(loc.add(0.0, 329.0 - loc.y(), 0.0), new Vector(0, -1, 0), 320.0, FluidCollisionMode.NEVER);
                        if (traceResult == null) {
                            plugin.getLogger().warning("Failed to fix npc " + String.valueOf(uuid) + " at " + (String)locString + " -- Location cannot be made safe.");
                            ++failedToFix;
                            throw new RuntimeException("Catch me!");
                        }
                        loc.setY((double)(traceResult.getHitBlock().getY() + 1));
                    }
                    ++movedbyStrategy;
                }
                parent.set("location", (Object)loc);
                ++totalFixed;
                fileManager.saveNpcFile(yml);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        source.reply((ComponentLike)Msg.translate(locale, "customnpcs.commands.fix_config.report", totalFixed, movedbyStrategy, failedToFix, nonExistentNpcs));
    }
}

