/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.internal.listeners;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.foxikle.customnpcs.actions.Action;
import dev.foxikle.customnpcs.actions.conditions.Condition;
import dev.foxikle.customnpcs.actions.defaultImpl.ActionBar;
import dev.foxikle.customnpcs.actions.defaultImpl.DisplayTitle;
import dev.foxikle.customnpcs.actions.defaultImpl.RunCommand;
import dev.foxikle.customnpcs.actions.defaultImpl.SendMessage;
import dev.foxikle.customnpcs.actions.defaultImpl.SendServer;
import dev.foxikle.customnpcs.api.events.NpcInteractEvent;
import dev.foxikle.customnpcs.internal.CustomNPCs;
import dev.foxikle.customnpcs.internal.LookAtAnchor;
import dev.foxikle.customnpcs.internal.interfaces.InternalNpc;
import dev.foxikle.customnpcs.internal.menu.HologramMenu;
import dev.foxikle.customnpcs.internal.menu.PoseEditorMenu;
import dev.foxikle.customnpcs.internal.utils.Msg;
import dev.foxikle.customnpcs.internal.utils.SkinUtils;
import dev.foxikle.customnpcs.internal.utils.WaitingType;
import io.github.mqzen.menus.base.MenuView;
import io.papermc.paper.event.world.WorldGameRuleChangeEvent;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.regex.Pattern;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.util.Vector;
import org.mineskin.data.Visibility;
import org.mineskin.exception.MineSkinRequestException;
import org.mineskin.request.GenerateRequest;
import org.mineskin.response.MineSkinResponse;

public class Listeners
implements Listener {
    private static final ConcurrentMap<UUID, MovementData> playerMovementData = new ConcurrentHashMap<UUID, MovementData>();
    private static final int FIVE_BLOCKS = 25;
    private static final int FIFTY_BLOCKS = 2500;
    private static final int SIXTY_BLOCKS = 3600;
    private static final int FORTY_BLOCKS = 2304;
    private static final double HALF_BLOCK = 0.25;
    private static final BukkitScheduler SCHEDULER = Bukkit.getScheduler();
    private static final ConsoleCommandSender CONSOLE_SENDER = Bukkit.getConsoleSender();
    private static final Pattern PATTERN = Pattern.compile(" ");
    private final Map<UUID, Integer> worldSleepingPercentages = new ConcurrentHashMap<UUID, Integer>();
    private final CustomNPCs plugin;
    private ScheduledExecutorService service;

    public Listeners(CustomNPCs plugin) {
        this.plugin = plugin;
    }

    public void start() {
        Bukkit.getWorlds().forEach(world -> this.worldSleepingPercentages.put(world.getUID(), (Integer)world.getGameRuleValue(GameRule.PLAYERS_SLEEPING_PERCENTAGE)));
        this.service = Executors.newSingleThreadScheduledExecutor();
        this.service.scheduleAtFixedRate(() -> Bukkit.getOnlinePlayers().forEach(this::actionPlayerMovement), 1000L, (long)this.plugin.getConfig().getInt("LookInterval") * 50L, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        this.service.shutdown();
        Bukkit.getWorlds().forEach(world -> world.setGameRule(GameRule.PLAYERS_SLEEPING_PERCENTAGE, (Object)this.worldSleepingPercentages.get(world.getUID())));
        CompletableFuture.runAsync(() -> {
            try {
                if (!this.service.awaitTermination(2L, TimeUnit.SECONDS)) {
                    this.service.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.service.shutdownNow();
                Thread.currentThread().interrupt();
            }
            this.plugin.getLogger().info("ScheduledExecutorService successfully shut down!");
        });
    }

    private void actionPlayerMovement(Player player) {
        if (player.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        Location location = player.getLocation();
        World world = player.getWorld();
        UUID uuid = player.getUniqueId();
        for (InternalNpc npc : this.plugin.npcs.values()) {
            World npcWorld;
            if (npc.getTarget() != null || world != (npcWorld = npc.getWorld())) continue;
            this.processPlayerMovement(player, npc, world, npcWorld, location, uuid);
        }
    }

    private void processPlayerMovement(Player player, InternalNpc npc, World world, World npcWorld, Location location, UUID uuid) {
        MovementData oldMovementData;
        if (player.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        Location npcLocation = npc.getCurrentLocation();
        MovementData movementData = (MovementData)playerMovementData.get(uuid);
        double distanceSquared = location.distanceSquared(npcLocation);
        if (movementData == null) {
            playerMovementData.put(uuid, new MovementData(uuid, location, distanceSquared));
            oldMovementData = movementData = (MovementData)playerMovementData.get(uuid);
        } else {
            oldMovementData = movementData;
            movementData.setLastLocation(location);
            movementData.setDistanceSquared(distanceSquared);
        }
        this.trackFromTo(player, npc, movementData, oldMovementData);
        if (npc.getSettings().isTunnelvision()) {
            return;
        }
        if (distanceSquared > 25.0) {
            SCHEDULER.runTask((Plugin)this.plugin, () -> {
                Collection entities = npcWorld.getNearbyEntities(npc.getCurrentLocation(), 2.5, 2.5, 2.5);
                entities.removeIf(entity -> entity.getScoreboardTags().contains("NPC"));
                for (Entity en : entities) {
                    Player p;
                    if (!(en instanceof Player) || (p = (Player)en).getGameMode() == GameMode.SPECTATOR || npc.getSettings().isTunnelvision()) continue;
                    npc.lookAt(LookAtAnchor.HEAD, (Entity)p);
                    return;
                }
                npc.setYRotation(npc.getSpawnLoc().getYaw());
                npc.setXRotation(npc.getSpawnLoc().getPitch());
            });
        }
    }

    private void trackFromTo(Player player, InternalNpc npc, MovementData data, MovementData oldData) {
        if (data.distanceSquared <= 25.0 && !npc.getSettings().isTunnelvision() && player.getGameMode() != GameMode.SPECTATOR) {
            npc.lookAt(LookAtAnchor.HEAD, (Entity)player);
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEntityEvent e) {
        InternalNpc npc;
        Player player = e.getPlayer();
        if (e.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (e.getRightClicked().getType() != EntityType.PLAYER) {
            return;
        }
        Player rightClicked = (Player)e.getRightClicked();
        if (this.plugin.getNPCByID(rightClicked.getUniqueId()) == null) {
            return;
        }
        UUID uuid = rightClicked.getUniqueId();
        try {
            npc = this.plugin.getNPCByID(uuid);
            assert (npc != null);
        }
        catch (IllegalArgumentException ignored) {
            return;
        }
        if (player.hasPermission("customnpcs.edit") && player.isSneaking()) {
            player.performCommand("npc edit " + String.valueOf(uuid));
        } else if (npc.getSettings().isInteractable()) {
            NpcInteractEvent event = new NpcInteractEvent(player, npc);
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            npc.getActions().forEach(action -> SCHEDULER.runTaskLater((Plugin)this.plugin, () -> action.perform(npc, null, player), (long)action.getDelay()));
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onChat(AsyncPlayerChatEvent e) {
        boolean cancel;
        Player player = e.getPlayer();
        String message = e.getMessage();
        boolean bl = cancel = message.equalsIgnoreCase("quit") || message.equalsIgnoreCase("exit") || message.equalsIgnoreCase("stop") || message.equalsIgnoreCase("cancel");
        if (this.plugin.isWaiting(player, WaitingType.COMMAND)) {
            Action actionImpl = this.plugin.editingActions.get(player.getUniqueId());
            if (!(actionImpl instanceof RunCommand)) {
                this.plugin.getLogger().warning("Expected action to be an instance of 'RunCommand', got " + actionImpl.getClass().getSimpleName());
                return;
            }
            RunCommand runCommand = (RunCommand)actionImpl;
            if (cancel) {
                this.plugin.waiting.remove(player.getUniqueId());
                SCHEDULER.runTask((Plugin)this.plugin, () -> this.plugin.getLotus().openMenu(player, actionImpl.getMenu()));
                e.setCancelled(true);
                return;
            }
            this.plugin.waiting.remove(player.getUniqueId());
            runCommand.setCommand(message);
            player.sendMessage(Msg.translate(player.locale(), "customnpcs.actionImpls.set.command", message));
            SCHEDULER.runTask((Plugin)this.plugin, () -> this.plugin.getLotus().openMenu(player, actionImpl.getMenu()));
        } else if (this.plugin.isWaiting(player, WaitingType.NAME)) {
            InternalNpc npc = (InternalNpc)this.plugin.getEditingNPCs().getIfPresent((Object)player.getUniqueId());
            if (npc == null) {
                player.sendMessage(Msg.translate(player.locale(), "customnpcs.error.npc-menu-expired", new Object[0]));
                return;
            }
            if (cancel) {
                this.plugin.waiting.remove(player.getUniqueId());
                SCHEDULER.runTask((Plugin)this.plugin, () -> this.plugin.getLotus().openMenu(player, "npc_holograms"));
                e.setCancelled(true);
                return;
            }
            this.plugin.waiting.remove(player.getUniqueId());
            int index = HologramMenu.editingIndicies.get(player.getUniqueId());
            if (npc.getSettings().getRawHolograms().length <= index) {
                npc.getSettings().setRawHolograms(Arrays.copyOf(npc.getSettings().getRawHolograms(), index + 1));
            }
            npc.getSettings().getRawHolograms()[index] = message;
            player.sendMessage(Msg.translate(player.locale(), "customnpcs.set.name", index + 1, Msg.format(message)));
            SCHEDULER.runTask((Plugin)this.plugin, () -> this.plugin.getLotus().openMenu(player, "npc_holograms"));
        } else if (this.plugin.isWaiting(player, WaitingType.TARGET)) {
            Condition conditional = this.plugin.editingConditionals.get(player.getUniqueId());
            if (cancel) {
                this.plugin.waiting.remove(player.getUniqueId());
                SCHEDULER.runTask((Plugin)this.plugin, () -> this.plugin.getLotus().openMenu(player, "npc_condition_customizer"));
                e.setCancelled(true);
                return;
            }
            if (conditional.getType() == Condition.Type.NUMERIC) {
                try {
                    Double.parseDouble(message);
                }
                catch (NumberFormatException ignored) {
                    player.sendMessage(Msg.translate(player.locale(), "customnpcs.error.parse_number", message));
                    return;
                }
            }
            this.plugin.waiting.remove(player.getUniqueId());
            conditional.setTargetValue(message);
            this.plugin.editingConditionals.put(player.getUniqueId(), conditional);
            player.sendMessage(Msg.translate(player.locale(), "customnpcs.actionImpls.conditions.set.target", message));
            SCHEDULER.runTask((Plugin)this.plugin, () -> this.plugin.getLotus().openMenu(player, "npc_condition_customizer"));
        } else if (this.plugin.isWaiting(player, WaitingType.TITLE)) {
            Action actionImpl = this.plugin.editingActions.get(player.getUniqueId());
            if (!(actionImpl instanceof DisplayTitle)) {
                return;
            }
            DisplayTitle setTitle = (DisplayTitle)actionImpl;
            if (cancel) {
                this.plugin.waiting.remove(player.getUniqueId());
                SCHEDULER.runTask((Plugin)this.plugin, () -> this.plugin.getLotus().openMenu(player, actionImpl.getMenu()));
                e.setCancelled(true);
                return;
            }
            this.plugin.waiting.remove(player.getUniqueId());
            setTitle.setTitle(message);
            player.sendMessage(Msg.translate(player.locale(), "customnpcs.actionImpls.set.title", Msg.format(message)));
            SCHEDULER.runTask((Plugin)this.plugin, () -> this.plugin.getLotus().openMenu(player, actionImpl.getMenu()));
        } else if (this.plugin.isWaiting(player, WaitingType.SUBTITLE)) {
            Action actionImpl = this.plugin.editingActions.get(player.getUniqueId());
            if (!(actionImpl instanceof DisplayTitle)) {
                return;
            }
            DisplayTitle setTitle = (DisplayTitle)actionImpl;
            if (cancel) {
                this.plugin.waiting.remove(player.getUniqueId());
                SCHEDULER.runTask((Plugin)this.plugin, () -> this.plugin.getLotus().openMenu(player, actionImpl.getMenu()));
                e.setCancelled(true);
                return;
            }
            this.plugin.waiting.remove(player.getUniqueId());
            setTitle.setSubTitle(message);
            player.sendMessage(Msg.translate(player.locale(), "customnpcs.actionImpls.set.subtitle", Msg.format(message)));
            SCHEDULER.runTask((Plugin)this.plugin, () -> this.plugin.getLotus().openMenu(player, actionImpl.getMenu()));
        } else if (this.plugin.isWaiting(player, WaitingType.MESSAGE)) {
            Action actionImpl = this.plugin.editingActions.get(player.getUniqueId());
            if (!(actionImpl instanceof SendMessage)) {
                return;
            }
            SendMessage sendMessage = (SendMessage)actionImpl;
            if (cancel) {
                this.plugin.waiting.remove(player.getUniqueId());
                SCHEDULER.runTask((Plugin)this.plugin, () -> this.plugin.getLotus().openMenu(player, actionImpl.getMenu()));
                e.setCancelled(true);
                return;
            }
            this.plugin.waiting.remove(player.getUniqueId());
            sendMessage.setRawMessage(message);
            player.sendMessage(Msg.translate(player.locale(), "customnpcs.actionImpls.set.message", Msg.format(message)));
            SCHEDULER.runTask((Plugin)this.plugin, () -> this.plugin.getLotus().openMenu(player, actionImpl.getMenu()));
        } else if (this.plugin.isWaiting(player, WaitingType.SERVER)) {
            Action actionImpl = this.plugin.editingActions.get(player.getUniqueId());
            if (!(actionImpl instanceof SendServer)) {
                return;
            }
            SendServer runServer = (SendServer)actionImpl;
            if (cancel) {
                this.plugin.waiting.remove(player.getUniqueId());
                SCHEDULER.runTask((Plugin)this.plugin, () -> this.plugin.getLotus().openMenu(player, actionImpl.getMenu()));
                e.setCancelled(true);
                return;
            }
            this.plugin.waiting.remove(player.getUniqueId());
            runServer.setServer(message);
            player.sendMessage(Msg.translate(player.locale(), "customnpcs.actionImpls.set.server", Msg.format(message)));
            SCHEDULER.runTask((Plugin)this.plugin, () -> this.plugin.getLotus().openMenu(player, actionImpl.getMenu()));
        } else if (this.plugin.isWaiting(player, WaitingType.ACTIONBAR)) {
            Action actionImpl = this.plugin.editingActions.get(player.getUniqueId());
            if (!(actionImpl instanceof ActionBar)) {
                return;
            }
            ActionBar actionBar = (ActionBar)actionImpl;
            if (cancel) {
                this.plugin.waiting.remove(player.getUniqueId());
                SCHEDULER.runTask((Plugin)this.plugin, () -> this.plugin.getLotus().openMenu(player, actionImpl.getMenu()));
                e.setCancelled(true);
                return;
            }
            this.plugin.waiting.remove(player.getUniqueId());
            actionBar.setRawMessage(message);
            player.sendMessage(Msg.translate(player.locale(), "customnpcs.actionImpls.set.actionbar", Msg.format(message)));
            SCHEDULER.runTask((Plugin)this.plugin, () -> this.plugin.getLotus().openMenu(player, actionImpl.getMenu()));
        } else if (this.plugin.isWaiting(player, WaitingType.PLAYER)) {
            if (cancel) {
                this.plugin.waiting.remove(player.getUniqueId());
                SCHEDULER.runTask((Plugin)this.plugin, () -> this.plugin.getLotus().openMenu(player, "npc_skin"));
                e.setCancelled(true);
                return;
            }
            InternalNpc npc = (InternalNpc)this.plugin.getEditingNPCs().getIfPresent((Object)player.getUniqueId());
            if (npc == null) {
                player.sendMessage(Msg.translate(player.locale(), "customnpcs.error.npc-menu-expired", new Object[0]));
                return;
            }
            player.sendMessage(Msg.translate(player.locale(), "customnpcs.skins.fetching.player", message));
            String name = e.getMessage();
            try {
                URL url = new URL("https://api.mojang.com/users/profiles/minecraft/" + name);
                InputStreamReader reader = new InputStreamReader(url.openStream());
                String uuid = new JsonParser().parse((Reader)reader).getAsJsonObject().get("id").getAsString();
                reader.close();
                URL url2 = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid + "?unsigned=false");
                reader = new InputStreamReader(url2.openStream());
                JsonObject property = new JsonParser().parse((Reader)reader).getAsJsonObject().get("properties").getAsJsonArray().get(0).getAsJsonObject();
                String value = property.get("value").getAsString();
                String signature = property.get("signature").getAsString();
                npc.getSettings().setSkinData(signature, value, Msg.translatedString(player.locale(), "customnpcs.skins.imported_by.player_name", Msg.format(name)));
            }
            catch (Exception ignored) {
                player.sendMessage(Msg.translate(player.locale(), "customnpcs.skins.errors.player_does_not_exist", name));
                e.setCancelled(true);
                return;
            }
            this.plugin.waiting.remove(player.getUniqueId());
            player.sendMessage(Msg.translate(player.locale(), "customnpcs.skins.success.player_name", name));
            SCHEDULER.runTask((Plugin)this.plugin, () -> this.plugin.getLotus().openMenu(player, "npc_skin"));
        } else if (this.plugin.isWaiting(player, WaitingType.URL)) {
            if (cancel) {
                this.plugin.waiting.remove(player.getUniqueId());
                SCHEDULER.runTask((Plugin)this.plugin, () -> this.plugin.getLotus().openMenu(player, "npc_skin"));
                e.setCancelled(true);
                return;
            }
            InternalNpc npc = (InternalNpc)this.plugin.getEditingNPCs().getIfPresent((Object)player.getUniqueId());
            if (npc == null) {
                player.sendMessage(Msg.translate(player.locale(), "customnpcs.error.npc-menu-expired", new Object[0]));
                return;
            }
            e.setCancelled(true);
            player.sendMessage(Msg.translate(player.locale(), "customnpcs.skins.fetching.url", new Object[0]));
            try {
                URL url = new URL(message);
                GenerateRequest request = GenerateRequest.url((URL)url).name("URL Generated Skin").visibility(Visibility.UNLISTED);
                ((CompletableFuture)SkinUtils.fetch(request).thenAccept(skin -> {
                    npc.getSettings().setSkinData(skin.texture().data().signature(), skin.texture().data().value(), Msg.translatedString(player.locale(), "customnpcs.skins.imported_by.url", new Object[0]));
                    this.plugin.waiting.remove(player.getUniqueId());
                    player.sendMessage(Msg.translate(player.locale(), "customnpcs.skins.success.url", message));
                    SCHEDULER.runTask((Plugin)this.plugin, () -> this.plugin.getLotus().openMenu(player, "npc_skin"));
                })).exceptionally(throwable -> {
                    if (throwable instanceof CompletionException) {
                        CompletionException completionException = (CompletionException)throwable;
                        throwable = completionException.getCause();
                    }
                    if (throwable instanceof MineSkinRequestException) {
                        MineSkinRequestException requestException = (MineSkinRequestException)throwable;
                        MineSkinResponse response = requestException.getResponse();
                        Optional detailsOptional = response.getErrorOrMessage();
                        Throwable finalThrowable = throwable;
                        detailsOptional.ifPresent(details -> {
                            this.plugin.getLogger().log(Level.SEVERE, details.code() + " : " + String.valueOf(details), finalThrowable);
                            System.out.println(details.code() + ": " + details.message());
                        });
                    }
                    if (throwable.getMessage().equalsIgnoreCase("java.lang.RuntimeException: org.mineskin.data.MineskinException: Failed to find image from url")) {
                        player.sendMessage(Msg.translate(player.locale(), "customnpcs.skins.errors.no_image_data", new Object[0]));
                        return null;
                    }
                    player.sendMessage(Msg.translate(player.locale(), "customnpcs.skins.errors.unknown_url_error", new Object[0]));
                    this.plugin.getLogger().log(Level.SEVERE, "An error occurred whilst parsing this skin from a url.", (Throwable)throwable);
                    return null;
                });
            }
            catch (Exception ex) {
                player.sendMessage(Msg.translate(player.locale(), "customnpcs.skins.errors.invalid_url", new Object[0]));
            }
        } else if (this.plugin.isWaiting(player, WaitingType.HOLOGRAM)) {
            if (cancel) {
                this.plugin.waiting.remove(player.getUniqueId());
                SCHEDULER.runTask((Plugin)this.plugin, () -> this.plugin.getLotus().openMenu(player, "npc_extra_settings"));
                e.setCancelled(true);
                return;
            }
            InternalNpc npc = (InternalNpc)this.plugin.getEditingNPCs().getIfPresent((Object)player.getUniqueId());
            if (npc == null) {
                player.sendMessage(Msg.translate(player.locale(), "customnpcs.error.npc-menu-expired", new Object[0]));
                return;
            }
            this.plugin.waiting.remove(player.getUniqueId());
            e.setCancelled(true);
            player.sendMessage(Msg.translate(player.locale(), "customnpcs.set.clickable_hologram", Msg.format(message)));
            npc.getSettings().setCustomInteractableHologram(message);
            SCHEDULER.runTask((Plugin)this.plugin, () -> this.plugin.getLotus().openMenu(player, "npc_extra_settings"));
        } else if (this.plugin.isWaiting(player, WaitingType.FACING)) {
            e.setCancelled(true);
            this.plugin.waiting.remove(player.getUniqueId());
            if (cancel) {
                return;
            }
            InternalNpc npc = (InternalNpc)this.plugin.getEditingNPCs().getIfPresent((Object)player.getUniqueId());
            if (npc == null) {
                player.sendMessage(Msg.translate(player.locale(), "customnpcs.error.npc-menu-expired", new Object[0]));
                return;
            }
            if (message.equalsIgnoreCase("confirm")) {
                npc.getSettings().setDirection(player.getLocation().getYaw());
                npc.getSpawnLoc().setPitch(player.getLocation().getPitch());
                npc.getSpawnLoc().setYaw(player.getLocation().getYaw());
                player.sendMessage(Msg.translate(player.locale(), "customnpcs.set.facing_direction", new Object[0]));
                player.playSound((Entity)player, Sound.BLOCK_AMETHYST_BLOCK_BREAK, 1.0f, 1.0f);
                SCHEDULER.runTask((Plugin)this.plugin, () -> this.plugin.getLotus().openMenu(player, "npc_main"));
            }
        } else {
            return;
        }
        e.setCancelled(true);
    }

    @EventHandler
    public void onPlayerLogin(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        if (this.plugin.update && this.plugin.getConfig().getBoolean("AlertOnUpdate") && player.hasPermission("customnpcs.alert")) {
            player.sendMessage(Msg.translate(player.locale(), "customnpcs.should_update", new Object[0]));
        }
        this.recalcSleepingPercentages();
        if (player.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        Location location = player.getLocation();
        World world = player.getWorld();
        for (InternalNpc npc : this.plugin.npcs.values()) {
            double distanceSquared;
            Location spawnLocation = npc.getSpawnLoc();
            if (world != npc.getWorld() || !((distanceSquared = location.distanceSquared(spawnLocation)) <= 25.0) || npc.getSettings().isTunnelvision()) continue;
            npc.lookAt(LookAtAnchor.HEAD, (Entity)player);
        }
    }

    @EventHandler
    public void onVelocity(PlayerVelocityEvent e) {
        this.actionPlayerMovement(e.getPlayer());
    }

    @EventHandler
    public void onTeleport(PlayerTeleportEvent e) {
        this.recalcSleepingPercentages();
        Player player = e.getPlayer();
        if (player.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        Location location = player.getLocation();
        World world = player.getWorld();
        for (InternalNpc npc : this.plugin.npcs.values()) {
            double distanceSquared;
            Location spawnLocation = npc.getSpawnLoc();
            if (world != npc.getWorld() || !((distanceSquared = location.distanceSquared(spawnLocation)) <= 25.0) || npc.getSettings().isTunnelvision()) continue;
            npc.lookAt(LookAtAnchor.HEAD, (Entity)player);
        }
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent e) {
        Player player = e.getPlayer();
        if (player.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        Location location = player.getLocation();
        World world = player.getWorld();
        for (InternalNpc npc : this.plugin.npcs.values()) {
            Location spawnLocation = npc.getSpawnLoc();
            if (world != npc.getWorld()) {
                return;
            }
            double distanceSquared = location.distanceSquared(spawnLocation);
            if (distanceSquared <= 2500.0) {
                SCHEDULER.runTaskLater((Plugin)this.plugin, () -> npc.injectPlayer(player), 5L);
            }
            if (!(distanceSquared <= 25.0) || npc.getSettings().isTunnelvision()) continue;
            npc.lookAt(LookAtAnchor.HEAD, (Entity)player);
        }
    }

    @EventHandler
    public void onDimensionChange(PlayerChangedWorldEvent e) {
        Player player = e.getPlayer();
        if (player.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        Location location = player.getLocation();
        World world = player.getWorld();
        for (InternalNpc npc : this.plugin.npcs.values()) {
            double distanceSquared;
            Location spawnLocation = npc.getSpawnLoc();
            if (world != npc.getWorld() || !((distanceSquared = location.distanceSquared(spawnLocation)) <= 25.0) || npc.getSettings().isTunnelvision()) continue;
            npc.lookAt(LookAtAnchor.HEAD, (Entity)player);
        }
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent e) {
        this.plugin.waiting.remove(e.getPlayer().getUniqueId());
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, this::recalcSleepingPercentages, 1L);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onClick(InventoryClickEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Player clicker = (Player)e.getWhoClicked();
        MenuView menu = this.plugin.getLotus().getMenuView(clicker.getUniqueId()).orElseGet(() -> {
            if (e.getClickedInventory() == null) {
                return null;
            }
            InventoryHolder patt0$temp = e.getClickedInventory().getHolder();
            if (patt0$temp instanceof MenuView) {
                MenuView playerMenu = (MenuView)patt0$temp;
                return playerMenu;
            }
            return null;
        });
        if (menu != null && e.getClick() == ClickType.DOUBLE_CLICK) {
            e.setCancelled(true);
        }
    }

    private void recalcSleepingPercentages() {
        Bukkit.getWorlds().forEach(world -> {
            if (world == null) {
                return;
            }
            int target = this.worldSleepingPercentages.get(world.getUID());
            int npcCount = this.plugin.getNPCs().stream().filter(npc -> npc.getWorld() == world).toList().size();
            int playercount = world.getPlayers().size();
            if (npcCount == 0) {
                world.setGameRule(GameRule.PLAYERS_SLEEPING_PERCENTAGE, (Object)target);
                return;
            }
            world.setGameRule(GameRule.PLAYERS_SLEEPING_PERCENTAGE, (Object)((int)((double)(playercount - npcCount) / (double)playercount * (double)target)));
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onGameruleChange(WorldGameRuleChangeEvent event) {
        if (event.getCommandSender() == null) {
            return;
        }
        if (!event.getGameRule().equals((Object)GameRule.PLAYERS_SLEEPING_PERCENTAGE)) {
            return;
        }
        this.worldSleepingPercentages.put(event.getWorld().getUID(), Integer.parseInt(event.getValue()));
        this.recalcSleepingPercentages();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onScroll(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        if (!this.plugin.isWaiting(player, WaitingType.NUDGE)) {
            return;
        }
        if (this.plugin.getEditingNPCs().getIfPresent((Object)player.getUniqueId()) == null) {
            player.sendMessage(Msg.translate(player.locale(), "customnpcs.error.npc-menu-expired", new Object[0]));
            this.plugin.waiting.remove(player.getUniqueId());
            return;
        }
        InternalNpc npc = PoseEditorMenu.previewNPCs.get(player.getUniqueId());
        if (npc == null) {
            return;
        }
        int delta = (event.getNewSlot() - event.getPreviousSlot() + 9) % 9;
        double multiplier = delta <= 4 ? -0.05 : 0.05;
        multiplier = player.isSneaking() ? multiplier * 5.0 : multiplier;
        BlockFace face = player.getFacing();
        if (player.getLocation().getPitch() < -45.0f) {
            face = BlockFace.UP;
        }
        if (player.getLocation().getPitch() > 45.0f) {
            face = BlockFace.DOWN;
        }
        Vector vec = face.getDirection().multiply(multiplier);
        player.playSound((Entity)player, Sound.ITEM_FLINTANDSTEEL_USE, 1.0f, 1.0f);
        npc.getWorld().spawnParticle(Particle.REVERSE_PORTAL, npc.getCurrentLocation().add(vec), 10, 0.0, 0.0, 0.0, 0.0);
        npc.moveTo(vec);
    }

    @EventHandler
    public void onSwapToOffhand(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.isWaiting(player, WaitingType.NUDGE)) {
            event.setCancelled(true);
            InternalNpc npc = (InternalNpc)this.plugin.getEditingNPCs().getIfPresent((Object)player.getUniqueId());
            if (npc == null) {
                player.sendMessage(Msg.translate(player.locale(), "customnpcs.error.npc-menu-expired", new Object[0]));
                return;
            }
            InternalNpc previewNpc = PoseEditorMenu.previewNPCs.get(player.getUniqueId());
            this.plugin.waiting.remove(player.getUniqueId());
            Location finalLoc = previewNpc.getCurrentLocation();
            finalLoc.setPitch(npc.getSpawnLoc().getPitch());
            finalLoc.setYaw(npc.getSpawnLoc().getYaw());
            npc.setSpawnLoc(finalLoc);
            previewNpc.remove();
            this.plugin.getNPCByID(npc.getUniqueID()).createNPC();
            this.plugin.getLotus().openMenu(player, "npc_main");
        }
    }

    private static class MovementData {
        private final UUID uniqueId;
        private Location lastLocation;
        private double distanceSquared;

        MovementData(UUID uniqueId, Location lastLocation, double distanceSquared) {
            this.uniqueId = uniqueId;
            this.lastLocation = lastLocation;
            this.distanceSquared = distanceSquared;
        }

        public MovementData copy() {
            return new MovementData(this.uniqueId, this.lastLocation, this.distanceSquared);
        }

        @Generated
        public UUID getUniqueId() {
            return this.uniqueId;
        }

        @Generated
        public Location getLastLocation() {
            return this.lastLocation;
        }

        @Generated
        public double getDistanceSquared() {
            return this.distanceSquared;
        }

        @Generated
        public void setLastLocation(Location lastLocation) {
            this.lastLocation = lastLocation;
        }

        @Generated
        public void setDistanceSquared(double distanceSquared) {
            this.distanceSquared = distanceSquared;
        }
    }
}

