/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.internal.menu;

import dev.foxikle.customnpcs.actions.Action;
import dev.foxikle.customnpcs.internal.CustomNPCs;
import dev.foxikle.customnpcs.internal.menu.MenuItems;
import io.github.mqzen.menus.base.Content;
import io.github.mqzen.menus.base.Menu;
import io.github.mqzen.menus.base.MenuView;
import io.github.mqzen.menus.misc.Capacity;
import io.github.mqzen.menus.misc.DataRegistry;
import io.github.mqzen.menus.titles.MenuTitle;
import io.github.mqzen.menus.titles.MenuTitles;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.jetbrains.annotations.NotNull;

public class ActionCustomizerMenu
implements Menu {
    public void onOpen(MenuView<?> playerMenuView, InventoryOpenEvent event) {
        event.setCancelled(true);
        Player player = playerMenuView.getPlayer().orElse(null);
        if (player == null) {
            return;
        }
        CustomNPCs plugin = CustomNPCs.getInstance();
        Action action = plugin.editingActions.get(player.getUniqueId());
        if (action == null) {
            return;
        }
        plugin.getLotus().openMenu(player, action.getMenu());
    }

    @NotNull
    public Content getContent(DataRegistry extraData, Player opener, Capacity capacity) {
        return Content.builder((Capacity)capacity).apply(content -> content.fill(MenuItems.MENU_GLASS)).build();
    }

    @NotNull
    public Capacity getCapacity(DataRegistry extraData, Player opener) {
        return Capacity.ofRows((int)5);
    }

    @NotNull
    public MenuTitle getTitle(DataRegistry extraData, Player opener) {
        return MenuTitles.createModern((Component)Component.empty());
    }

    public String getName() {
        return "npc_action_customizer";
    }
}

