/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.internal.menu;

import dev.foxikle.customnpcs.internal.CustomNPCs;
import dev.foxikle.customnpcs.internal.interfaces.InternalNpc;
import dev.foxikle.customnpcs.internal.menu.HologramMenu;
import dev.foxikle.customnpcs.internal.menu.MenuItems;
import dev.foxikle.customnpcs.internal.utils.Msg;
import dev.foxikle.customnpcs.internal.utils.Utils;
import io.github.mqzen.menus.base.Content;
import io.github.mqzen.menus.base.Menu;
import io.github.mqzen.menus.misc.Capacity;
import io.github.mqzen.menus.misc.DataRegistry;
import io.github.mqzen.menus.misc.button.Button;
import io.github.mqzen.menus.misc.button.actions.ButtonClickAction;
import io.github.mqzen.menus.misc.itembuilder.ComponentItemBuilder;
import io.github.mqzen.menus.misc.itembuilder.ItemBuilder;
import io.github.mqzen.menus.titles.MenuTitle;
import io.github.mqzen.menus.titles.MenuTitles;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class DeleteLineMenu
implements Menu {
    public String getName() {
        return "npc_delete_line";
    }

    @NotNull
    public MenuTitle getTitle(DataRegistry dataRegistry, Player player) {
        return MenuTitles.createModern((Component)Msg.translate(player.locale(), "customnpcs.menus.hologram.delete.title", new Object[0]));
    }

    @NotNull
    public Capacity getCapacity(DataRegistry dataRegistry, Player player) {
        return Capacity.ofRows((int)3);
    }

    @NotNull
    public Content getContent(DataRegistry dataRegistry, Player player, Capacity capacity) {
        CustomNPCs plugin = CustomNPCs.getInstance();
        InternalNpc npcFor = (InternalNpc)plugin.getEditingNPCs().getIfPresent((Object)player.getUniqueId());
        int index = HologramMenu.editingIndicies.getOrDefault(player.getUniqueId(), -1);
        if (npcFor == null || index < 0 || npcFor.getSettings().getHolograms().length <= index) {
            player.sendMessage(Msg.translate(player.locale(), "customnpcs.error.npc-menu-expired", new Object[0]));
            player.playSound((Entity)player, Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
            return Content.empty((Capacity)capacity);
        }
        return Content.builder((Capacity)capacity).apply(content -> content.fill(MenuItems.MENU_GLASS)).setButton(11, Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.RED_STAINED_GLASS_PANE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.hologram.delete.confirm", new Object[0]))).setLore((Object[])Msg.lore(player.locale(), "customnpcs.menus.hologram.delete.confirm.lore", npcFor.getSettings().getHolograms()[index]))).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, inventoryClickEvent) -> {
            Player p = (Player)inventoryClickEvent.getWhoClicked();
            InternalNpc npc = (InternalNpc)plugin.getEditingNPCs().getIfPresent((Object)p.getUniqueId());
            if (npc == null) {
                p.closeInventory();
                p.sendMessage(Msg.translate(player.locale(), "customnpcs.error.npc-menu-expired", new Object[0]));
                p.playSound((Entity)p, Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                return;
            }
            String[] raw = npc.getSettings().getRawHolograms();
            List<String> mutable = Utils.list(raw);
            if (index >= raw.length) {
                p.playSound((Entity)p, Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                p.sendMessage(Msg.translate(player.locale(), "customnpcs.error.npc-menu-expired", new Object[0]));
                return;
            }
            mutable.remove(index);
            player.playSound(p.getLocation(), Sound.ITEM_TRIDENT_HIT, 1.0f, 1.0f);
            npc.getSettings().setRawHolograms(mutable.toArray(new String[0]));
            plugin.getLotus().openMenu(p, "npc_holograms");
        }))).setButton(15, Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.LIME_STAINED_GLASS_PANE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.items.go_back", new Object[0]))).setLore((Object[])new Component[]{Msg.translate(player.locale(), "customnpcs.menus.hologram.delete.to_safety", new Object[0])})).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, inventoryClickEvent) -> {
            InternalNpc npc = (InternalNpc)plugin.getEditingNPCs().getIfPresent((Object)player.getUniqueId());
            Player p = (Player)inventoryClickEvent.getWhoClicked();
            p.playSound((Entity)p, Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            if (npc == null) {
                player.closeInventory(InventoryCloseEvent.Reason.PLUGIN);
                player.sendMessage(Msg.translate(player.locale(), "customnpcs.error.npc-menu-expired", new Object[0]));
                return;
            }
            plugin.getLotus().openMenu(p, "npc_holograms");
        }))).build();
    }
}

