/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.internal.menu;

import dev.foxikle.customnpcs.api.events.NpcDeleteEvent;
import dev.foxikle.customnpcs.internal.CustomNPCs;
import dev.foxikle.customnpcs.internal.interfaces.InternalNpc;
import dev.foxikle.customnpcs.internal.menu.MenuItems;
import dev.foxikle.customnpcs.internal.utils.Msg;
import io.github.mqzen.menus.base.Content;
import io.github.mqzen.menus.base.Menu;
import io.github.mqzen.menus.misc.Capacity;
import io.github.mqzen.menus.misc.DataRegistry;
import io.github.mqzen.menus.misc.button.Button;
import io.github.mqzen.menus.misc.button.actions.ButtonClickAction;
import io.github.mqzen.menus.misc.itembuilder.ComponentItemBuilder;
import io.github.mqzen.menus.misc.itembuilder.ItemBuilder;
import io.github.mqzen.menus.titles.MenuTitle;
import io.github.mqzen.menus.titles.MenuTitles;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class DeleteMenu
implements Menu {
    public String getName() {
        return "npc_delete";
    }

    public InventoryType getMenuType() {
        return InventoryType.CHEST;
    }

    @NotNull
    public MenuTitle getTitle(DataRegistry dataRegistry, Player player) {
        return MenuTitles.createModern((Component)Msg.translate(player.locale(), "customnpcs.menus.delete.title", new Object[0]));
    }

    @NotNull
    public Capacity getCapacity(DataRegistry dataRegistry, Player player) {
        return Capacity.ofRows((int)3);
    }

    @NotNull
    public Content getContent(DataRegistry dataRegistry, Player player, Capacity capacity) {
        return Content.builder((Capacity)capacity).apply(content -> content.fill(MenuItems.MENU_GLASS)).setButton(11, Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.RED_STAINED_GLASS_PANE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.delete.items.confirm.name", new Object[0]))).setLore((Object[])new Component[]{Component.empty(), Msg.translate(player.locale(), "customnpcs.menus.delete.items.confirm.lore", new Object[0])})).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, inventoryClickEvent) -> {
            CustomNPCs plugin = CustomNPCs.getInstance();
            Player player1 = (Player)inventoryClickEvent.getWhoClicked();
            InternalNpc dontUse = (InternalNpc)plugin.getEditingNPCs().getIfPresent((Object)player1.getUniqueId());
            if (dontUse == null) {
                player1.closeInventory();
                player1.sendMessage(Msg.translate(player.locale(), "customnpcs.error.npc-menu-expired", new Object[0]));
                player1.playSound((Entity)player1, Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                return;
            }
            InternalNpc npc = plugin.getNPCByID(dontUse.getUniqueID());
            if (npc == null) {
                player1.closeInventory();
                player1.playSound((Entity)player1, Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                player1.sendMessage(Msg.translate(player.locale(), "customnpcs.error.npc-menu-expired", new Object[0]));
                return;
            }
            Boolean openMenu = (Boolean)plugin.getDeltionReason().getIfPresent((Object)player1.getUniqueId());
            NpcDeleteEvent.DeletionSource source = openMenu == null ? NpcDeleteEvent.DeletionSource.UNKNOWN : (openMenu != false ? NpcDeleteEvent.DeletionSource.MENU : NpcDeleteEvent.DeletionSource.COMMAND);
            NpcDeleteEvent event = new NpcDeleteEvent(player1, npc, source);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                player1.sendMessage(Msg.translate(player.locale(), "customnpcs.delete.failed_api", new Object[0]));
                return;
            }
            npc.remove();
            npc.delete();
            plugin.npcs.remove(npc.getUniqueID());
            player1.sendMessage(Msg.translate(player.locale(), "customnpcs.delete.success", npc.getSettings().getName()));
            player1.closeInventory();
            player1.playSound((Entity)player1, Sound.BLOCK_END_PORTAL_SPAWN, 1.0f, 1.0f);
            npc.getCurrentLocation().getWorld().strikeLightningEffect(npc.getCurrentLocation());
        }))).setButton(15, Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.LIME_STAINED_GLASS_PANE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.items.go_back", new Object[0]))).setLore((Object[])new Component[]{Msg.translate(player.locale(), "customnpcs.menus.delete.items.to_safety", new Object[0])})).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, inventoryClickEvent) -> {
            CustomNPCs plugin = CustomNPCs.getInstance();
            InternalNpc npc = (InternalNpc)plugin.getEditingNPCs().getIfPresent((Object)player.getUniqueId());
            Player player1 = (Player)inventoryClickEvent.getWhoClicked();
            player1.playSound((Entity)player1, Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            if (npc == null) {
                player.closeInventory(InventoryCloseEvent.Reason.PLUGIN);
                player.sendMessage(Msg.translate(player.locale(), "customnpcs.error.npc-menu-expired", new Object[0]));
                return;
            }
            Boolean openMenu = (Boolean)plugin.getDeltionReason().getIfPresent((Object)player1.getUniqueId());
            if (openMenu == null) {
                player.closeInventory(InventoryCloseEvent.Reason.PLUGIN);
                player.sendMessage(Msg.translate(player.locale(), "customnpcs.error.forgot_bailout_response", new Object[0]));
                return;
            }
            if (openMenu.booleanValue()) {
                plugin.getLotus().openMenu(player1, "npc_main");
                return;
            }
            player1.closeInventory();
        }))).build();
    }
}

