/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.internal.menu;

import dev.foxikle.customnpcs.internal.CustomNPCs;
import dev.foxikle.customnpcs.internal.interfaces.InternalNpc;
import dev.foxikle.customnpcs.internal.menu.MenuItems;
import dev.foxikle.customnpcs.internal.runnables.FacingDirectionRunnable;
import dev.foxikle.customnpcs.internal.utils.Msg;
import dev.foxikle.customnpcs.internal.utils.OpenButtonAction;
import dev.foxikle.customnpcs.internal.utils.WaitingType;
import io.github.mqzen.menus.base.Content;
import io.github.mqzen.menus.base.Menu;
import io.github.mqzen.menus.misc.Capacity;
import io.github.mqzen.menus.misc.DataRegistry;
import io.github.mqzen.menus.misc.button.Button;
import io.github.mqzen.menus.misc.button.actions.ButtonClickAction;
import io.github.mqzen.menus.misc.button.actions.impl.CloseMenuAction;
import io.github.mqzen.menus.misc.itembuilder.ComponentItemBuilder;
import io.github.mqzen.menus.misc.itembuilder.ItemBuilder;
import io.github.mqzen.menus.titles.MenuTitle;
import io.github.mqzen.menus.titles.MenuTitles;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class MainNPCMenu
implements Menu {
    public String getName() {
        return "npc_main";
    }

    @NotNull
    public MenuTitle getTitle(DataRegistry dataRegistry, Player player) {
        return MenuTitles.createModern((Component)Msg.translate(player.locale(), "customnpcs.menus.main.title", new Object[0]));
    }

    @NotNull
    public Capacity getCapacity(DataRegistry dataRegistry, Player player) {
        return Capacity.ofRows((int)5);
    }

    @NotNull
    public Content getContent(DataRegistry dataRegistry, Player player, Capacity capacity) {
        CustomNPCs plugin = CustomNPCs.getInstance();
        InternalNpc npc = (InternalNpc)plugin.getEditingNPCs().getIfPresent((Object)player.getUniqueId());
        if (npc == null) {
            return Content.builder((Capacity)capacity).setButton(22, Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.RED_STAINED_GLASS_PANE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.main.error.no_npc", new Object[0]))).setLore((Object[])Msg.lore(player.locale(), "customnpcs.menus.main.error.no_npc.lore", new Object[0]))).build(), (ButtonClickAction)new CloseMenuAction())).build();
        }
        Content.Builder builder = Content.builder((Capacity)capacity);
        builder.apply(content -> content.fill(MenuItems.MENU_GLASS)).setButton(10, Button.clickable((ItemStack)MenuItems.looking(player), (ButtonClickAction)ButtonClickAction.plain((menuView, inventoryClickEvent) -> {
            player.playSound((Entity)player, Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            plugin.wait(player, WaitingType.FACING);
            new FacingDirectionRunnable(plugin, player).go();
            player.closeInventory();
        }))).setButton(8, Button.clickable((ItemStack)MenuItems.extraSettings(player), (ButtonClickAction)new OpenButtonAction("npc_extra_settings"))).setButton(0, MenuItems.toPose(player)).setButton(13, Button.clickable((ItemStack)MenuItems.skinSelection(npc, player), (ButtonClickAction)new OpenButtonAction("npc_skin"))).setButton(16, MenuItems.changeLines(npc, player)).setButton(19, Button.clickable((ItemStack)MenuItems.editEquipment(npc, player), (ButtonClickAction)new OpenButtonAction("npc_equipment"))).setButton(22, MenuItems.resilient(npc, player)).setButton(25, MenuItems.interactable(npc, player)).setButton(34, MenuItems.showActions(npc, player)).setButton(28, MenuItems.tunnelVision(npc, player)).setButton(31, Button.clickable((ItemStack)MenuItems.confirmCreation(player), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
            event.setCancelled(true);
            Player p = (Player)event.getWhoClicked();
            Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> p.playSound(p.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f), 1L);
            Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> p.playSound(p.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f), 3L);
            Bukkit.getScheduler().runTaskLater((Plugin)plugin, npc::createNPC, 1L);
            p.spawnParticle(npc.getSpawnParticle(), npc.getSpawnLoc().clone().add(0.0, 1.0, 0.0), 1);
            if (npc.getSettings().isResilient()) {
                p.sendMessage(Msg.translate(player.locale(), "customnpcs.menus.main.create.message.resilient", new Object[0]));
            } else {
                p.sendMessage(Msg.translate(player.locale(), "customnpcs.menus.main.create.message.temporary", new Object[0]));
            }
            npc.reloadSettings();
            p.closeInventory();
        }))).setButton(36, Button.clickable((ItemStack)MenuItems.cancelCreation(player), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
            event.setCancelled(true);
            Player p = (Player)event.getWhoClicked();
            p.playSound(p.getLocation(), Sound.BLOCK_GLASS_BREAK, 1.0f, 1.0f);
            p.sendMessage(Msg.translate(player.locale(), "customnpcs.menus.main.cancel.message", new Object[0]));
            p.closeInventory();
        })));
        if (plugin.getNPCByID(npc.getUniqueID()) != null) {
            builder.setButton(44, Button.clickable((ItemStack)MenuItems.deleteNpc(player), (ButtonClickAction)ButtonClickAction.plain((menu, event) -> {
                Player p = (Player)event.getWhoClicked();
                plugin.getDeltionReason().put((Object)p.getUniqueId(), (Object)true);
                plugin.getLotus().openMenu(p, "npc_delete");
                p.playSound((Entity)p, Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            })));
        }
        return builder.build();
    }
}

