/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.internal.menu;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import dev.foxikle.customnpcs.actions.Action;
import dev.foxikle.customnpcs.actions.conditions.Condition;
import dev.foxikle.customnpcs.actions.conditions.LogicalCondition;
import dev.foxikle.customnpcs.actions.conditions.NumericCondition;
import dev.foxikle.customnpcs.data.Equipment;
import dev.foxikle.customnpcs.internal.CustomNPCs;
import dev.foxikle.customnpcs.internal.interfaces.InternalNpc;
import dev.foxikle.customnpcs.internal.menu.HologramMenu;
import dev.foxikle.customnpcs.internal.runnables.InteractableHologramRunnable;
import dev.foxikle.customnpcs.internal.runnables.NameRunnable;
import dev.foxikle.customnpcs.internal.runnables.PlayerNameRunnable;
import dev.foxikle.customnpcs.internal.runnables.TargetInputRunnable;
import dev.foxikle.customnpcs.internal.runnables.UrlRunnable;
import dev.foxikle.customnpcs.internal.utils.Msg;
import dev.foxikle.customnpcs.internal.utils.OpenButtonAction;
import dev.foxikle.customnpcs.internal.utils.Utils;
import dev.foxikle.customnpcs.internal.utils.WaitingType;
import io.github.mqzen.menus.base.pagination.exception.InvalidPageException;
import io.github.mqzen.menus.misc.button.Button;
import io.github.mqzen.menus.misc.button.actions.ButtonClickAction;
import io.github.mqzen.menus.misc.itembuilder.ComponentItemBuilder;
import io.github.mqzen.menus.misc.itembuilder.ItemBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;

public class MenuItems {
    public static final Button MENU_GLASS;
    private static final CustomNPCs plugin;

    public static Button changeLines(InternalNpc npc, Player player) {
        TextComponent lines = Component.empty();
        for (int i = 0; i < npc.getSettings().getHolograms().length; ++i) {
            Component holo = npc.getSettings().getHolograms()[i];
            lines = lines.append(Msg.format("   <dark_gray>" + (i + 1) + ". ").append(holo)).append((Component)Component.newline());
        }
        Object[] lore = Msg.vlore(player.locale(), "customnpcs.menus.main.items.name.current_name", 100, lines);
        return Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.NAME_TAG).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.main.items.name.name", new Object[0]))).setLore(lore)).build(), (ButtonClickAction)new OpenButtonAction("npc_holograms"));
    }

    public static Button resilient(InternalNpc npc, Player player) {
        ItemStack i = ((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.BELL).setLore((Object[])new Component[]{npc.getSettings().isResilient() ? Msg.translate(player.locale(), "customnpcs.menus.main.items.resilient.true", new Object[0]) : Msg.translate(player.locale(), "customnpcs.menus.main.items.resilient.false", new Object[0])})).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.main.items.resilient.change", new Object[0]))).build();
        return Button.clickable((ItemStack)i, (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
            Player p = (Player)event.getWhoClicked();
            p.playSound(p.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            event.setCancelled(true);
            if (npc.getSettings().isResilient()) {
                p.sendMessage(Msg.translate(p.locale(), "customnpcs.menus.main.resilient.message.now_false", new Object[0]));
            } else {
                p.sendMessage(Msg.translate(p.locale(), "customnpcs.menus.main.resilient.message.now_true", new Object[0]));
            }
            npc.getSettings().setResilient(!npc.getSettings().isResilient());
            menuView.replaceButton(22, MenuItems.resilient(npc, p));
        }));
    }

    public static ItemStack skinSelection(InternalNpc npc, Player player) {
        return ((ComponentItemBuilder)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.PLAYER_HEAD).modifyMeta(SkullMeta.class, skullMeta -> {
            PlayerProfile profile = Bukkit.createProfile((UUID)UUID.randomUUID());
            String texture = "ewogICJ0aW1lc3RhbXAiIDogMTY2OTY0NjQwMTY2MywKICAicHJvZmlsZUlkIiA6ICJmZTE0M2FhZTVmNGE0YTdiYjM4MzcxM2U1Mjg0YmIxYiIsCiAgInByb2ZpbGVOYW1lIiA6ICJKZWZveHk0IiwKICAic2lnbmF0dXJlUmVxdWlyZWQiIDogdHJ1ZSwKICAidGV4dHVyZXMiIDogewogICAgIlNLSU4iIDogewogICAgICAidXJsIiA6ICJodHRwOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlL2RhZTI5MDRhMjg2Yjk1M2ZhYjhlY2U1MWQ2MmJmY2NiMzJjYjAyNzQ4ZjQ2N2MwMGJjMzE4ODU1OTgwNTA1OGIiCiAgICB9CiAgfQp9";
            profile.setProperty(new ProfileProperty("textures", texture));
            skullMeta.setPlayerProfile(profile);
        })).setLore((Object[])Msg.lore(player.locale(), "customnpcs.menus.main.items.skin.lore", Component.text((String)npc.getSettings().getSkinName())))).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.main.items.skin.name", new Object[0]))).build();
    }

    public static ItemStack extraSettings(Player player) {
        return ((ComponentItemBuilder)ItemBuilder.modern((Material)Material.COMPARATOR).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.main.settings.name", new Object[0]))).build();
    }

    public static ItemStack deleteNpc(Player player) {
        return ((ComponentItemBuilder)ItemBuilder.modern((Material)Material.LAVA_BUCKET).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.main.delete.name", new Object[0]))).build();
    }

    public static ItemStack looking(Player player) {
        return ((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.ENDER_EYE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.main.facing.name", new Object[0]))).setLore((Object[])Msg.lore(player.locale(), "customnpcs.menus.main.facing.description", new Object[0]))).build();
    }

    public static Button interactable(InternalNpc npc, Player player) {
        boolean interactable = npc.getSettings().isInteractable();
        return Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)(interactable ? Material.OAK_SAPLING : Material.DEAD_BUSH)).setLore((Object[])new Component[]{interactable ? Msg.translate(player.locale(), "customnpcs.menus.main.interactable.true", new Object[0]) : Msg.translate(player.locale(), "customnpcs.menus.main.interactable.false", new Object[0])})).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.main.interactable.name.toggle", new Object[0]))).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
            event.setCancelled(true);
            Player p = (Player)event.getWhoClicked();
            p.playSound((Entity)p, Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            if (npc.getSettings().isInteractable()) {
                p.sendMessage(Msg.translate(player.locale(), "customnpcs.menus.main.interactable.message.now_false", new Object[0]));
            } else {
                p.sendMessage(Msg.translate(player.locale(), "customnpcs.menus.main.interactable.message.now_true", new Object[0]));
            }
            npc.getSettings().setInteractable(!npc.getSettings().isInteractable());
            menuView.replaceButton(25, MenuItems.interactable(npc, p));
            menuView.replaceButton(34, MenuItems.showActions(npc, p));
        }));
    }

    public static Button showActions(InternalNpc npc, Player player) {
        if (!npc.getSettings().isInteractable()) {
            return MENU_GLASS;
        }
        return Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.RECOVERY_COMPASS).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.main.interactable.name", new Object[0]))).setLore((Object[])Msg.lore(player.locale(), "customnpcs.menus.main.interactable.description", new Object[0]))).build(), (ButtonClickAction)new OpenButtonAction("npc_actions"));
    }

    public static ItemStack editEquipment(InternalNpc npc, Player player) {
        Equipment equip = npc.getEquipment();
        return ((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.ARMOR_STAND).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.main.items.equipment.name", new Object[0]))).setLore((Object[])new Component[]{Msg.translate(player.locale(), "customnpcs.menus.main.items.equipment.main_hand", equip.getHand().getType().name().toLowerCase()), Msg.translate(player.locale(), "customnpcs.menus.main.items.equipment.off_hand", equip.getOffhand().getType().name().toLowerCase()), Msg.translate(player.locale(), "customnpcs.menus.main.items.equipment.helmet", equip.getHead().getType().name().toLowerCase()), Msg.translate(player.locale(), "customnpcs.menus.main.items.equipment.chestplate", equip.getChest().getType().name().toLowerCase()), Msg.translate(player.locale(), "customnpcs.menus.main.items.equipment.leggings", equip.getLegs().getType().name().toLowerCase()), Msg.translate(player.locale(), "customnpcs.menus.main.items.equipment.boots", equip.getBoots().getType().name().toLowerCase())})).build();
    }

    public static Button tunnelVision(InternalNpc npc, Player player) {
        return Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.SPYGLASS).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.main.vision.name", new Object[0]))).setLore((Object[])new Component[]{npc.getSettings().isTunnelvision() ? Msg.translate(player.locale(), "customnpcs.menus.main.vision.tunnel", new Object[0]) : Msg.translate(player.locale(), "customnpcs.menus.main.vision.normal", new Object[0])})).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
            Player p = (Player)event.getWhoClicked();
            p.playSound((Entity)p, Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            event.setCancelled(true);
            npc.getSettings().setTunnelvision(!npc.getSettings().isTunnelvision());
            menuView.replaceButton(28, MenuItems.tunnelVision(npc, p));
        }));
    }

    public static ItemStack confirmCreation(Player player) {
        return ((ComponentItemBuilder)ItemBuilder.modern((Material)Material.LIME_DYE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.main.create.name", new Object[0]))).build();
    }

    public static ItemStack cancelCreation(Player player) {
        return ((ComponentItemBuilder)ItemBuilder.modern((Material)Material.BARRIER).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.main.cancel.name", new Object[0]))).build();
    }

    public static ItemStack importArmor(Player player) {
        return ((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.ARMOR_STAND).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.equipment.import", new Object[0]))).setLore((Object[])new Component[]{Msg.translate(player.locale(), "customnpcs.menus.equipment.import.description", new Object[0])})).build();
    }

    public static Button helmetSlot(InternalNpc npc, Player player) {
        ItemStack helm = npc.getEquipment().getHead();
        if (helm == null || helm.getType().isAir()) {
            return Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.LIME_STAINED_GLASS_PANE).addFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_DYE})).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.equipment.helmet.empty", new Object[0]))).setLore((Object[])Msg.lore(player.locale(), "customnpcs.menus.equipment.helmet.change", new Object[0]))).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                event.setCancelled(true);
                Player p = (Player)event.getWhoClicked();
                if (event.getCursor().getType() == Material.AIR || event.isRightClick()) {
                    return;
                }
                p.playSound((Entity)p, Sound.ITEM_ARMOR_EQUIP_LEATHER, 1.0f, 1.0f);
                npc.getEquipment().setHead(event.getCursor().clone());
                event.getCursor().setAmount(0);
                p.sendMessage(Msg.translate(p.locale(), "customnpcs.menus.equipment.helmet.message.success", Component.text((String)npc.getEquipment().getHead().getType().name().toLowerCase())));
                menuView.replaceButton(13, MenuItems.helmetSlot(npc, p));
            }));
        }
        List<Component> lore = Utils.list(Msg.lore(player.locale(), "customnpcs.menus.equipment.helmet.change", new Object[0]));
        lore.add(Msg.translate(player.locale(), "customnpcs.remove.description", new Object[0]));
        return Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((ItemStack)helm).setDisplay((Object)Component.text((String)helm.getType().name().toLowerCase(), (TextColor)NamedTextColor.GREEN))).addFlags(ItemFlag.values())).setLore((Object[])lore.toArray(new Component[0]))).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
            event.setCancelled(true);
            Player p = (Player)event.getWhoClicked();
            if (event.isRightClick()) {
                npc.getEquipment().setHead(new ItemStack(Material.AIR));
                p.playSound(p.getLocation(), Sound.ITEM_TRIDENT_HIT, 1.0f, 1.0f);
                p.sendMessage(Msg.translate(p.locale(), "customnpcs.menus.equipment.helmet.reset", new Object[0]));
                menuView.replaceButton(13, MenuItems.helmetSlot(npc, p));
            } else {
                if (event.getCursor().getType() == Material.AIR) {
                    return;
                }
                npc.getEquipment().setHead(event.getCursor().clone());
                event.getCursor().setAmount(0);
                p.playSound(p.getLocation(), Sound.ITEM_ARMOR_EQUIP_LEATHER, 1.0f, 1.0f);
                p.sendMessage(Msg.translate(p.locale(), "customnpcs.menus.equipment.helmet.message.success", Component.text((String)npc.getEquipment().getHead().getType().name().toLowerCase())));
                menuView.replaceButton(13, MenuItems.helmetSlot(npc, p));
            }
        }));
    }

    public static Button chestplateSlot(InternalNpc npc, Player player) {
        ItemStack cp = npc.getEquipment().getChest();
        if (cp.getType().isAir()) {
            return Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.LIME_STAINED_GLASS_PANE).addFlags(ItemFlag.values())).setLore((Object[])Msg.lore(player.locale(), "customnpcs.menus.equipment.chestplate.change", new Object[0]))).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.equipment.chestplate.empty", new Object[0]))).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                Player p = (Player)event.getWhoClicked();
                event.setCancelled(true);
                if (event.getCursor().getType().name().contains("CHESTPLATE") || event.getCursor().getType() == Material.ELYTRA) {
                    npc.getEquipment().setChest(event.getCursor().clone());
                    event.getCursor().setAmount(0);
                    p.playSound(p.getLocation(), Sound.ITEM_ARMOR_EQUIP_LEATHER, 1.0f, 1.0f);
                    p.sendMessage(Msg.translate(p.locale(), "customnpcs.menus.equipment.chestplate.message.success", npc.getEquipment().getChest().getType().name().toLowerCase()));
                } else {
                    if (event.getCursor().getType() == Material.AIR) {
                        return;
                    }
                    p.sendMessage(Msg.translate(p.locale(), "customnpcs.menus.equipment.chestplate.message.error", new Object[0]));
                }
                menuView.replaceButton(22, MenuItems.chestplateSlot(npc, p));
            }));
        }
        List<Component> lore = Utils.list(Msg.lore(player.locale(), "customnpcs.menus.equipment.chestplate.change", new Object[0]));
        lore.add(Msg.translate(player.locale(), "customnpcs.remove.description", new Object[0]));
        return Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((ItemStack)cp).addFlags(ItemFlag.values())).setLore((Object[])lore.toArray(new Component[0]))).setDisplay((Object)Component.text((String)cp.getType().toString(), (TextColor)NamedTextColor.GREEN))).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
            event.setCancelled(true);
            Player p = (Player)event.getWhoClicked();
            if (event.isRightClick()) {
                npc.getEquipment().setChest(new ItemStack(Material.AIR));
                p.playSound(p.getLocation(), Sound.ITEM_TRIDENT_HIT, 1.0f, 1.0f);
                p.sendMessage(Msg.translate(p.locale(), "customnpcs.menus.equipment.chestplate.reset", new Object[0]));
                menuView.replaceButton(22, MenuItems.chestplateSlot(npc, p));
                return;
            }
            if (event.getCursor().getType().name().contains("CHESTPLATE") || event.getCursor().getType() == Material.ELYTRA) {
                npc.getEquipment().setChest(event.getCursor().clone());
                event.getCursor().setAmount(0);
                p.playSound(p.getLocation(), Sound.ITEM_ARMOR_EQUIP_LEATHER, 1.0f, 1.0f);
                p.sendMessage(Msg.translate(p.locale(), "customnpcs.menus.equipment.chestplate.message.success", npc.getEquipment().getChest().getType().name().toLowerCase()));
                return;
            }
            if (event.getCursor().getType() == Material.AIR) {
                return;
            }
            event.setCancelled(true);
            p.sendMessage(Msg.translate(p.locale(), "customnpcs.menus.equipment.chestplate.message.error", new Object[0]));
            menuView.replaceButton(22, MenuItems.chestplateSlot(npc, p));
        }));
    }

    public static Button leggingsSlot(InternalNpc npc, Player player) {
        ItemStack legs = npc.getEquipment().getLegs();
        if (legs.getType().isAir()) {
            return Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.LIME_STAINED_GLASS_PANE).addFlags(ItemFlag.values())).setLore((Object[])Msg.lore(player.locale(), "customnpcs.menus.equipment.legs.change", new Object[0]))).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.equipment.legs.empty", new Object[0]))).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                event.setCancelled(true);
                Player p = (Player)event.getWhoClicked();
                if (event.getCursor().getType().name().contains("LEGGINGS")) {
                    npc.getEquipment().setLegs(event.getCursor().clone());
                    event.getCursor().setAmount(0);
                    p.playSound(p.getLocation(), Sound.ITEM_ARMOR_EQUIP_LEATHER, 1.0f, 1.0f);
                    p.sendMessage(Msg.translate(p.locale(), "customnpcs.menus.equipment.legs.message.success", npc.getEquipment().getLegs().getType().name().toLowerCase()));
                } else {
                    if (event.getCursor().getType() == Material.AIR) {
                        return;
                    }
                    p.sendMessage(Msg.translate(p.locale(), "customnpcs.menus.equipment.legs.message.error", new Object[0]));
                }
                menuView.replaceButton(31, MenuItems.leggingsSlot(npc, p));
            }));
        }
        List<Component> lore = Utils.list(Msg.lore(player.locale(), "customnpcs.menus.equipment.legs.change", new Object[0]));
        lore.add(Msg.translate(player.locale(), "customnpcs.remove.description", new Object[0]));
        return Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((ItemStack)legs).addFlags(ItemFlag.values())).setDisplay((Object)Component.text((String)legs.getType().toString(), (TextColor)NamedTextColor.GREEN))).setLore((Object[])lore.toArray(new Component[0]))).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
            event.setCancelled(true);
            Player p = (Player)event.getWhoClicked();
            if (event.isRightClick()) {
                npc.getEquipment().setLegs(new ItemStack(Material.AIR));
                p.playSound(p.getLocation(), Sound.ITEM_TRIDENT_HIT, 1.0f, 1.0f);
                p.sendMessage(Msg.translate(p.locale(), "customnpcs.menus.equipment.legs.reset", new Object[0]));
                menuView.replaceButton(31, MenuItems.leggingsSlot(npc, player));
            } else if (event.getCursor().getType().name().contains("LEGGINGS")) {
                npc.getEquipment().setLegs(event.getCursor().clone());
                event.getCursor().setAmount(0);
                p.playSound(p.getLocation(), Sound.ITEM_ARMOR_EQUIP_LEATHER, 1.0f, 1.0f);
                p.sendMessage(Msg.translate(p.locale(), "customnpcs.menus.equipment.legs.message.success", npc.getEquipment().getLegs().getType().name().toLowerCase()));
                menuView.replaceButton(31, MenuItems.leggingsSlot(npc, p));
            } else {
                if (event.getCursor().getType() == Material.AIR) {
                    return;
                }
                p.sendMessage(Msg.translate(p.locale(), "customnpcs.menus.equipment.legs.message.error", new Object[0]));
            }
        }));
    }

    public static Button bootsSlot(InternalNpc npc, Player player) {
        ItemStack boots = npc.getEquipment().getBoots();
        if (boots.getType().isAir()) {
            return Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.LIME_STAINED_GLASS_PANE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.equipment.boots.empty", new Object[0]))).addFlags(ItemFlag.values())).setLore((Object[])Msg.lore(player.locale(), "customnpcs.menus.equipment.boots.change", new Object[0]))).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                event.setCancelled(true);
                Player p = (Player)event.getWhoClicked();
                if (!event.getCursor().getType().name().contains("BOOTS")) {
                    if (event.getCursor().getType() == Material.AIR) {
                        return;
                    }
                    p.sendMessage(Msg.translate(p.locale(), "customnpcs.menus.equipment.boots.message.error", new Object[0]));
                    return;
                }
                npc.getEquipment().setBoots(event.getCursor().clone());
                event.getCursor().setAmount(0);
                p.playSound(p.getLocation(), Sound.ITEM_ARMOR_EQUIP_LEATHER, 1.0f, 1.0f);
                p.sendMessage(Msg.translate(p.locale(), "customnpcs.menus.equipment.boots.message.success", npc.getEquipment().getBoots().getType().name().toLowerCase()));
                menuView.replaceButton(40, MenuItems.bootsSlot(npc, p));
            }));
        }
        List<Component> lore = Utils.list(Msg.lore(player.locale(), "customnpcs.menus.equipment.boots.change", new Object[0]));
        lore.add(Msg.translate(player.locale(), "customnpcs.remove.description", new Object[0]));
        return Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((ItemStack)boots).setLore((Object[])lore.toArray(new Component[0]))).setDisplay((Object)Component.text((String)boots.getType().toString(), (TextColor)NamedTextColor.GREEN))).addFlags(ItemFlag.values())).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
            event.setCancelled(true);
            Player p = (Player)event.getWhoClicked();
            if (event.isRightClick()) {
                npc.getEquipment().setBoots(new ItemStack(Material.AIR));
                p.playSound(p.getLocation(), Sound.ITEM_TRIDENT_HIT, 1.0f, 1.0f);
                p.sendMessage(Msg.translate(p.locale(), "customnpcs.menus.equipment.boots.reset", new Object[0]));
            } else if (event.getCursor().getType().name().contains("LEGGINGS")) {
                npc.getEquipment().setBoots(event.getCursor().clone());
                event.getCursor().setAmount(0);
                p.playSound(p.getLocation(), Sound.ITEM_ARMOR_EQUIP_LEATHER, 1.0f, 1.0f);
                p.sendMessage(Msg.translate(p.locale(), "customnpcs.menus.equipment.boots.message.success", npc.getEquipment().getBoots().getType().name().toLowerCase()));
            } else {
                if (event.getCursor().getType() == Material.AIR) {
                    return;
                }
                p.sendMessage(Msg.translate(p.locale(), "customnpcs.menus.equipment.boots.message.error", new Object[0]));
                return;
            }
            menuView.replaceButton(40, MenuItems.bootsSlot(npc, p));
        }));
    }

    public static Button handSlot(InternalNpc npc, Player player) {
        ItemStack hand = npc.getEquipment().getHand();
        if (hand.getType().isAir()) {
            return Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.YELLOW_STAINED_GLASS_PANE).addFlags(ItemFlag.values())).setLore((Object[])Msg.lore(player.locale(), "customnpcs.menus.equipment.hand.change", new Object[0]))).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.equipment.hand.empty", new Object[0]))).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                event.setCancelled(true);
                Player p = (Player)event.getWhoClicked();
                if (event.getCursor().getType() == Material.AIR) {
                    return;
                }
                npc.getEquipment().setHand(event.getCursor().clone());
                event.getCursor().setAmount(0);
                p.playSound(p.getLocation(), Sound.ITEM_ARMOR_EQUIP_LEATHER, 1.0f, 1.0f);
                p.sendMessage(Msg.translate(p.locale(), "customnpcs.menus.equipment.hand.message.success", npc.getEquipment().getHand().getType().name().toLowerCase()));
                menuView.replaceButton(23, MenuItems.handSlot(npc, p));
            }));
        }
        List<Component> lore = Utils.list(Msg.lore(player.locale(), "customnpcs.menus.equipment.hand.change", new Object[0]));
        lore.add(Msg.translate(player.locale(), "customnpcs.remove.description", new Object[0]));
        return Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((ItemStack)hand).setLore((Object[])lore.toArray(new Component[0]))).setDisplay((Object)Component.text((String)hand.getType().toString(), (TextColor)NamedTextColor.GREEN))).addFlags(ItemFlag.values())).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
            event.setCancelled(true);
            Player p = (Player)event.getWhoClicked();
            if (event.isRightClick()) {
                npc.getEquipment().setHand(new ItemStack(Material.AIR));
                p.playSound(p.getLocation(), Sound.ITEM_TRIDENT_HIT, 1.0f, 1.0f);
                p.sendMessage(Msg.translate(p.locale(), "customnpcs.menus.equipment.hand.reset", new Object[0]));
                menuView.replaceButton(23, MenuItems.handSlot(npc, p));
            } else {
                if (event.getCursor().getType() == Material.AIR) {
                    return;
                }
                npc.getEquipment().setHand(event.getCursor().clone());
                event.getCursor().setAmount(0);
                p.playSound(p.getLocation(), Sound.ITEM_ARMOR_EQUIP_LEATHER, 1.0f, 1.0f);
                p.sendMessage(Msg.translate(p.locale(), "customnpcs.menus.equipment.hand.message.success", npc.getEquipment().getHand().getType().name().toLowerCase()));
                menuView.replaceButton(23, MenuItems.handSlot(npc, p));
            }
        }));
    }

    public static Button offhandSlot(InternalNpc npc, Player player) {
        ItemStack offhand = npc.getEquipment().getOffhand();
        if (offhand.getType().isAir()) {
            return Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.YELLOW_STAINED_GLASS_PANE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.equipment.offhand.empty", new Object[0]))).setLore((Object[])Msg.lore(player.locale(), "customnpcs.menus.equipment.offhand.change", new Object[0]))).addFlags(ItemFlag.values())).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                event.setCancelled(true);
                Player p = (Player)event.getWhoClicked();
                if (event.getCursor().getType() == Material.AIR) {
                    return;
                }
                npc.getEquipment().setOffhand(event.getCursor().clone());
                event.getCursor().setAmount(0);
                p.playSound(p.getLocation(), Sound.ITEM_ARMOR_EQUIP_LEATHER, 1.0f, 1.0f);
                p.sendMessage(Msg.translate(p.locale(), "customnpcs.menus.equipment.offhand.message.success", npc.getEquipment().getOffhand().getType().name().toLowerCase()));
                menuView.replaceButton(21, MenuItems.offhandSlot(npc, p));
            }));
        }
        List<Component> lore = Utils.list(Msg.lore(player.locale(), "customnpcs.menus.equipment.hand.change", new Object[0]));
        lore.add(Msg.translate(player.locale(), "customnpcs.remove.description", new Object[0]));
        return Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((ItemStack)offhand).setLore((Object[])lore.toArray(new Component[0]))).setDisplay((Object)Component.text((String)offhand.getType().toString(), (TextColor)NamedTextColor.GREEN))).addFlags(ItemFlag.values())).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
            event.setCancelled(true);
            Player p = (Player)event.getWhoClicked();
            if (event.isRightClick()) {
                npc.getEquipment().setOffhand(new ItemStack(Material.AIR));
                p.playSound(p.getLocation(), Sound.ITEM_TRIDENT_HIT, 1.0f, 1.0f);
                p.sendMessage(Msg.translate(p.locale(), "customnpcs.menus.equipment.offhand.reset", new Object[0]));
            } else {
                if (event.getCursor().getType() == Material.AIR) {
                    return;
                }
                npc.getEquipment().setOffhand(event.getCursor().clone());
                event.getCursor().setAmount(0);
                p.playSound(p.getLocation(), Sound.ITEM_ARMOR_EQUIP_LEATHER, 1.0f, 1.0f);
                p.sendMessage(Msg.translate(p.locale(), "customnpcs.menus.equipment.offhand.message.success", npc.getEquipment().getOffhand().getType().name().toLowerCase()));
            }
            menuView.replaceButton(21, MenuItems.offhandSlot(npc, p));
        }));
    }

    public static Button toMain(Player player) {
        return Button.clickable((ItemStack)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.BARRIER).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.items.go_back", new Object[0]))).build(), (ButtonClickAction)new OpenButtonAction("npc_main"));
    }

    public static Button toPose(Player player) {
        return Button.clickable((ItemStack)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.SNIFFER_EGG).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.pose.pose_editor", new Object[0]))).build(), (ButtonClickAction)new OpenButtonAction("npc_pose"));
    }

    public static Button toAction(Player player) {
        return Button.clickable((ItemStack)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.ARROW).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.items.go_back", new Object[0]))).build(), (ButtonClickAction)new OpenButtonAction("npc_actions"));
    }

    public static Button toActionSaveConditions(Player player) {
        return Button.clickable((ItemStack)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.ARROW).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.items.go_back", new Object[0]))).build(), (ButtonClickAction)ButtonClickAction.plain((menu, event) -> {
            event.setCancelled(true);
            Player p = (Player)event.getWhoClicked();
            p.playSound(p.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            plugin.getLotus().openMenu(p, "npc_action_customizer");
        }));
    }

    public static Button toNewCondition(Player player) {
        return Button.clickable((ItemStack)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.ARROW).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.items.go_back", new Object[0]))).build(), (ButtonClickAction)new OpenButtonAction("npc_new_condition"));
    }

    public static Button toConditionCustomizer(Player player) {
        return Button.clickable((ItemStack)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.COMPARATOR).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.action_customizer.conditions", new Object[0]))).build(), (ButtonClickAction)new OpenButtonAction("npc_condition_customizer"));
    }

    public static List<Button> currentActions(InternalNpc npc, Player player) {
        ArrayList<Button> buttons = new ArrayList<Button>();
        for (Action action : npc.getActions()) {
            buttons.add(Button.clickable((ItemStack)action.getFavicon(player), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                event.setCancelled(true);
                Player p = (Player)event.getWhoClicked();
                if (event.isRightClick()) {
                    p.playSound(p.getLocation(), Sound.ITEM_TRIDENT_HIT, 1.0f, 1.0f);
                    npc.removeAction(action);
                    menuView.getAPI().openMenu(p, "npc_actions");
                } else if (event.isLeftClick()) {
                    if (CustomNPCs.ACTION_REGISTRY.canEdit(action.getClass())) {
                        p.playSound(p.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                        MenuItems.plugin.editingActions.put(p.getUniqueId(), action.clone());
                        MenuItems.plugin.originalEditingActions.put(p.getUniqueId(), action);
                        plugin.getLotus().openMenu(p, "npc_action_customizer");
                    } else {
                        p.playSound(p.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                        p.sendMessage(Msg.translate(p.locale(), "customnpcs.edit.fail", new Object[0]));
                    }
                }
            })));
        }
        buttons.add(Button.clickable((ItemStack)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.LILY_PAD).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.actions.new", new Object[0]))).build(), (ButtonClickAction)new OpenButtonAction("npc_new_action")));
        return buttons;
    }

    public static List<Button> currentLines(InternalNpc npc, Player player) {
        ArrayList<Button> buttons = new ArrayList<Button>();
        String[] raw = npc.getSettings().getRawHolograms();
        List<String> mutable = Utils.list(raw);
        for (int i = 0; i < raw.length; ++i) {
            boolean canMoveUp;
            String line = raw[i];
            List<Component> lore = Utils.list(Msg.format(line), Component.empty(), Msg.translate(player.locale(), "customnpcs.menus.holograms.edit", new Object[0]), Msg.translate(player.locale(), "customnpcs.menus.holograms.delete", new Object[0]));
            boolean canMoveDown = i < raw.length - 1;
            boolean bl = canMoveUp = i > 0;
            if (canMoveDown) {
                lore.add(Msg.translate(player.locale(), "customnpcs.menus.holograms.move_down", new Object[0]));
            }
            if (canMoveUp) {
                lore.add(Msg.translate(player.locale(), "customnpcs.menus.holograms.move_up", new Object[0]));
            }
            int finalI = i;
            buttons.add(Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.PAPER).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.holograms.line", i + 1))).setLore(lore)).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                event.setCancelled(true);
                Player p = (Player)event.getWhoClicked();
                if (event.getClick() == ClickType.DROP) {
                    HologramMenu.editingIndicies.put(p.getUniqueId(), finalI);
                    plugin.getLotus().openMenu(p, "npc_delete_line");
                    return;
                }
                if (event.getClick() == ClickType.CONTROL_DROP) {
                    mutable.remove(finalI);
                    player.playSound(p.getLocation(), Sound.ITEM_TRIDENT_HIT, 1.0f, 1.0f);
                    npc.getSettings().setRawHolograms(mutable.toArray(new String[0]));
                    plugin.getLotus().openMenu(p, "npc_holograms");
                    return;
                }
                if (event.getClick() == ClickType.SWAP_OFFHAND) {
                    p.sendMessage(Msg.translate(p.locale(), "customnpcs.data.name.title", new Object[0]));
                    plugin.wait(p, WaitingType.NAME);
                    p.playSound((Entity)p, Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                    HologramMenu.editingIndicies.put(p.getUniqueId(), finalI);
                    new NameRunnable(p, plugin).runTaskTimer((Plugin)plugin, 1L, 15L);
                    p.closeInventory();
                    if (plugin.getConfig().getBoolean("NameReferenceMessages")) {
                        p.sendMessage(Msg.translate(p.locale(), "customnpcs.name.reference", new Object[0]));
                        p.sendMessage(line);
                        p.sendMessage(Msg.translate(p.locale(), "customnpcs.name.toggle_reference_message", new Object[0]));
                    }
                    return;
                }
                if (event.isLeftClick()) {
                    if (!canMoveUp) {
                        p.sendMessage(Msg.translate(p.locale(), "customnpcs.menus.holograms.move_up_fail", new Object[0]));
                        p.playSound(p.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                        return;
                    }
                    Collections.swap(mutable, finalI, finalI - 1);
                    npc.getSettings().setRawHolograms(mutable.toArray(new String[0]));
                    plugin.getLotus().openMenu(p, "npc_holograms");
                    p.playSound(p.getLocation(), Sound.BLOCK_PISTON_EXTEND, 0.7f, 0.9f);
                    return;
                }
                if (!canMoveDown) {
                    p.sendMessage(Msg.translate(p.locale(), "customnpcs.menus.holograms.move_down_fail", new Object[0]));
                    p.playSound(p.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                    return;
                }
                Collections.swap(mutable, finalI, finalI + 1);
                npc.getSettings().setRawHolograms(mutable.toArray(new String[0]));
                plugin.getLotus().openMenu(p, "npc_holograms");
                p.playSound(p.getLocation(), Sound.BLOCK_PISTON_CONTRACT, 0.7f, 0.9f);
            })));
        }
        buttons.add(Button.clickable((ItemStack)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.LILY_PAD).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.holograms.new_line", new Object[0]))).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
            event.setCancelled(true);
            Player p = (Player)event.getWhoClicked();
            plugin.wait(p, WaitingType.NAME);
            p.playSound((Entity)p, Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            HologramMenu.editingIndicies.put(p.getUniqueId(), raw.length);
            new NameRunnable(p, plugin).runTaskTimer((Plugin)plugin, 1L, 15L);
            p.closeInventory();
        })));
        return buttons;
    }

    public static Button delayDisplay(Action action, Player player) {
        return Button.clickable((ItemStack)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.CLOCK).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.action_customizer.delay.name", action.getDelay()))).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> event.setCancelled(true)));
    }

    public static Button decrementDelay(Action action, Player player) {
        return Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.RED_DYE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.action_customizer.delay.decrement", new Object[0]))).setLore((Object[])Msg.lore(player.locale(), "customnpcs.menus.action_customizer.delay.decrement.description", new Object[0]))).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
            event.setCancelled(true);
            Player p = (Player)event.getWhoClicked();
            p.playSound(p.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            if (action.getDelay() == 0) {
                p.sendMessage(Msg.translate(p.locale(), "customnpcs.menus.action_customizer.delay.error", new Object[0]));
                return;
            }
            if (event.isShiftClick()) {
                action.setDelay(Math.max(0, action.getDelay() - 20));
            } else if (event.isLeftClick()) {
                action.setDelay(Math.max(0, action.getDelay() - 1));
            } else if (event.isRightClick()) {
                action.setDelay(Math.max(0, action.getDelay() - 5));
            }
            menuView.updateButton(1, button -> button.setItem(MenuItems.delayDisplay(action, p).getItem()));
        }));
    }

    public static Button incrementDelay(Action action, Player player) {
        return Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.LIME_DYE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.action_customizer.delay.increment", new Object[0]))).setLore((Object[])Msg.lore(player.locale(), "customnpcs.menus.action_customizer.delay.increment.description", new Object[0]))).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
            event.setCancelled(true);
            if (event.isShiftClick()) {
                action.setDelay(action.getDelay() + 20);
            } else if (event.isLeftClick()) {
                action.setDelay(action.getDelay() + 1);
            } else if (event.isRightClick()) {
                action.setDelay(action.getDelay() + 5);
            }
            Player p = (Player)event.getWhoClicked();
            p.playSound((Entity)p, Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            menuView.updateButton(1, button -> button.setItem(MenuItems.delayDisplay(action, p).getItem()));
        }));
    }

    public static Button cooldownDisplay(Action action, Player player) {
        return Button.clickable((ItemStack)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.CLOCK).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.action_customizer.cooldown.name", action.getCooldown()))).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> event.setCancelled(true)));
    }

    public static Button decrementCooldown(Action action, Player player) {
        return Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.RED_DYE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.action_customizer.cooldown.decrement", new Object[0]))).setLore((Object[])Msg.lore(player.locale(), "customnpcs.menus.action_customizer.cooldown.decrement.description", new Object[0]))).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
            event.setCancelled(true);
            Player p = (Player)event.getWhoClicked();
            p.playSound(p.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            if (action.getCooldown() == 0) {
                p.sendMessage(Msg.translate(p.locale(), "customnpcs.menus.action_customizer.cooldown.error", new Object[0]));
                return;
            }
            if (event.isShiftClick()) {
                action.setCooldown(Math.max(0, action.getCooldown() - 20));
            } else if (event.isLeftClick()) {
                action.setCooldown(Math.max(0, action.getCooldown() - 1));
            } else if (event.isRightClick()) {
                action.setCooldown(Math.max(0, action.getCooldown() - 5));
            }
            menuView.updateButton(7, button -> button.setItem(MenuItems.cooldownDisplay(action, p).getItem()));
        }));
    }

    public static Button incrementCooldown(Action action, Player player) {
        return Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.LIME_DYE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.action_customizer.cooldown.increment", new Object[0]))).setLore((Object[])Msg.lore(player.locale(), "customnpcs.menus.action_customizer.cooldown.increment.description", new Object[0]))).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
            event.setCancelled(true);
            if (event.isShiftClick()) {
                action.setCooldown(action.getCooldown() + 20);
            } else if (event.isLeftClick()) {
                action.setCooldown(action.getCooldown() + 1);
            } else if (event.isRightClick()) {
                action.setCooldown(action.getCooldown() + 5);
            }
            Player p = (Player)event.getWhoClicked();
            p.playSound((Entity)p, Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            menuView.updateButton(7, button -> button.setItem(MenuItems.cooldownDisplay(action, p).getItem()));
        }));
    }

    public static Button saveAction(Action action, Player player) {
        return Button.clickable((ItemStack)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.LILY_PAD).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.action_customizer.confirm", new Object[0]))).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
            event.setCancelled(true);
            Player p = (Player)event.getWhoClicked();
            p.playSound(p.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            InternalNpc npc = (InternalNpc)plugin.getEditingNPCs().getIfPresent((Object)p.getUniqueId());
            if (npc == null) {
                p.sendMessage(Msg.translate(p.locale(), "customnpcs.menus.main.error.no_npc.lore", new Object[0]));
                return;
            }
            if (CustomNPCs.getInstance().originalEditingActions.get(p.getUniqueId()) != null) {
                npc.removeAction(CustomNPCs.getInstance().originalEditingActions.remove(p.getUniqueId()));
            }
            npc.addAction(action);
            menuView.getAPI().openMenu(p, "npc_actions");
        }));
    }

    public static ItemStack genericDisplay(Component text, Component ... lore) {
        return ((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.CLOCK).setDisplay((Object)text)).setLore((Object[])lore)).build();
    }

    public static Button saveCondition(Player player) {
        return Button.clickable((ItemStack)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.LILY_PAD).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.main.create.name", new Object[0]))).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
            event.setCancelled(true);
            Player p = (Player)event.getWhoClicked();
            p.playSound(p.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            Action actionImpl = MenuItems.plugin.editingActions.get(p.getUniqueId());
            Condition original = MenuItems.plugin.originalEditingConditionals.get(p.getUniqueId());
            if (original != null) {
                actionImpl.removeCondition(original);
            }
            Condition edited = MenuItems.plugin.editingConditionals.get(p.getUniqueId());
            actionImpl.addCondition(edited);
            menuView.getAPI().openMenu(p, "npc_conditions");
        }));
    }

    public static Button comparatorSwitcher(Condition condition, Player player) {
        ArrayList<Component> lore = new ArrayList<Component>();
        for (Condition.Comparator c : Condition.Comparator.values()) {
            if (condition.getType() != Condition.Type.NUMERIC && (condition.getType() != Condition.Type.LOGICAL || !c.isStrictlyLogical())) continue;
            if (condition.getComparator() != c) {
                lore.add(Msg.translate(player.locale(), c.getKey(), new Object[0]).color((TextColor)NamedTextColor.GREEN));
                continue;
            }
            lore.add(Component.text((String)"\u25b8 ", (TextColor)NamedTextColor.DARK_AQUA).append(Msg.translate(player.locale(), c.getKey(), new Object[0])));
        }
        lore.add(Msg.translate(player.locale(), "customnpcs.items.click_to_change", new Object[0]));
        ItemStack i = ((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.COMPARATOR).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.comparator", new Object[0]))).setLore((Object[])lore.toArray(new Component[0]))).build();
        return Button.clickable((ItemStack)i, (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
            event.setCancelled(true);
            ArrayList<Condition.Comparator> comparators = new ArrayList<Condition.Comparator>();
            for (Condition.Comparator value : Condition.Comparator.values()) {
                if (condition.getType() == Condition.Type.LOGICAL && !value.isStrictlyLogical()) continue;
                comparators.add(value);
            }
            int index = comparators.indexOf((Object)condition.getComparator());
            if (event.isLeftClick()) {
                if (comparators.size() > index + 1) {
                    condition.setComparator((Condition.Comparator)((Object)((Object)comparators.get(index + 1))));
                } else {
                    condition.setComparator((Condition.Comparator)((Object)((Object)comparators.get(0))));
                }
            } else if (event.isRightClick()) {
                if (index == 0) {
                    condition.setComparator((Condition.Comparator)((Object)((Object)comparators.get(comparators.size() - 1))));
                } else {
                    condition.setComparator((Condition.Comparator)((Object)((Object)comparators.get(index - 1))));
                }
            }
            Player p = (Player)event.getWhoClicked();
            p.playSound((Entity)p, Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            menuView.replaceButton(11, MenuItems.comparatorSwitcher(condition, p));
        }));
    }

    public static Button targetValueSelector(Condition condition, Player player) {
        ItemStack i = ((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.OAK_HANGING_SIGN).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.value.select", new Object[0]))).setLore((Object[])new Component[]{Msg.translate(player.locale(), "customnpcs.value.current", condition.getTarget()), Msg.translate(player.locale(), "customnpcs.items.click_to_change", new Object[0])})).build();
        return Button.clickable((ItemStack)i, (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
            event.setCancelled(true);
            Player p = (Player)event.getWhoClicked();
            p.playSound(p.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            p.closeInventory();
            plugin.wait(p, WaitingType.TARGET);
            new TargetInputRunnable(p, plugin).runTaskTimer((Plugin)plugin, 0L, 10L);
        }));
    }

    public static Button valueSwitcher(Condition condition, Player player) {
        ArrayList<Component> lore = new ArrayList<Component>();
        for (Condition.Value v : Condition.Value.values()) {
            if (v.isLogical() && condition.getType() != Condition.Type.LOGICAL || !v.isLogical() && condition.getType() != Condition.Type.NUMERIC) continue;
            if (condition.getValue() != v) {
                lore.add(Msg.translate(player.locale(), v.getTranslationKey(), new Object[0]).color((TextColor)NamedTextColor.GREEN));
                continue;
            }
            lore.add(Component.text((String)"\u25b8 ", (TextColor)NamedTextColor.DARK_AQUA).append(Msg.translate(player.locale(), v.getTranslationKey(), new Object[0])));
        }
        lore.add(Msg.translate(player.locale(), "customnpcs.items.click_to_change", new Object[0]));
        ItemStack i = ((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.COMPARATOR).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.statistic", new Object[0]))).setLore((Object[])lore.toArray(new Component[0]))).build();
        return Button.clickable((ItemStack)i, (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
            event.setCancelled(true);
            ArrayList<Condition.Value> statistics = new ArrayList<Condition.Value>();
            for (Condition.Value value : Condition.Value.values()) {
                if (condition.getType() == Condition.Type.LOGICAL) {
                    if (!value.isLogical()) continue;
                    statistics.add(value);
                    continue;
                }
                if (value.isLogical()) continue;
                statistics.add(value);
            }
            int index = statistics.indexOf((Object)condition.getValue());
            if (event.isLeftClick()) {
                if (statistics.size() > index + 1) {
                    condition.setValue((Condition.Value)((Object)((Object)statistics.get(index + 1))));
                } else {
                    condition.setValue((Condition.Value)((Object)((Object)statistics.get(0))));
                }
            } else if (event.isRightClick()) {
                if (index == 0) {
                    condition.setValue((Condition.Value)((Object)((Object)statistics.get(statistics.size() - 1))));
                } else {
                    condition.setValue((Condition.Value)((Object)((Object)statistics.get(index - 1))));
                }
            }
            Player p = (Player)event.getWhoClicked();
            p.playSound((Entity)p, Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            menuView.updateButton(15, button -> button.setItem(MenuItems.valueSwitcher(condition, player).getItem()));
        }));
    }

    public static Button interactableHologram(InternalNpc npc, Player player) {
        boolean hideClickableTag = npc.getSettings().isHideClickableHologram();
        ItemStack i = ((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)(hideClickableTag ? Material.RED_CANDLE : Material.GREEN_CANDLE)).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.extra.hologram_visibility", new Object[0]))).setLore((Object[])new Component[]{Component.empty(), Msg.translate(player.locale(), "customnpcs.menus.extra.hologram_visibility.description", new Object[0]), hideClickableTag ? Msg.translate(player.locale(), "customnpcs.menus.extra.hologram_visibility.description.hidden", new Object[0]) : Msg.translate(player.locale(), "customnpcs.menus.extra.hologram_visibility.description.shown", new Object[0])})).build();
        return Button.clickable((ItemStack)i, (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
            Player p = (Player)event.getWhoClicked();
            p.playSound((Entity)p, Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            event.setCancelled(true);
            npc.getSettings().setHideClickableHologram(!hideClickableTag);
            menuView.replaceButton(11, MenuItems.interactableHologram(npc, p));
        }));
    }

    public static Button interactableText(Player player) {
        ItemStack i = ((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.NAME_TAG).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.extra.hologram_text", new Object[0]))).setLore((Object[])Msg.lore(player.locale(), "customnpcs.menus.extra.hologram_text.description", new Object[0]))).build();
        return Button.clickable((ItemStack)i, (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
            event.setCancelled(true);
            Player p = (Player)event.getWhoClicked();
            p.playSound(p.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            plugin.wait(p, WaitingType.HOLOGRAM);
            p.closeInventory();
            p.sendMessage(Msg.translate(p.locale(), "customnpcs.menus.extra.hologram_text.type", new Object[0]));
            new InteractableHologramRunnable(p, plugin).runTaskTimer((Plugin)plugin, 0L, 10L);
        }));
    }

    public static Button upsideDown(InternalNpc npc, Player player) {
        List<Component> lore = Utils.list(Component.empty(), Msg.translate(player.locale(), "customnpcs.menus.extra.upside_down.description", new Object[0]));
        boolean upsideDown = npc.getSettings().isUpsideDown();
        lore.addAll(List.of(upsideDown ? Msg.lore(player.locale(), "customnpcs.menus.extra.upside_down.description.true", new Object[0]) : Msg.lore(player.locale(), "customnpcs.menus.extra.upside_down.description.false", new Object[0])));
        ItemStack i = ((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)(upsideDown ? Material.GREEN_CANDLE : Material.RED_CANDLE)).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.extra.upside_down", new Object[0]))).setLore(lore)).build();
        return Button.clickable((ItemStack)i, (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
            Player p = (Player)event.getWhoClicked();
            p.playSound((Entity)p, Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            event.setCancelled(true);
            npc.getSettings().setUpsideDown(!upsideDown);
            menuView.replaceButton(15, MenuItems.upsideDown(npc, p));
        }));
    }

    public static Button importPlayer(Player player) {
        ItemStack i = ((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.ANVIL).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.skins.player", new Object[0]))).setLore((Object[])Msg.lore(player.locale(), "customnpcs.menus.skins.player.description", new Object[0]))).build();
        return Button.clickable((ItemStack)i, (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
            Player p = (Player)event.getWhoClicked();
            p.playSound(p.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            p.closeInventory();
            plugin.wait(p, WaitingType.PLAYER);
            new PlayerNameRunnable(p, plugin).runTaskTimer((Plugin)plugin, 0L, 10L);
            event.setCancelled(true);
        }));
    }

    public static Button useCatalog(Player player) {
        ItemStack i = ((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.ARMOR_STAND).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.skins.catalog", new Object[0]))).setLore((Object[])Msg.lore(player.locale(), "customnpcs.menus.skins.catalog.description", new Object[0]))).build();
        return Button.clickable((ItemStack)i, (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
            event.setCancelled(true);
            Player p = (Player)event.getWhoClicked();
            p.playSound(p.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            try {
                CustomNPCs.getInstance().getSkinCatalog(p).open(p);
            }
            catch (InvalidPageException e) {
                p.sendMessage(Msg.translate(p.locale(), "customnpcs.error.cant_open_skin_catalog", new Object[0]));
                CustomNPCs.getInstance().getLogger().log(Level.SEVERE, "An error occurred whilst opening the Skin Catalog!", e);
            }
        }));
    }

    public static Button importUrl(Player player) {
        ItemStack i = ((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.WRITABLE_BOOK).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.skins.url", new Object[0]))).setLore((Object[])Msg.lore(player.locale(), "customnpcs.menus.skins.url.description", new Object[0]))).build();
        return Button.clickable((ItemStack)i, (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
            Player p = (Player)event.getWhoClicked();
            p.playSound(p.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            p.closeInventory();
            plugin.wait(p, WaitingType.URL);
            new UrlRunnable(p, plugin).runTaskTimer((Plugin)plugin, 0L, 10L);
            event.setCancelled(true);
        }));
    }

    public static List<Button> conditions(Action action, Player player) {
        ArrayList<Button> buttons = new ArrayList<Button>();
        if (action.getConditions() == null) {
            return Utils.list(MenuItems.newCondition(action, player));
        }
        for (Condition condition : action.getConditions()) {
            boolean logical = condition.getType() == Condition.Type.LOGICAL;
            ItemStack i = ((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)(logical ? Material.COMPARATOR : Material.POPPED_CHORUS_FRUIT)).setDisplay((Object)(logical ? Msg.translate(player.locale(), "customnpcs.menus.conditions.logical", new Object[0]) : Msg.translate(player.locale(), "customnpcs.menus.conditions.numeric", new Object[0])))).setLore((Object[])new Component[]{Component.empty(), Msg.translate(player.locale(), "customnpcs.menus.conditions.comparator", Msg.translate(player.locale(), condition.getComparator().getKey(), new Object[0])), Msg.translate(player.locale(), "customnpcs.menus.conditions.value", Msg.translate(player.locale(), condition.getValue().getTranslationKey(), new Object[0])), Msg.translate(player.locale(), "customnpcs.menus.conditions.target", condition.getTarget()), Component.empty(), Msg.translate(player.locale(), "customnpcs.favicons.remove", new Object[0]), Msg.translate(player.locale(), "customnpcs.favicons.edit", new Object[0])})).build();
            buttons.add(Button.clickable((ItemStack)i, (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                event.setCancelled(true);
                Player p = (Player)event.getWhoClicked();
                if (event.isRightClick()) {
                    p.playSound(p.getLocation(), Sound.ITEM_TRIDENT_HIT, 1.0f, 1.0f);
                    action.removeCondition(condition);
                    menuView.getAPI().openMenu(p, "npc_conditions");
                } else {
                    p.playSound(p.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                    MenuItems.plugin.editingConditionals.put(p.getUniqueId(), condition.clone());
                    MenuItems.plugin.originalEditingConditionals.put(p.getUniqueId(), condition);
                    menuView.getAPI().openMenu(p, "npc_condition_customizer");
                }
            })));
        }
        buttons.add(MenuItems.newCondition(action, player));
        return buttons;
    }

    public static Button newCondition(Action action, Player player) {
        ItemStack i = ((ComponentItemBuilder)ItemBuilder.modern((Material)Material.LILY_PAD).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.conditions.new_condition", new Object[0]))).build();
        return Button.clickable((ItemStack)i, (ButtonClickAction)new OpenButtonAction("npc_new_condition"));
    }

    public static Button toggleConditionMode(Action action, Player player) {
        boolean isAll = action.getMode() == Condition.SelectionMode.ALL;
        ItemStack i = ((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)(isAll ? Material.GREEN_CANDLE : Material.RED_CANDLE)).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.conditions.mode.toggle", new Object[0]))).setLore((Object[])new Component[]{isAll ? Msg.translate(player.locale(), "customnpcs.menus.conditions.mode.all", new Object[0]) : Msg.translate(player.locale(), "customnpcs.menus.conditions.mode.one", new Object[0])})).build();
        return Button.clickable((ItemStack)i, (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
            Player p = (Player)event.getWhoClicked();
            p.playSound((Entity)p, Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            event.setCancelled(true);
            action.setMode(isAll ? Condition.SelectionMode.ONE : Condition.SelectionMode.ALL);
            menuView.replaceButton(35, MenuItems.toggleConditionMode(action, p));
        }));
    }

    public static Button toCondition(Player player) {
        ItemStack i = ((ComponentItemBuilder)ItemBuilder.modern((Material)Material.ARROW).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.items.go_back", new Object[0]))).build();
        return Button.clickable((ItemStack)i, (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
            Player p = (Player)event.getWhoClicked();
            p.playSound((Entity)p, Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            event.setCancelled(true);
            menuView.getAPI().openMenu(p, "npc_conditions");
        }));
    }

    public static Button editConditions(Player player) {
        ItemStack i = ((ComponentItemBuilder)ItemBuilder.modern((Material)Material.COMPARATOR).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.action_customizer.conditions", new Object[0]))).build();
        return Button.clickable((ItemStack)i, (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
            event.setCancelled(true);
            Player p = (Player)event.getWhoClicked();
            p.playSound((Entity)p, Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            menuView.getAPI().openMenu(p, "npc_conditions");
        }));
    }

    public static Button numeric(Player player) {
        ItemStack i = ((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.POPPED_CHORUS_FRUIT).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.conditions.new.numeric", new Object[0]))).setLore((Object[])Msg.lore(player.locale(), "customnpcs.menus.conditions.new.numeric.description", new Object[0]))).build();
        return Button.clickable((ItemStack)i, (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
            event.setCancelled(true);
            Player p = (Player)event.getWhoClicked();
            p.playSound(p.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            NumericCondition conditional = new NumericCondition(Condition.Comparator.EQUAL_TO, Condition.Value.EXP_LEVELS, 0.0);
            MenuItems.plugin.originalEditingConditionals.remove(p.getUniqueId());
            MenuItems.plugin.editingConditionals.put(p.getUniqueId(), conditional);
            menuView.getAPI().openMenu(p, "npc_condition_customizer");
        }));
    }

    public static Button logic(Player player) {
        ItemStack i = ((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.COMPARATOR).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.conditions.new.logical", new Object[0]))).setLore((Object[])Msg.lore(player.locale(), "customnpcs.menus.conditions.new.logical.description", new Object[0]))).build();
        return Button.clickable((ItemStack)i, (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
            event.setCancelled(true);
            Player p = (Player)event.getWhoClicked();
            p.playSound(p.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            LogicalCondition conditional = new LogicalCondition(Condition.Comparator.EQUAL_TO, Condition.Value.GAMEMODE, "CREATIVE");
            MenuItems.plugin.originalEditingConditionals.remove(p.getUniqueId());
            MenuItems.plugin.editingConditionals.put(p.getUniqueId(), conditional);
            menuView.getAPI().openMenu(p, "npc_condition_customizer");
        }));
    }

    static {
        plugin = CustomNPCs.getInstance();
        MENU_GLASS = Button.clickable((ItemStack)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.BLACK_STAINED_GLASS_PANE).setDisplay((Object)Component.text((String)" "))).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> event.setCancelled(true)));
    }
}

