/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.internal.menu;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import dev.foxikle.customnpcs.actions.Action;
import dev.foxikle.customnpcs.internal.CustomNPCs;
import dev.foxikle.customnpcs.internal.interfaces.InternalNpc;
import dev.foxikle.customnpcs.internal.menu.MenuItems;
import dev.foxikle.customnpcs.internal.menu.SkinCatalog;
import dev.foxikle.customnpcs.internal.utils.Msg;
import io.github.mqzen.menus.Lotus;
import io.github.mqzen.menus.base.Content;
import io.github.mqzen.menus.base.pagination.Page;
import io.github.mqzen.menus.base.pagination.PageComponent;
import io.github.mqzen.menus.base.pagination.PageView;
import io.github.mqzen.menus.base.pagination.Pagination;
import io.github.mqzen.menus.misc.Capacity;
import io.github.mqzen.menus.misc.itembuilder.ComponentItemBuilder;
import io.github.mqzen.menus.misc.itembuilder.ItemBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SkullMeta;

public class MenuUtils {
    public static final String NPC_DELETE = "npc_delete";
    public static final String NPC_DELETE_LINE = "npc_delete_line";
    public static final String NPC_MAIN = "npc_main";
    public static final String NPC_EXTRA_SETTINGS = "npc_extra_settings";
    public static final String NPC_ACTIONS = "npc_actions";
    public static final String NPC_NEW_ACTION = "npc_new_action";
    public static final String NPC_POSE = "npc_pose";
    public static final String NPC_EQUIPMENT = "npc_equipment";
    public static final String NPC_ACTION_CUSTOMIZER = "npc_action_customizer";
    public static final String NPC_CONDITION_CUSTOMIZER = "npc_condition_customizer";
    public static final String NPC_SKIN_CATALOG = "npc_skin_catalog";
    public static final String NPC_NEW_CONDITION = "npc_new_condition";
    public static final String NPC_CONDITIONS = "npc_conditions";
    public static final String NPC_SKIN = "npc_skin";
    public static final String NPC_HOLOGRAMS = "npc_holograms";
    private final CustomNPCs plugin;
    private final Map<String, Pagination> catalog = new HashMap<String, Pagination>();

    public MenuUtils(CustomNPCs plugin) {
        this.plugin = plugin;
    }

    public static Content.Builder actionBase(Action action, Player player) {
        return Content.builder((Capacity)Capacity.ofRows((int)5)).apply(content -> content.fill(MenuItems.MENU_GLASS)).setButton(0, MenuItems.decrementDelay(action, player)).setButton(1, MenuItems.delayDisplay(action, player)).setButton(2, MenuItems.incrementDelay(action, player)).setButton(6, MenuItems.decrementCooldown(action, player)).setButton(7, MenuItems.cooldownDisplay(action, player)).setButton(8, MenuItems.incrementCooldown(action, player)).setButton(36, MenuItems.toAction(player)).setButton(40, MenuItems.saveAction(action, player)).setButton(44, MenuItems.editConditions(player));
    }

    public String getValue(String name) {
        return this.plugin.getConfig().getConfigurationSection("Skins").getString(name + ".value");
    }

    public Pagination getSkinCatalogue(Locale locale) {
        String lang = locale.getLanguage();
        if (this.catalog.containsKey(lang)) {
            return this.catalog.get(lang);
        }
        this.catalog.put(lang, Pagination.auto((Lotus)this.plugin.getLotus()).creator((Page)new SkinCatalog()).componentProvider(() -> this.makeIcons(locale)).build());
        return this.catalog.get(lang);
    }

    public Pagination refreshCatalog(Locale locale) {
        this.catalog.remove(locale.getLanguage());
        return this.getSkinCatalogue(locale);
    }

    private List<PageComponent> makeIcons(Locale locale) {
        FileConfiguration config = this.plugin.getConfig();
        ConfigurationSection section = config.getConfigurationSection("Skins");
        Set names = section.getKeys(false);
        ArrayList<PageComponent> buttons = new ArrayList<PageComponent>();
        for (String str : names) {
            String value = section.getString(str + ".value");
            buttons.add(new SkinIcon(value, section.getString(str + ".signature"), str.replace("_", " "), this.plugin, locale));
        }
        return buttons;
    }

    public static class SkinIcon
    implements PageComponent {
        private final String value;
        private final String signature;
        private final String name;
        private final CustomNPCs plugin;
        private final Locale locale;

        public SkinIcon(String value, String signature, String name, CustomNPCs plugin, Locale player) {
            this.value = value;
            this.signature = signature;
            this.name = name;
            this.plugin = plugin;
            this.locale = player;
        }

        public ItemStack toItem() {
            return ((ComponentItemBuilder)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.PLAYER_HEAD).setDisplay((Object)Msg.format("<yellow>" + this.name))).setLore((Object[])new Component[]{Msg.translate(this.locale, "customnpcs.menus.skin_catalog.items.icon.lore", this.name), Component.empty(), Msg.translate(this.locale, "customnpcs.items.click_to_select", new Object[0])})).modifyMeta(SkullMeta.class, skullMeta -> {
                PlayerProfile profile = Bukkit.createProfile((UUID)UUID.randomUUID());
                profile.setProperty(new ProfileProperty("textures", this.value));
                skullMeta.setPlayerProfile(profile);
            })).build();
        }

        public void onClick(PageView pageView, InventoryClickEvent event) {
            Player player = (Player)event.getWhoClicked();
            player.playSound((Entity)player, Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            InternalNpc npc = (InternalNpc)this.plugin.getEditingNPCs().getIfPresent((Object)player.getUniqueId());
            if (npc == null) {
                player.closeInventory(InventoryCloseEvent.Reason.PLUGIN);
                player.sendMessage(Msg.translate(player.locale(), "customnpcs.error.npc-menu-expired", new Object[0]));
                return;
            }
            event.setCancelled(true);
            npc.getSettings().setSkinData(this.signature, this.value, this.name);
            player.sendMessage(Msg.translate(player.locale(), "customnpcs.skins.changed_with_catalog", this.name));
            this.plugin.getLotus().openMenu(player, MenuUtils.NPC_MAIN);
        }
    }
}

