/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.internal.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.apache.commons.lang3.StringUtils;

public class ComponentWrapper {
    public static List<Component> wrap(Component component, int length) {
        if (!(component instanceof TextComponent)) {
            return Collections.singletonList(component);
        }
        TextComponent text = (TextComponent)component;
        ArrayList<Component> wrapped = new ArrayList<Component>();
        List<TextComponent> parts = ComponentWrapper.flatten(text);
        TextComponent currentLine = Component.empty();
        int lineLength = 0;
        for (int i = 0; i < parts.size(); ++i) {
            TextComponent part = parts.get(i);
            Style style = part.style();
            String content = part.content();
            TextComponent nextPart = i == parts.size() - 1 ? null : parts.get(i + 1);
            boolean join = nextPart != null && (part.content().endsWith(" ") || nextPart.content().startsWith(" "));
            StringBuilder lineBuilder = new StringBuilder();
            String[] words = content.split(" ");
            Pattern delimiterPattern = Pattern.compile("\n");
            words = (String[])Arrays.stream(words).flatMap(word -> Arrays.stream(ComponentWrapper.split(word, delimiterPattern))).toArray(String[]::new);
            for (int j = 0; j < words.length; ++j) {
                boolean lastWord;
                String word2 = words[j];
                boolean bl = lastWord = j == words.length - 1;
                if (word2.isEmpty()) continue;
                boolean isLongEnough = lineLength != 0 && lineLength + word2.length() > length;
                int newLines = StringUtils.countMatches((CharSequence)word2, (char)'\n') + (isLongEnough ? 1 : 0);
                for (int k = 0; k < newLines; ++k) {
                    String endOfLine = lineBuilder.toString();
                    currentLine = currentLine.append(Component.text((String)endOfLine).style(style));
                    wrapped.add((Component)currentLine);
                    lineLength = 0;
                    currentLine = Component.empty().style(style);
                    lineBuilder = new StringBuilder();
                }
                boolean addSpace = (!lastWord || join) && !word2.endsWith("\n");
                String cleanWord = word2.replace("\n", "");
                lineBuilder.append(cleanWord).append(addSpace ? " " : "");
                lineLength += word2.length() + 1;
            }
            String endOfComponent = lineBuilder.toString();
            if (endOfComponent.isEmpty()) continue;
            currentLine = currentLine.append(Component.text((String)endOfComponent).style(style));
        }
        if (lineLength > 0) {
            wrapped.add((Component)currentLine);
        }
        return wrapped;
    }

    private static List<TextComponent> flatten(TextComponent component) {
        ArrayList<TextComponent> flattened = new ArrayList<TextComponent>();
        Style enforcedState = ComponentWrapper.enforceStates(component.style());
        component = (TextComponent)component.style(enforcedState);
        Stack<TextComponent> toCheck = new Stack<TextComponent>();
        toCheck.add(component);
        while (!toCheck.empty()) {
            TextComponent parent = (TextComponent)toCheck.pop();
            if (!parent.content().isEmpty()) {
                flattened.add(parent);
            }
            ArrayList reversed = new ArrayList(parent.children());
            Collections.reverse(reversed);
            for (Component child : reversed) {
                if (child instanceof TextComponent) {
                    TextComponent text = (TextComponent)child;
                    Style style = parent.style();
                    style = style.merge(child.style());
                    toCheck.add((TextComponent)text.style(style));
                    continue;
                }
                toCheck.add(ComponentWrapper.unsupported());
            }
        }
        return flattened;
    }

    private static Style enforceStates(Style style) {
        Style.Builder builder = style.toBuilder();
        style.decorations().forEach((decoration, state) -> {
            if (state == TextDecoration.State.NOT_SET) {
                builder.decoration(decoration, false);
            }
        });
        return builder.build();
    }

    private static TextComponent unsupported() {
        return (TextComponent)Component.text((String)"!CANNOT WRAP!").color((TextColor)NamedTextColor.DARK_RED);
    }

    private static String[] split(CharSequence input, Pattern pattern) {
        int matchCount = 0;
        int index = 0;
        ArrayList<String> matchList = new ArrayList<String>();
        Matcher m = pattern.matcher(input);
        while (m.find()) {
            if (index == 0 && index == m.start() && 0 == m.end()) continue;
            String match = input.subSequence(index, m.start()).toString();
            matchList.add(match);
            index = m.end();
            matchList.add(input.subSequence(m.start(), index).toString());
            ++matchCount;
        }
        if (index == 0) {
            return new String[]{input.toString()};
        }
        matchList.add(input.subSequence(index, input.length()).toString());
        int resultSize = matchList.size();
        String[] result = new String[resultSize];
        return matchList.subList(0, resultSize).toArray(result);
    }
}

