/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.internal.utils;

import io.github.mqzen.menus.base.Menu;
import io.github.mqzen.menus.base.MenuView;
import io.github.mqzen.menus.misc.button.actions.ButtonClickAction;
import java.util.function.Consumer;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;

public class OpenButtonAction
implements ButtonClickAction {
    private final String id;
    private final Consumer<Player> action;

    public OpenButtonAction(String id) {
        this.id = id;
        this.action = player -> player.playSound((Entity)player, Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
    }

    public OpenButtonAction(String id, Consumer<Player> beforeOpen) {
        this.id = id;
        this.action = beforeOpen;
    }

    public OpenButtonAction(Menu menu) {
        this(menu.getName());
    }

    public String tag() {
        return "OPEN";
    }

    public void execute(MenuView<?> menuView, InventoryClickEvent inventoryClickEvent) {
        Player player = (Player)inventoryClickEvent.getWhoClicked();
        if (this.action != null) {
            this.action.accept(player);
        }
        menuView.getAPI().openMenu(player, this.id);
    }
}

