/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.internal.utils;

import com.google.common.reflect.TypeToken;
import dev.foxikle.customnpcs.actions.conditions.Condition;
import dev.foxikle.customnpcs.data.Settings;
import dev.foxikle.customnpcs.internal.interfaces.InternalNpc;
import dev.foxikle.customnpcs.internal.utils.Msg;
import java.lang.reflect.Type;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;

public class Utils {
    public static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.#");
    public static final Type CONDITIONS_LIST = new TypeToken<List<Condition>>(){}.getType();

    @SafeVarargs
    public static <E> List<E> list(E ... vararg) {
        return new ArrayList<E>(List.of(vararg));
    }

    public static String style(String str) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)str);
    }

    private static int getTotalExperience(int level) {
        int xp = 0;
        if (level >= 0 && level <= 15) {
            xp = (int)Math.round(Math.pow(level, 2.0) + (double)(6 * level));
        } else if (level > 15 && level <= 30) {
            xp = (int)Math.round(2.5 * Math.pow(level, 2.0) - 40.5 * (double)level + 360.0);
        } else if (level > 30) {
            xp = (int)Math.round(4.5 * Math.pow(level, 2.0) - 162.5 * (double)level + 2220.0);
        }
        return xp;
    }

    public static int getTotalExperience(Player player) {
        return Math.round(player.getExp() * (float)player.getExpToLevel()) + Utils.getTotalExperience(player.getLevel());
    }

    @ApiStatus.Internal
    public static String getNpcName(Settings settings, UUID npcUUID) {
        return settings.isUpsideDown() ? "Dinnerbone" : npcUUID.toString().substring(0, 16);
    }

    public static void setTotalExperience(Player player, int amount) {
        float a = 0.0f;
        float b = 0.0f;
        float c = -amount;
        if (amount > Utils.getTotalExperience(0) && amount <= Utils.getTotalExperience(15)) {
            a = 1.0f;
            b = 6.0f;
        } else if (amount > Utils.getTotalExperience(15) && amount <= Utils.getTotalExperience(30)) {
            a = 2.5f;
            b = -40.5f;
            c += 360.0f;
        } else if (amount > Utils.getTotalExperience(30)) {
            a = 4.5f;
            b = -162.5f;
            c += 2220.0f;
        }
        int level = (int)Math.floor(((double)(-b) + Math.sqrt(Math.pow(b, 2.0) - (double)(4.0f * a * c))) / (double)(2.0f * a));
        int xp = amount - Utils.getTotalExperience(level);
        player.setLevel(level);
        player.setExp(0.0f);
        player.giveExp(xp);
    }

    public static Location calcLocation(InternalNpc npc) {
        Location loc = npc.getCurrentLocation();
        double pitch = Math.toRadians(npc.getPitch());
        double yaw = Math.toRadians(npc.getYaw());
        double xz = Math.cos(pitch);
        double x = -xz * Math.sin(yaw);
        double y = -Math.sin(pitch) + 1.62;
        double z = xz * Math.cos(yaw);
        loc.add(x, y, z);
        return loc;
    }

    @Deprecated
    public static Component mm(String str) {
        return Msg.format(str);
    }
}

