/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.versions;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.datafixers.util.Pair;
import dev.foxikle.customnpcs.actions.Action;
import dev.foxikle.customnpcs.api.Pose;
import dev.foxikle.customnpcs.data.Equipment;
import dev.foxikle.customnpcs.data.Settings;
import dev.foxikle.customnpcs.internal.CustomNPCs;
import dev.foxikle.customnpcs.internal.InjectionManager;
import dev.foxikle.customnpcs.internal.LookAtAnchor;
import dev.foxikle.customnpcs.internal.interfaces.InternalNpc;
import dev.foxikle.customnpcs.internal.utils.Utils;
import dev.foxikle.customnpcs.versions.FakeConnection_v1_20_R3;
import dev.foxikle.customnpcs.versions.FakeListener_v1_20_R3;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import lombok.Generated;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.json.JSONComponentSerializer;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.PacketPlayOutEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R3.CraftServer;
import org.bukkit.craftbukkit.v1_20_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftArmorStand;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftTextDisplay;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftItemStack;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Transformation;
import org.bukkit.util.Vector;
import org.joml.Vector3f;

public class NPC_v1_20_R3
extends EntityPlayer
implements InternalNpc {
    private final DataWatcherObject<IChatBaseComponent> TEXT_DISPLAY_ACCESSOR;
    private final Particle spawnParticle = Particle.EXPLOSION_LARGE;
    private final UUID uniqueID;
    private final CustomNPCs plugin;
    private final World world;
    private final Map<UUID, Integer> loops = new HashMap<UUID, Integer>();
    private Settings settings;
    private Equipment equipment;
    private Location spawnLoc;
    @Nullable
    private ArmorStand seat;
    private TextDisplay clickableHologram;
    private List<TextDisplay> holograms;
    private Player target;
    private List<Action> actions;
    private String clickableName = "ERROR";
    private InjectionManager injectionManager;

    public NPC_v1_20_R3(CustomNPCs plugin, World world, Location spawnLoc, Equipment equipment, Settings settings, UUID uniqueID, @Nullable Player target, List<Action> actions) {
        super((MinecraftServer)((CraftServer)Bukkit.getServer()).getServer(), ((CraftWorld)world).getHandle(), new GameProfile(uniqueID, Utils.getNpcName(settings, uniqueID)), ClientInformation.a());
        this.spawnLoc = spawnLoc;
        this.equipment = equipment;
        this.settings = settings;
        this.world = spawnLoc.getWorld();
        this.uniqueID = uniqueID;
        this.target = target;
        this.actions = actions;
        this.c = new FakeListener_v1_20_R3((MinecraftServer)((CraftServer)Bukkit.getServer()).getServer(), new FakeConnection_v1_20_R3(EnumProtocolDirection.b), this);
        this.plugin = plugin;
        try {
            Field field = Display.TextDisplay.class.getDeclaredField("aM");
            field.setAccessible(true);
            this.TEXT_DISPLAY_ACCESSOR = (DataWatcherObject)field.get(new DataWatcherObject(0, DataWatcherRegistry.f));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setPosRot(Location location) {
        this.a_(location.getX(), location.getY(), location.getZ());
        this.s(location.getPitch());
        this.r(location.getYaw());
        this.lookAt(Utils.calcLocation(this));
    }

    @Override
    public void createNPC() {
        if (this.plugin.npcs.containsKey(this.uniqueID)) {
            this.plugin.getNPCByID(this.uniqueID).remove();
            this.plugin.getNPCByID(this.uniqueID).delete();
        }
        if (this.dH()) {
            this.dJ();
        }
        this.setupHolograms();
        if (this.settings.isInteractable() && !this.settings.isHideClickableHologram()) {
            if (this.settings.getCustomInteractableHologram() == null || this.settings.getCustomInteractableHologram().isEmpty()) {
                this.setupClickableHologram(this.plugin.getConfig().getString("ClickText"));
            } else {
                this.setupClickableHologram(this.settings.getCustomInteractableHologram());
            }
        }
        this.setSkin();
        this.setPosRot(this.spawnLoc);
        this.getBukkitEntity().setInvulnerable(true);
        this.getBukkitEntity().setNoDamageTicks(Integer.MAX_VALUE);
        super.cK().b((net.minecraft.world.entity.Entity)this);
        super.getBukkitEntity().getEquipment().setItem(EquipmentSlot.HAND, this.equipment.getHand(), true);
        super.getBukkitEntity().getEquipment().setItem(EquipmentSlot.OFF_HAND, this.equipment.getOffhand(), true);
        super.getBukkitEntity().getEquipment().setItem(EquipmentSlot.HEAD, this.equipment.getHead(), true);
        super.getBukkitEntity().getEquipment().setItem(EquipmentSlot.CHEST, this.equipment.getChest(), true);
        super.getBukkitEntity().getEquipment().setItem(EquipmentSlot.LEGS, this.equipment.getLegs(), true);
        super.getBukkitEntity().getEquipment().setItem(EquipmentSlot.FEET, this.equipment.getBoots(), true);
        super.getBukkitEntity().setItemInHand(this.equipment.getHand());
        this.b(this.setupPose(this.settings.getPose()));
        if (this.settings.isResilient()) {
            this.plugin.getFileManager().addNPC(this);
        }
        this.plugin.addNPC(this, this.holograms);
        this.injectionManager = new InjectionManager(this.plugin, this);
        this.injectionManager.setup();
    }

    public void setSkin() {
        super.fR().getProperties().removeAll((Object)"textures");
        super.fR().getProperties().put((Object)"textures", (Object)new Property("textures", this.settings.getValue(), this.settings.getSignature()));
        byte bitmask = 127;
        super.an().b(EntityHuman.bM, (Object)bitmask);
    }

    @Override
    public void setupHolograms() {
        boolean displayClickable;
        double space = 0.28;
        double startingOffset = this.getPoseOffset(this.settings.getPose());
        boolean bl = displayClickable = this.settings.isInteractable() && !this.settings.isHideClickableHologram() && this.plugin.getConfig().getBoolean("DisplayClickText");
        if (displayClickable) {
            startingOffset += 0.28;
        }
        ArrayList<TextDisplay> holograms = new ArrayList<TextDisplay>();
        for (int i = 0; i < this.settings.getRawHolograms().length; ++i) {
            double y = startingOffset + (double)i * 0.28;
            TextDisplay hologram = (TextDisplay)this.spawnLoc.getWorld().spawnEntity(this.spawnLoc, EntityType.TEXT_DISPLAY);
            hologram.setInvulnerable(true);
            hologram.setBillboard(Display.Billboard.CENTER);
            hologram.addScoreboardTag("npcHologram");
            hologram.setTeleportDuration(this.settings.getInterpolationDuration());
            hologram.setTransformation(new Transformation(new Vector3f(0.0f, (float)y, 0.0f), hologram.getTransformation().getLeftRotation(), hologram.getTransformation().getScale(), hologram.getTransformation().getRightRotation()));
            holograms.add(hologram);
            ((CraftTextDisplay)hologram).getHandle().a((net.minecraft.world.entity.Entity)this, true);
        }
        this.holograms = holograms.reversed();
    }

    @Override
    public void setupClickableHologram(String name) {
        this.clickableName = name;
        this.clickableHologram = (TextDisplay)this.spawnLoc.getWorld().spawnEntity(this.spawnLoc, EntityType.TEXT_DISPLAY);
        this.clickableHologram.setInvulnerable(true);
        this.clickableHologram.setBillboard(Display.Billboard.CENTER);
        this.clickableHologram.text((Component)Component.empty());
        this.clickableHologram.addScoreboardTag("npcHologram");
        this.clickableHologram.setTeleportDuration(this.settings.getInterpolationDuration());
        this.clickableHologram.setTransformation(new Transformation(new Vector3f(0.0f, (float)this.getPoseOffset(this.settings.getPose()), 0.0f), this.clickableHologram.getTransformation().getLeftRotation(), this.clickableHologram.getTransformation().getScale(), this.clickableHologram.getTransformation().getRightRotation()));
        ((CraftTextDisplay)this.clickableHologram).getHandle().a((net.minecraft.world.entity.Entity)this, true);
    }

    @Override
    public Location getCurrentLocation() {
        if (this.seat != null) {
            return this.seat.getLocation();
        }
        return super.getBukkitEntity().getLocation();
    }

    @Override
    public void addAction(Action actionImpl) {
        this.actions.add(actionImpl);
    }

    @Override
    public boolean removeAction(Action actionImpl) {
        return this.actions.remove(actionImpl);
    }

    @Override
    public void injectPlayer(final Player p) {
        if (p.getWorld() != this.spawnLoc.getWorld()) {
            return;
        }
        ArrayList<Pair> stuffs = new ArrayList<Pair>();
        stuffs.add(new Pair((Object)EnumItemSlot.a, (Object)CraftItemStack.asNMSCopy((ItemStack)this.equipment.getHand())));
        stuffs.add(new Pair((Object)EnumItemSlot.b, (Object)CraftItemStack.asNMSCopy((ItemStack)this.equipment.getOffhand())));
        stuffs.add(new Pair((Object)EnumItemSlot.f, (Object)CraftItemStack.asNMSCopy((ItemStack)this.equipment.getHead())));
        stuffs.add(new Pair((Object)EnumItemSlot.e, (Object)CraftItemStack.asNMSCopy((ItemStack)this.equipment.getChest())));
        stuffs.add(new Pair((Object)EnumItemSlot.d, (Object)CraftItemStack.asNMSCopy((ItemStack)this.equipment.getLegs())));
        stuffs.add(new Pair((Object)EnumItemSlot.c, (Object)CraftItemStack.asNMSCopy((ItemStack)this.equipment.getBoots())));
        ClientboundPlayerInfoUpdatePacket playerInfoAdd = new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.a.a, (EntityPlayer)this);
        PacketPlayOutSpawnEntity namedEntitySpawn = new PacketPlayOutSpawnEntity((net.minecraft.world.entity.Entity)this);
        ClientboundPlayerInfoRemovePacket playerInforemove = new ClientboundPlayerInfoRemovePacket(Collections.singletonList(super.cw()));
        PacketPlayOutEntityEquipment equipmentPacket = new PacketPlayOutEntityEquipment(super.aj(), stuffs);
        PacketPlayOutEntity.PacketPlayOutEntityLook rotation = new PacketPlayOutEntity.PacketPlayOutEntityLook(this.getBukkitEntity().getEntityId(), (byte)(this.getYaw() * 256.0f / 360.0f), (byte)(this.dE() * 256.0f / 360.0f), true);
        PacketPlayOutMount hideName = new PacketPlayOutMount((net.minecraft.world.entity.Entity)this);
        this.setSkin();
        PlayerConnection connection = ((CraftPlayer)p).getHandle().c;
        connection.b((Packet)playerInfoAdd);
        connection.b((Packet)namedEntitySpawn);
        connection.b((Packet)equipmentPacket);
        connection.b((Packet)rotation);
        connection.b((Packet)hideName);
        super.an().refresh(((CraftPlayer)p).getHandle());
        if (this.seat != null) {
            connection.b((Packet)new PacketPlayOutMount((net.minecraft.world.entity.Entity)((CraftArmorStand)this.seat).getHandle()));
        }
        if (this.plugin.isDebug()) {
            this.plugin.getLogger().info("[DEBUG] Injected npc '" + this.displayName + "' to player '" + p.getName() + "'");
        }
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.plugin, () -> connection.b((Packet)playerInforemove), 30L);
        if (!this.settings.isUpsideDown()) {
            super.an().b(EntityHuman.bM, (Object)-2);
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.injectHolograms(p), 3L);
        this.injectHolograms(p);
        if (this.plugin.papi) {
            if (this.loops.containsKey(p.getUniqueId())) {
                Bukkit.getScheduler().cancelTask(this.loops.get(p.getUniqueId()).intValue());
            }
            this.loops.put(p.getUniqueId(), new BukkitRunnable(){

                public void run() {
                    if (!p.isOnline()) {
                        this.cancel();
                        NPC_v1_20_R3.this.loops.remove(p.getUniqueId());
                    }
                    NPC_v1_20_R3.this.injectHolograms(p);
                }
            }.runTaskTimerAsynchronously((Plugin)this.plugin, 0L, (long)this.plugin.getConfig().getInt("HologramUpdateInterval")).getTaskId());
        }
    }

    private void injectHolograms(Player p) {
        PlayerConnection connection = ((CraftPlayer)p).getHandle().c;
        String[] hologramText = new String[this.settings.getRawHolograms().length];
        String clickableText = this.clickableName;
        if (this.plugin.papi) {
            for (i = 0; i < this.settings.getRawHolograms().length; ++i) {
                hologramText[i] = PlaceholderAPI.setPlaceholders((Player)p, (String)this.settings.getRawHolograms()[i]);
            }
            clickableText = PlaceholderAPI.setPlaceholders((Player)p, (String)this.clickableName);
        } else {
            for (i = 0; i < this.settings.getRawHolograms().length; ++i) {
                hologramText[i] = this.settings.getRawHolograms()[i];
            }
        }
        ArrayList packets = new ArrayList();
        for (int i = 0; i < this.holograms.size(); ++i) {
            TextDisplay hologram = this.holograms.get(i);
            packets.add(this.createMojComponent(hologramText[i], hologram));
        }
        if (this.clickableHologram != null && this.settings.isInteractable() && !this.settings.isHideClickableHologram()) {
            packets.add(this.createMojComponent(clickableText, this.clickableHologram));
        }
        packets.forEach(arg_0 -> ((PlayerConnection)connection).b(arg_0));
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> packets.forEach(arg_0 -> ((PlayerConnection)connection).b(arg_0)), 5L);
    }

    private Packet<?> createMojComponent(String clickableText, TextDisplay clickableHologram) {
        List meta = ((CraftTextDisplay)clickableHologram).getHandle().an().c();
        String serialized_component = (String)JSONComponentSerializer.json().serialize(this.plugin.getMiniMessage().deserialize((Object)clickableText));
        IChatMutableComponent clickableComponent = IChatBaseComponent.ChatSerializer.a((String)serialized_component);
        meta.set(0, DataWatcher.b.a(this.TEXT_DISPLAY_ACCESSOR, (Object)clickableComponent));
        return new PacketPlayOutEntityMetadata(clickableHologram.getEntityId(), meta);
    }

    @Override
    public void remove() {
        this.injectionManager.shutDown();
        this.loops.forEach((uuid1, integer) -> Bukkit.getScheduler().cancelTask(integer.intValue()));
        this.loops.clear();
        ArrayList<PacketPlayOutEntityDestroy> packets = new ArrayList<PacketPlayOutEntityDestroy>();
        if (this.holograms != null) {
            for (TextDisplay hologram : this.holograms) {
                packets.add(new PacketPlayOutEntityDestroy(new int[]{hologram.getEntityId()}));
                hologram.remove();
            }
        }
        if (this.seat != null) {
            this.seat.remove();
        }
        if (this.clickableHologram != null) {
            packets.add(new PacketPlayOutEntityDestroy(new int[]{this.clickableHologram.getEntityId()}));
            this.clickableHologram.remove();
        }
        packets.add(new PacketPlayOutEntityDestroy(new int[]{super.aj()}));
        super.a(Entity.RemovalReason.b);
        for (Player p : Bukkit.getOnlinePlayers()) {
            PlayerConnection connection = ((CraftPlayer)p).getHandle().c;
            packets.forEach(arg_0 -> ((PlayerConnection)connection).b(arg_0));
        }
    }

    @Override
    public void moveTo(Vector v) {
        if (this.dH()) {
            return;
        }
        if (this.seat != null) {
            ((CraftArmorStand)this.seat).getHandle().a(EnumMoveType.b, new Vec3D(v.getX(), v.getY(), v.getZ()));
            this.spawnLoc = this.seat.getLocation();
        } else {
            super.a(EnumMoveType.b, new Vec3D(v.getX(), v.getY(), v.getZ()));
            this.spawnLoc = this.getCurrentLocation();
        }
    }

    @Override
    public void teleport(Location loc) {
        this.c(loc.x(), loc.y(), loc.z());
        this.spawnLoc = loc;
    }

    @Override
    public void delete() {
        this.plugin.getFileManager().remove(this.uniqueID);
    }

    @Override
    public void lookAt(LookAtAnchor anchor, Entity e) {
        switch (anchor) {
            case HEAD: {
                super.a(ArgumentAnchor.Anchor.b, ((CraftEntity)e).getHandle(), ArgumentAnchor.Anchor.b);
                break;
            }
            case FEET: {
                super.a(ArgumentAnchor.Anchor.b, ((CraftEntity)e).getHandle(), ArgumentAnchor.Anchor.a);
            }
        }
    }

    @Override
    public void lookAt(Location loc) {
        super.a(ArgumentAnchor.Anchor.b, new Vec3D(loc.x(), loc.y(), loc.z()));
    }

    @Override
    public void updateSkin() {
        this.setSkin();
    }

    @Override
    public void swingArm() {
        super.a(EnumHand.a, true);
    }

    @Override
    public void reloadSettings() {
        if (this.seat != null) {
            this.seat.remove();
            this.seat = null;
        }
        if (this.holograms != null) {
            for (TextDisplay hologram : this.holograms) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> ((TextDisplay)hologram).remove());
                hologram.remove();
            }
            this.holograms.clear();
        }
        if (this.clickableHologram != null) {
            this.clickableHologram.remove();
        }
        this.b(this.setupPose(this.settings.getPose()));
        this.setupHolograms();
        for (TextDisplay hologram : this.holograms) {
            hologram.setBackgroundColor(this.settings.isHideBackgroundHologram() ? null : this.settings.getHologramBackground());
        }
        if (this.settings.isInteractable() && !this.settings.isHideClickableHologram()) {
            if (this.settings.getCustomInteractableHologram().isEmpty()) {
                this.setupClickableHologram(this.plugin.getConfig().getString("ClickText"));
            } else {
                this.setupClickableHologram(this.settings.getCustomInteractableHologram());
            }
            if (this.settings.isHideBackgroundHologram()) {
                this.clickableHologram.setBackgroundColor(null);
            }
            if (this.settings.getHologramBackground() != null) {
                this.clickableHologram.setBackgroundColor(this.settings.getHologramBackground());
            }
        }
        this.setSkin();
        super.getBukkitEntity().getEquipment().setItem(EquipmentSlot.HAND, this.equipment.getHand(), true);
        super.getBukkitEntity().getEquipment().setItem(EquipmentSlot.OFF_HAND, this.equipment.getOffhand(), true);
        super.getBukkitEntity().getEquipment().setItem(EquipmentSlot.HEAD, this.equipment.getHead(), true);
        super.getBukkitEntity().getEquipment().setItem(EquipmentSlot.CHEST, this.equipment.getChest(), true);
        super.getBukkitEntity().getEquipment().setItem(EquipmentSlot.LEGS, this.equipment.getLegs(), true);
        super.getBukkitEntity().getEquipment().setItem(EquipmentSlot.FEET, this.equipment.getBoots(), true);
        super.getBukkitEntity().setItemInHand(this.equipment.getHand());
    }

    @Override
    public void setYRotation(float f) {
        super.r(f);
        super.o(f);
        super.n(f);
        this.lookAt(Utils.calcLocation(this));
    }

    @Override
    public void setXRotation(float f) {
        super.s(f);
        this.lookAt(Utils.calcLocation(this));
    }

    private EntityPose setupPose(Pose pose) {
        return switch (pose) {
            case Pose.SLEEPING -> EntityPose.c;
            case Pose.SWIMMING -> EntityPose.d;
            case Pose.CROUCHING -> EntityPose.f;
            case Pose.SITTING -> {
                this.seat = (ArmorStand)this.world.spawn(new Location(this.world, 0.0, 0.0, 0.0), ArmorStand.class);
                this.seat.setMarker(true);
                this.seat.setVisible(false);
                this.seat.teleport(this.spawnLoc);
                this.a((net.minecraft.world.entity.Entity)((CraftArmorStand)this.seat).getHandle(), true);
                yield EntityPose.a;
            }
            case Pose.DYING -> {
                this.c(0.0f);
                yield EntityPose.h;
            }
            default -> EntityPose.a;
        };
    }

    public double getPoseOffset(Pose pose) {
        return switch (pose) {
            default -> throw new MatchException(null, null);
            case Pose.STANDING -> 0.2;
            case Pose.SITTING -> 0.2;
            case Pose.CROUCHING -> 0.175;
            case Pose.SWIMMING -> 0.14;
            case Pose.DYING -> 0.05;
            case Pose.SLEEPING -> 0.1;
        };
    }

    @Override
    public InternalNpc clone() {
        return new NPC_v1_20_R3(this.plugin, this.world, this.spawnLoc.clone(), this.equipment.clone(), this.settings.clone(), UUID.randomUUID(), this.target, new ArrayList<Action>(this.actions));
    }

    @Override
    public float getYaw() {
        return this.dC();
    }

    @Override
    public float getPitch() {
        return this.dE();
    }

    @Override
    @Generated
    public Particle getSpawnParticle() {
        return this.spawnParticle;
    }

    @Override
    @Generated
    public UUID getUniqueID() {
        return this.uniqueID;
    }

    @Override
    @Generated
    public World getWorld() {
        return this.world;
    }

    @Override
    @Generated
    public Settings getSettings() {
        return this.settings;
    }

    @Override
    @Generated
    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    @Override
    @Generated
    public Equipment getEquipment() {
        return this.equipment;
    }

    @Override
    @Generated
    public void setEquipment(Equipment equipment) {
        this.equipment = equipment;
    }

    @Override
    @Generated
    public Location getSpawnLoc() {
        return this.spawnLoc;
    }

    @Override
    @Generated
    public void setSpawnLoc(Location spawnLoc) {
        this.spawnLoc = spawnLoc;
    }

    @Override
    @Generated
    public TextDisplay getClickableHologram() {
        return this.clickableHologram;
    }

    @Override
    @Generated
    public List<TextDisplay> getHolograms() {
        return this.holograms;
    }

    @Generated
    public Player getTarget() {
        return this.target;
    }

    @Override
    @Generated
    public void setTarget(Player target) {
        this.target = target;
    }

    @Override
    @Generated
    public List<Action> getActions() {
        return this.actions;
    }

    @Override
    @Generated
    public void setActions(List<Action> actions) {
        this.actions = actions;
    }
}

