/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.versions;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.datafixers.util.Pair;
import dev.foxikle.customnpcs.actions.Action;
import dev.foxikle.customnpcs.api.Pose;
import dev.foxikle.customnpcs.data.Equipment;
import dev.foxikle.customnpcs.data.Settings;
import dev.foxikle.customnpcs.internal.CustomNPCs;
import dev.foxikle.customnpcs.internal.InjectionManager;
import dev.foxikle.customnpcs.internal.LookAtAnchor;
import dev.foxikle.customnpcs.internal.interfaces.InternalNpc;
import dev.foxikle.customnpcs.internal.utils.Msg;
import dev.foxikle.customnpcs.internal.utils.Utils;
import dev.foxikle.customnpcs.versions.FakeConnection_v1_21_R3;
import dev.foxikle.customnpcs.versions.FakeListener_v1_21_R3;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import lombok.Generated;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.json.JSONComponentSerializer;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundMoveEntityPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftArmorStand;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.entity.CraftTextDisplay;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.TextDisplay;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Transformation;
import org.bukkit.util.Vector;
import org.joml.Vector3f;

public class NPC_v1_21_R3
extends ServerPlayer
implements InternalNpc {
    private static final EntityDataAccessor<net.minecraft.network.chat.Component> TEXT_DISPLAY_ACCESSOR;
    private final UUID uniqueID;
    private final CustomNPCs plugin;
    private final World world;
    private final Map<UUID, Integer> loops = new HashMap<UUID, Integer>();
    private Settings settings;
    private Equipment equipment;
    private Location spawnLoc;
    @Nullable
    private TextDisplay clickableHologram;
    private List<TextDisplay> holograms;
    @Nullable
    private ArmorStand seat;
    private org.bukkit.entity.Player target;
    private List<Action> actions;
    private String clickableName = "ERROR";
    private InjectionManager injectionManager;

    public NPC_v1_21_R3(CustomNPCs plugin, World world, Location spawnLoc, Equipment equipment, Settings settings, UUID uuid, @Nullable org.bukkit.entity.Player target, List<Action> actions) {
        super((MinecraftServer)((CraftServer)Bukkit.getServer()).getServer(), ((CraftWorld)world).getHandle(), new GameProfile(uuid, Utils.getNpcName(settings, uuid)), ClientInformation.createDefault());
        this.spawnLoc = spawnLoc;
        this.equipment = equipment;
        this.settings = settings;
        this.world = spawnLoc.getWorld();
        this.uniqueID = uuid;
        this.target = target;
        this.actions = actions;
        this.connection = new FakeListener_v1_21_R3((MinecraftServer)((CraftServer)Bukkit.getServer()).getServer(), new FakeConnection_v1_21_R3(PacketFlow.CLIENTBOUND), this);
        this.plugin = plugin;
    }

    @Override
    public void setPosRot(Location location) {
        this.setPos(location.getX(), location.getY(), location.getZ());
        this.setXRot(location.getPitch());
        this.setYRot(location.getYaw());
        this.lookAt(Utils.calcLocation(this));
    }

    @Override
    public void createNPC() {
        if (this.plugin.npcs.containsKey(this.uniqueID)) {
            this.plugin.getNPCByID(this.uniqueID).remove();
            this.plugin.getNPCByID(this.uniqueID).delete();
        }
        if (this.isRemoved()) {
            this.unsetRemoved();
        }
        this.setupHolograms();
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            if (this.settings.isInteractable() && !this.settings.isHideClickableHologram()) {
                if (this.settings.getCustomInteractableHologram() == null || this.settings.getCustomInteractableHologram().isEmpty()) {
                    this.setupClickableHologram(this.plugin.getConfig().getString("ClickText"));
                } else {
                    this.setupClickableHologram(this.settings.getCustomInteractableHologram());
                }
            }
        });
        this.setSkin();
        this.setPosRot(this.spawnLoc);
        this.getBukkitEntity().setInvulnerable(true);
        this.getBukkitEntity().setNoDamageTicks(Integer.MAX_VALUE);
        super.getCommandSenderWorld().addFreshEntity((net.minecraft.world.entity.Entity)this);
        super.getBukkitEntity().getEquipment().setItem(org.bukkit.inventory.EquipmentSlot.HAND, this.equipment.getHand(), true);
        super.getBukkitEntity().getEquipment().setItem(org.bukkit.inventory.EquipmentSlot.OFF_HAND, this.equipment.getOffhand(), true);
        super.getBukkitEntity().getEquipment().setItem(org.bukkit.inventory.EquipmentSlot.HEAD, this.equipment.getHead(), true);
        super.getBukkitEntity().getEquipment().setItem(org.bukkit.inventory.EquipmentSlot.CHEST, this.equipment.getChest(), true);
        super.getBukkitEntity().getEquipment().setItem(org.bukkit.inventory.EquipmentSlot.LEGS, this.equipment.getLegs(), true);
        super.getBukkitEntity().getEquipment().setItem(org.bukkit.inventory.EquipmentSlot.FEET, this.equipment.getBoots(), true);
        super.getBukkitEntity().addScoreboardTag("NPC");
        super.getBukkitEntity().setItemInHand(this.equipment.getHand());
        this.setPose(this.setupPose(this.settings.getPose()));
        if (this.settings.isResilient()) {
            this.plugin.getFileManager().addNPC(this);
        }
        this.plugin.addNPC(this, this.holograms);
        this.injectionManager = new InjectionManager(this.plugin, this);
        this.injectionManager.setup();
    }

    public void setSkin() {
        super.getGameProfile().getProperties().removeAll((Object)"textures");
        super.getGameProfile().getProperties().put((Object)"textures", (Object)new Property("textures", this.settings.getValue(), this.settings.getSignature()));
        byte bitmask = 127;
        super.getEntityData().set(Player.DATA_PLAYER_MODE_CUSTOMISATION, (Object)bitmask);
    }

    @Override
    public void setupHolograms() {
        boolean displayClickable;
        double space = 0.28;
        double startingOffset = this.getPoseOffset(this.settings.getPose());
        boolean bl = displayClickable = this.settings.isInteractable() && !this.settings.isHideClickableHologram() && this.plugin.getConfig().getBoolean("DisplayClickText");
        if (displayClickable) {
            startingOffset += 0.28;
        }
        ArrayList<TextDisplay> holograms = new ArrayList<TextDisplay>();
        for (int i = 0; i < this.settings.getRawHolograms().length; ++i) {
            double y = startingOffset + (double)i * 0.28;
            TextDisplay hologram = (TextDisplay)this.spawnLoc.getWorld().spawnEntity(this.spawnLoc, EntityType.TEXT_DISPLAY);
            hologram.setInvulnerable(true);
            hologram.setBillboard(Display.Billboard.CENTER);
            hologram.addScoreboardTag("npcHologram");
            hologram.setTeleportDuration(this.settings.getInterpolationDuration());
            hologram.setTransformation(new Transformation(new Vector3f(0.0f, (float)y, 0.0f), hologram.getTransformation().getLeftRotation(), hologram.getTransformation().getScale(), hologram.getTransformation().getRightRotation()));
            holograms.add(hologram);
            ((CraftTextDisplay)hologram).getHandle().startRiding((net.minecraft.world.entity.Entity)this, true);
        }
        this.holograms = holograms.reversed();
    }

    @Override
    public void setupClickableHologram(String name) {
        this.clickableName = name;
        this.clickableHologram = (TextDisplay)this.spawnLoc.getWorld().spawnEntity(this.spawnLoc, EntityType.TEXT_DISPLAY);
        this.clickableHologram.setInvulnerable(true);
        this.clickableHologram.setBillboard(Display.Billboard.CENTER);
        this.clickableHologram.text((Component)Component.empty());
        this.clickableHologram.addScoreboardTag("npcHologram");
        this.clickableHologram.setTeleportDuration(this.settings.getInterpolationDuration());
        this.clickableHologram.setTransformation(new Transformation(new Vector3f(0.0f, (float)this.getPoseOffset(this.settings.getPose()), 0.0f), this.clickableHologram.getTransformation().getLeftRotation(), this.clickableHologram.getTransformation().getScale(), this.clickableHologram.getTransformation().getRightRotation()));
        ((CraftTextDisplay)this.clickableHologram).getHandle().startRiding((net.minecraft.world.entity.Entity)this, true);
    }

    @Override
    public Location getCurrentLocation() {
        if (this.seat != null) {
            return this.seat.getLocation();
        }
        return super.getBukkitEntity().getLocation();
    }

    @Override
    public void addAction(Action actionImpl) {
        this.actions.add(actionImpl);
    }

    @Override
    public boolean removeAction(Action actionImpl) {
        return this.actions.remove(actionImpl);
    }

    @Override
    public void injectPlayer(final org.bukkit.entity.Player p) {
        if (this.world != p.getWorld()) {
            return;
        }
        ArrayList<Pair> stuffs = new ArrayList<Pair>();
        stuffs.add(new Pair((Object)EquipmentSlot.MAINHAND, (Object)CraftItemStack.asNMSCopy((ItemStack)this.equipment.getHand())));
        stuffs.add(new Pair((Object)EquipmentSlot.OFFHAND, (Object)CraftItemStack.asNMSCopy((ItemStack)this.equipment.getOffhand())));
        stuffs.add(new Pair((Object)EquipmentSlot.HEAD, (Object)CraftItemStack.asNMSCopy((ItemStack)this.equipment.getHead())));
        stuffs.add(new Pair((Object)EquipmentSlot.CHEST, (Object)CraftItemStack.asNMSCopy((ItemStack)this.equipment.getChest())));
        stuffs.add(new Pair((Object)EquipmentSlot.LEGS, (Object)CraftItemStack.asNMSCopy((ItemStack)this.equipment.getLegs())));
        stuffs.add(new Pair((Object)EquipmentSlot.FEET, (Object)CraftItemStack.asNMSCopy((ItemStack)this.equipment.getBoots())));
        ClientboundPlayerInfoUpdatePacket playerInfoAdd = new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.ADD_PLAYER, (ServerPlayer)this);
        ClientboundAddEntityPacket namedEntitySpawn = new ClientboundAddEntityPacket(this.getId(), this.uniqueID, this.spawnLoc.x(), this.spawnLoc.y(), this.spawnLoc.z(), this.getYRot(), this.getXRot(), net.minecraft.world.entity.EntityType.PLAYER, 0, new Vec3(0.0, 0.0, 0.0), (double)this.getYRot());
        ClientboundPlayerInfoRemovePacket playerInforemove = new ClientboundPlayerInfoRemovePacket(Collections.singletonList(super.getUUID()));
        ClientboundSetEquipmentPacket equipmentPacket = new ClientboundSetEquipmentPacket(super.getId(), stuffs);
        ClientboundMoveEntityPacket.Rot rotation = new ClientboundMoveEntityPacket.Rot(this.getBukkitEntity().getEntityId(), (byte)(this.getYRot() * 256.0f / 360.0f), (byte)(this.getXRot() * 256.0f / 360.0f), true);
        this.setSkin();
        ClientboundSetPassengersPacket hideName = new ClientboundSetPassengersPacket((net.minecraft.world.entity.Entity)this);
        ServerGamePacketListenerImpl connection = ((CraftPlayer)p).getHandle().connection;
        connection.send((Packet)playerInfoAdd);
        connection.send((Packet)namedEntitySpawn);
        connection.send((Packet)equipmentPacket);
        connection.send((Packet)rotation);
        connection.send((Packet)hideName);
        connection.send((Packet)new ClientboundSetEntityDataPacket(this.getId(), super.getEntityData().packAll()));
        if (this.seat != null) {
            connection.send((Packet)new ClientboundSetPassengersPacket((net.minecraft.world.entity.Entity)((CraftArmorStand)this.seat).getHandle()));
        }
        if (this.plugin.isDebug()) {
            this.plugin.getLogger().info("[DEBUG] Injected npc '" + this.displayName + "' to player '" + p.getName() + "'");
        }
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.plugin, () -> connection.send((Packet)playerInforemove), 30L);
        if (!this.settings.isUpsideDown()) {
            super.getEntityData().set(Player.DATA_PLAYER_MODE_CUSTOMISATION, (Object)-2);
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.injectHolograms(p), 3L);
        this.injectHolograms(p);
        if (this.plugin.papi) {
            if (this.loops.containsKey(p.getUniqueId())) {
                Bukkit.getScheduler().cancelTask(this.loops.get(p.getUniqueId()).intValue());
            }
            this.loops.put(p.getUniqueId(), new BukkitRunnable(){

                public void run() {
                    if (!p.isOnline()) {
                        this.cancel();
                        NPC_v1_21_R3.this.loops.remove(p.getUniqueId());
                    }
                    NPC_v1_21_R3.this.injectHolograms(p);
                }
            }.runTaskTimerAsynchronously((Plugin)this.plugin, 0L, (long)this.plugin.getConfig().getInt("HologramUpdateInterval")).getTaskId());
        }
    }

    private void injectHolograms(org.bukkit.entity.Player p) {
        ServerGamePacketListenerImpl connection = ((CraftPlayer)p).getHandle().connection;
        String[] hologramText = new String[this.settings.getRawHolograms().length];
        String clickableText = this.clickableName;
        if (this.plugin.papi) {
            for (i = 0; i < this.settings.getRawHolograms().length; ++i) {
                hologramText[i] = PlaceholderAPI.setPlaceholders((org.bukkit.entity.Player)p, (String)this.settings.getRawHolograms()[i]);
            }
            clickableText = PlaceholderAPI.setPlaceholders((org.bukkit.entity.Player)p, (String)this.clickableName);
        } else {
            for (i = 0; i < this.settings.getRawHolograms().length; ++i) {
                hologramText[i] = this.settings.getRawHolograms()[i];
            }
        }
        ArrayList packets = new ArrayList();
        for (int i = 0; i < this.holograms.size(); ++i) {
            TextDisplay hologram = this.holograms.get(i);
            packets.add(this.createMojComponent(hologramText[i], hologram));
        }
        if (this.clickableHologram != null && this.settings.isInteractable() && !this.settings.isHideClickableHologram()) {
            packets.add(this.createMojComponent(clickableText, this.clickableHologram));
        }
        packets.forEach(arg_0 -> ((ServerGamePacketListenerImpl)connection).send(arg_0));
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> packets.forEach(arg_0 -> ((ServerGamePacketListenerImpl)connection).send(arg_0)), 5L);
    }

    private Packet<?> createMojComponent(String clickableText, TextDisplay clickableHologram) {
        List meta = ((CraftTextDisplay)clickableHologram).getHandle().getEntityData().getNonDefaultValues();
        String serialized_component = (String)JSONComponentSerializer.json().serialize(Msg.format(clickableText));
        MutableComponent clickableComponent = Component.Serializer.fromJson((String)serialized_component, (HolderLookup.Provider)HolderLookup.Provider.create(Stream.of(new HolderLookup.RegistryLookup[0])));
        meta.set(0, SynchedEntityData.DataValue.create(TEXT_DISPLAY_ACCESSOR, (Object)clickableComponent));
        return new ClientboundSetEntityDataPacket(clickableHologram.getEntityId(), meta);
    }

    @Override
    public void remove() {
        this.injectionManager.shutDown();
        this.loops.forEach((uuid1, integer) -> Bukkit.getScheduler().cancelTask(integer.intValue()));
        this.loops.clear();
        this.interpolation.cancel();
        ArrayList<ClientboundRemoveEntitiesPacket> packets = new ArrayList<ClientboundRemoveEntitiesPacket>();
        if (this.holograms != null) {
            for (TextDisplay hologram : this.holograms) {
                packets.add(new ClientboundRemoveEntitiesPacket(new int[]{hologram.getEntityId()}));
                hologram.remove();
            }
            this.holograms.clear();
        }
        if (this.seat != null) {
            this.seat.remove();
        }
        if (this.clickableHologram != null) {
            packets.add(new ClientboundRemoveEntitiesPacket(new int[]{this.clickableHologram.getEntityId()}));
            this.clickableHologram.remove();
        }
        packets.add(new ClientboundRemoveEntitiesPacket(new int[]{super.getId()}));
        super.remove(Entity.RemovalReason.DISCARDED);
        for (org.bukkit.entity.Player p : Bukkit.getOnlinePlayers()) {
            ServerGamePacketListenerImpl connection = ((CraftPlayer)p).getHandle().connection;
            packets.forEach(arg_0 -> ((ServerGamePacketListenerImpl)connection).send(arg_0));
        }
    }

    @Override
    public void moveTo(Vector v) {
        if (this.isRemoved()) {
            return;
        }
        if (this.seat != null) {
            ((CraftArmorStand)this.seat).getHandle().move(MoverType.PLAYER, new Vec3(v.getX(), v.getY(), v.getZ()));
            this.spawnLoc = this.seat.getLocation();
        } else {
            super.move(MoverType.PLAYER, new Vec3(v.getX(), v.getY(), v.getZ()));
            this.spawnLoc = this.getCurrentLocation();
        }
    }

    @Override
    public void teleport(Location loc) {
        if (this.isRemoved()) {
            return;
        }
        this.teleportTo(loc.x(), loc.y(), loc.z());
        this.spawnLoc = loc;
    }

    @Override
    public void delete() {
        this.plugin.getFileManager().remove(this.uniqueID);
    }

    @Override
    public void lookAt(LookAtAnchor anchor, Entity e) {
        switch (anchor) {
            case HEAD: {
                super.lookAt(EntityAnchorArgument.Anchor.EYES, ((CraftEntity)e).getHandle(), EntityAnchorArgument.Anchor.EYES);
                break;
            }
            case FEET: {
                super.lookAt(EntityAnchorArgument.Anchor.EYES, ((CraftEntity)e).getHandle(), EntityAnchorArgument.Anchor.FEET);
            }
        }
    }

    @Override
    public void lookAt(Location loc) {
        super.lookAt(EntityAnchorArgument.Anchor.EYES, new Vec3(loc.x(), loc.y(), loc.z()));
    }

    @Override
    public void updateSkin() {
        this.setSkin();
    }

    @Override
    public void swingArm() {
        super.swing(InteractionHand.MAIN_HAND, true);
    }

    @Override
    public void reloadSettings() {
        if (this.seat != null) {
            this.seat.remove();
            this.seat = null;
        }
        if (this.holograms != null) {
            for (TextDisplay hologram : this.holograms) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> ((TextDisplay)hologram).remove());
                hologram.remove();
            }
            this.holograms.clear();
        }
        if (this.clickableHologram != null) {
            this.clickableHologram.remove();
        }
        this.setPose(this.setupPose(this.settings.getPose()));
        this.setupHolograms();
        for (TextDisplay hologram : this.holograms) {
            hologram.setBackgroundColor(this.settings.isHideBackgroundHologram() ? null : this.settings.getHologramBackground());
        }
        if (this.settings.isInteractable() && !this.settings.isHideClickableHologram()) {
            if (this.settings.getCustomInteractableHologram().isEmpty()) {
                this.setupClickableHologram(this.plugin.getConfig().getString("ClickText"));
            } else {
                this.setupClickableHologram(this.settings.getCustomInteractableHologram());
            }
            if (this.settings.isHideBackgroundHologram()) {
                this.clickableHologram.setBackgroundColor(null);
            }
            if (this.settings.getHologramBackground() != null) {
                this.clickableHologram.setBackgroundColor(this.settings.getHologramBackground());
            }
        }
        this.setSkin();
        super.getBukkitEntity().getEquipment().setItem(org.bukkit.inventory.EquipmentSlot.HAND, this.equipment.getHand(), true);
        super.getBukkitEntity().getEquipment().setItem(org.bukkit.inventory.EquipmentSlot.OFF_HAND, this.equipment.getOffhand(), true);
        super.getBukkitEntity().getEquipment().setItem(org.bukkit.inventory.EquipmentSlot.HEAD, this.equipment.getHead(), true);
        super.getBukkitEntity().getEquipment().setItem(org.bukkit.inventory.EquipmentSlot.CHEST, this.equipment.getChest(), true);
        super.getBukkitEntity().getEquipment().setItem(org.bukkit.inventory.EquipmentSlot.LEGS, this.equipment.getLegs(), true);
        super.getBukkitEntity().getEquipment().setItem(org.bukkit.inventory.EquipmentSlot.FEET, this.equipment.getBoots(), true);
        super.getBukkitEntity().setItemInHand(this.equipment.getHand());
    }

    @Override
    public void setYRotation(float f) {
        super.setYRot(f);
        super.setYBodyRot(f);
        super.setYHeadRot(f);
        this.lookAt(Utils.calcLocation(this));
    }

    @Override
    public void setXRotation(float f) {
        super.setXRot(f);
        this.lookAt(Utils.calcLocation(this));
    }

    @Override
    public float getYaw() {
        return this.getYRot();
    }

    @Override
    public float getPitch() {
        return this.getXRot();
    }

    @Override
    public Particle getSpawnParticle() {
        return Particle.EXPLOSION;
    }

    private net.minecraft.world.entity.Pose setupPose(Pose pose) {
        return switch (pose) {
            case Pose.SLEEPING -> net.minecraft.world.entity.Pose.SLEEPING;
            case Pose.SWIMMING -> net.minecraft.world.entity.Pose.SWIMMING;
            case Pose.CROUCHING -> net.minecraft.world.entity.Pose.CROUCHING;
            case Pose.SITTING -> {
                this.seat = (ArmorStand)this.world.spawn(new Location(this.world, 0.0, 0.0, 0.0), ArmorStand.class);
                this.seat.setMarker(true);
                this.seat.setVisible(false);
                this.seat.teleport(this.spawnLoc);
                this.startRiding((net.minecraft.world.entity.Entity)((CraftArmorStand)this.seat).getHandle(), true);
                yield net.minecraft.world.entity.Pose.STANDING;
            }
            case Pose.DYING -> {
                this.setHealth(0.0f);
                yield net.minecraft.world.entity.Pose.DYING;
            }
            default -> net.minecraft.world.entity.Pose.STANDING;
        };
    }

    private double getPoseOffset(Pose pose) {
        return switch (pose) {
            default -> throw new MatchException(null, null);
            case Pose.STANDING -> 0.2;
            case Pose.SITTING -> 0.2;
            case Pose.CROUCHING -> 0.175;
            case Pose.SWIMMING -> 0.14;
            case Pose.DYING -> 0.05;
            case Pose.SLEEPING -> 0.1;
        };
    }

    @Override
    public InternalNpc clone() {
        return new NPC_v1_21_R3(this.plugin, this.world, this.spawnLoc.clone(), this.equipment.clone(), this.settings.clone(), UUID.randomUUID(), this.target, new ArrayList<Action>(this.actions));
    }

    @Override
    @Generated
    public UUID getUniqueID() {
        return this.uniqueID;
    }

    @Override
    @Generated
    public World getWorld() {
        return this.world;
    }

    @Override
    @Generated
    public Settings getSettings() {
        return this.settings;
    }

    @Override
    @Generated
    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    @Override
    @Generated
    public Equipment getEquipment() {
        return this.equipment;
    }

    @Override
    @Generated
    public void setEquipment(Equipment equipment) {
        this.equipment = equipment;
    }

    @Override
    @Generated
    public Location getSpawnLoc() {
        return this.spawnLoc;
    }

    @Override
    @Generated
    public void setSpawnLoc(Location spawnLoc) {
        this.spawnLoc = spawnLoc;
    }

    @Override
    @Nullable
    @Generated
    public TextDisplay getClickableHologram() {
        return this.clickableHologram;
    }

    @Override
    @Generated
    public List<TextDisplay> getHolograms() {
        return this.holograms;
    }

    @Generated
    public org.bukkit.entity.Player getTarget() {
        return this.target;
    }

    @Override
    @Generated
    public void setTarget(org.bukkit.entity.Player target) {
        this.target = target;
    }

    @Override
    @Generated
    public List<Action> getActions() {
        return this.actions;
    }

    @Override
    @Generated
    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    static {
        try {
            Field field = Display.TextDisplay.class.getDeclaredField("DATA_TEXT_ID");
            field.setAccessible(true);
            TEXT_DISPLAY_ACCESSOR = (EntityDataAccessor)field.get(new EntityDataAccessor(0, EntityDataSerializers.COMPONENT));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

