/*
 * Decompiled with CFR 0.152.
 */
package com.jtorleonstudios.awesomedungeon;

import com.jtorleonstudios.libraryferret.LibraryFerret;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function8;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import org.jetbrains.annotations.NotNull;

@Deprecated
public abstract class AwesomePlacementRndSpread
extends RandomSpreadStructurePlacement {
    protected final int spacing;
    protected final int separation;
    protected final int salt;
    protected final RandomSpreadType spreadType;
    protected final Vec3i locateOffset;
    protected final String uniqueIdentifier;
    protected final boolean useValueFromConfiguration;
    protected final Optional<SuperExclusionZone> superExclusionZone;

    public static <T extends AwesomePlacementRndSpread> MapCodec<T> createCodec(Function8<Integer, Integer, RandomSpreadType, Integer, Vec3i, String, Boolean, Optional<SuperExclusionZone>, T> awsRandomSpread) {
        return RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.intRange((int)0, (int)4096).fieldOf("spacing").forGetter(AwesomePlacementRndSpread::spacing), (App)Codec.intRange((int)0, (int)4096).fieldOf("separation").forGetter(AwesomePlacementRndSpread::separation), (App)RandomSpreadType.CODEC.optionalFieldOf("spread_type", (Object)RandomSpreadType.LINEAR).forGetter(AwesomePlacementRndSpread::spreadType), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("salt").forGetter(AwesomePlacementRndSpread::salt), (App)Vec3i.offsetCodec((int)16).optionalFieldOf("locate_offset", (Object)Vec3i.ZERO).forGetter(AwesomePlacementRndSpread::locateOffset), (App)Codec.STRING.optionalFieldOf("unique_identifier", (Object)"").forGetter(AwesomePlacementRndSpread::uniqueIdentifier), (App)Codec.BOOL.optionalFieldOf("use_value_from_config_file", (Object)false).forGetter(AwesomePlacementRndSpread::useValueFromConfiguration), (App)SuperExclusionZone.CODEC.optionalFieldOf("super_exclusion_zone").forGetter(AwesomePlacementRndSpread::superExclusionZone)).apply((Applicative)i, i.stable((Object)awsRandomSpread))).flatXmap(r -> r.spacing <= r.separation ? DataResult.error(() -> "Spacing has to be larger than separation") : (r.useValueFromConfiguration && r.uniqueIdentifier.length() <= 1 ? DataResult.error(() -> "Require String field `unique_identifier` if use value from configuration") : DataResult.success((Object)r)), DataResult::success).stable();
    }

    public AwesomePlacementRndSpread(int spacing, int separation, RandomSpreadType spreadType, int salt, Vec3i locateOffset, String uniqueIdentifier, boolean useValueFromConfiguration, Optional<SuperExclusionZone> superExclusionZone) {
        this(locateOffset, StructurePlacement.FrequencyReductionMethod.DEFAULT, 1.0f, salt, Optional.empty(), spacing, separation, spreadType, uniqueIdentifier, useValueFromConfiguration, superExclusionZone);
    }

    public AwesomePlacementRndSpread(Vec3i locateOffset, StructurePlacement.FrequencyReductionMethod frequencyReductionMethod, float frequency, int salt, Optional<StructurePlacement.ExclusionZone> exclusionZone, int spacing, int separation, RandomSpreadType spreadType, String uniqueIdentifier, boolean useValueFromConfiguration, Optional<SuperExclusionZone> superExclusionZone) {
        super(locateOffset, frequencyReductionMethod, frequency, salt, exclusionZone, spacing, separation, spreadType);
        this.useValueFromConfiguration = useValueFromConfiguration;
        this.uniqueIdentifier = uniqueIdentifier;
        this.spacing = this.useValueFromConfiguration ? this.bindSpacingFromConfiguration() : spacing;
        this.separation = this.useValueFromConfiguration ? this.bindSeparationFromConfiguration() : separation;
        this.salt = this.useValueFromConfiguration ? this.bindSaltFromConfiguration() : salt;
        this.spreadType = spreadType;
        this.locateOffset = locateOffset;
        this.superExclusionZone = superExclusionZone;
        LibraryFerret.LOGGER.info(this.toString());
    }

    public ChunkPos getStartChunk(long seed, int x, int z) {
        int i = this.spacing();
        int j = this.separation();
        int k = Math.floorDiv(x, i);
        int l = Math.floorDiv(z, i);
        WorldgenRandom chunkRandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        chunkRandom.setLargeFeatureWithSalt(seed, k, l, this.salt());
        int m = i - j;
        int n = this.spreadType().evaluate((RandomSource)chunkRandom, m);
        int o = this.spreadType().evaluate((RandomSource)chunkRandom, m);
        return new ChunkPos(k * i + n, l * i + o);
    }

    protected boolean isPlacementChunk(ChunkGeneratorStructureState chunkGeneratorStructureState, int chunkX, int chunkZ) {
        ChunkPos chunkpos = this.getPotentialStructureChunk(chunkGeneratorStructureState.getLevelSeed(), chunkX, chunkZ);
        return chunkpos.x == chunkX && chunkpos.z == chunkZ;
    }

    public boolean isStructureChunk(@NotNull ChunkGeneratorStructureState chunkGeneratorStructureState, int chunkX, int chunkZ) {
        if (!super.isStructureChunk(chunkGeneratorStructureState, chunkX, chunkZ)) {
            return false;
        }
        return this.superExclusionZone.isEmpty() || !this.superExclusionZone.get().isPlacementForbidden(chunkGeneratorStructureState, chunkX, chunkZ);
    }

    public String toString() {
        return "Structure placement for `" + this.uniqueIdentifier + "`: { spacing: " + this.spacing + ", separation: " + this.separation + ", salt: " + this.salt + ", useValueFromConfiguration: " + this.useValueFromConfiguration + "}";
    }

    public abstract int bindSpacingFromConfiguration();

    public abstract int bindSeparationFromConfiguration();

    public abstract int bindSaltFromConfiguration();

    public int spacing() {
        return this.spacing;
    }

    public int separation() {
        return this.separation;
    }

    public int salt() {
        return this.salt;
    }

    @NotNull
    public RandomSpreadType spreadType() {
        return this.spreadType;
    }

    @NotNull
    public Vec3i locateOffset() {
        return this.locateOffset;
    }

    private String uniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    public boolean useValueFromConfiguration() {
        return this.useValueFromConfiguration;
    }

    public Optional<SuperExclusionZone> superExclusionZone() {
        return this.superExclusionZone;
    }

    public record SuperExclusionZone(HolderSet<StructureSet> otherSet, int chunkCount) {
        public static final Codec<SuperExclusionZone> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.STRUCTURE_SET, (Codec)StructureSet.DIRECT_CODEC).fieldOf("other_set").forGetter(SuperExclusionZone::otherSet), (App)Codec.intRange((int)1, (int)16).fieldOf("chunk_count").forGetter(SuperExclusionZone::chunkCount)).apply((Applicative)builder, SuperExclusionZone::new));

        public boolean isPlacementForbidden(ChunkGeneratorStructureState chunkGeneratorStructureState, int chunkX, int chunkZ) {
            for (Holder holder : this.otherSet) {
                if (!chunkGeneratorStructureState.hasStructureChunkInRange(holder, chunkX, chunkZ, this.chunkCount)) continue;
                return true;
            }
            return false;
        }
    }
}

