/*
 * Decompiled with CFR 0.152.
 */
package net.redstonegames.chefsdelight.worldgen.village;

import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.redstonegames.chefsdelight.Config;

public class VillageStructures {
    public static void addNewVillageBuilding(ServerAboutToStartEvent event) {
        Registry templatePools = (Registry)event.getServer().registryAccess().registry(Registries.TEMPLATE_POOL).get();
        Registry processorLists = (Registry)event.getServer().registryAccess().registry(Registries.PROCESSOR_LIST).get();
        VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"minecraft:village/plains/houses"), "chefsdelight:plains_cook_house", Config.cookHousePlains);
        VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"minecraft:village/plains/houses"), "chefsdelight:plains_chef_house", Config.cookHousePlains);
        VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"minecraft:village/desert/houses"), "chefsdelight:desert_cook_house", Config.cookHouseDesert);
        VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"minecraft:village/desert/houses"), "chefsdelight:desert_chef_house", Config.chefHouseDesert);
        VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"minecraft:village/taiga/houses"), "chefsdelight:taiga_cook_house", Config.cookHouseTaiga);
        VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"minecraft:village/taiga/houses"), "chefsdelight:taiga_chef_house", Config.chefHouseTaiga);
        VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"minecraft:village/savanna/houses"), "chefsdelight:savanna_cook_house", Config.cookHouseSavanna);
        VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"minecraft:village/savanna/houses"), "chefsdelight:savanna_chef_house", Config.chefHouseSavanna);
        VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"minecraft:village/snowy/houses"), "chefsdelight:snowy_cook_house", Config.cookHouseSnowy);
        VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"minecraft:village/snowy/houses"), "chefsdelight:snowy_chef_house", Config.chefHouseSnowy);
    }

    public static void addBuildingToPool(Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorListRegistry, ResourceLocation poolRL, String nbtPieceRL, int weight) {
        StructureTemplatePool pool = (StructureTemplatePool)templatePoolRegistry.get(poolRL);
        if (pool == null) {
            return;
        }
        ResourceLocation emptyProcessor = ResourceLocation.withDefaultNamespace((String)"empty");
        Holder.Reference processorHolder = processorListRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (ResourceLocation)emptyProcessor));
        SinglePoolElement piece = (SinglePoolElement)SinglePoolElement.single((String)nbtPieceRL, (Holder)processorHolder).apply(StructureTemplatePool.Projection.RIGID);
        for (int i = 0; i < weight; ++i) {
            pool.templates.add((Object)piece);
        }
    }
}

