/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.pillagerdeterrent.datagen;

import dev.willyelton.pillagerdeterrent.Registration;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.loot.packs.VanillaBlockLoot;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class PillagerDeterrentBlockLootTables
extends VanillaBlockLoot {
    public PillagerDeterrentBlockLootTables(HolderLookup.Provider registries) {
        super(registries);
    }

    protected void generate() {
        this.createComponentSavingTable((Block)Registration.PILLAGER_WARDING_BANNER.get(), (ItemLike)Registration.PILLAGER_WARDING_BANNER_BLOCK_ITEM.get(), DataComponents.BANNER_PATTERNS, DataComponents.TOOLTIP_DISPLAY);
        this.createComponentSavingTable((Block)Registration.PILLAGER_WARDING_WALL_BANNER.get(), (ItemLike)Registration.PILLAGER_WARDING_BANNER_BLOCK_ITEM.get(), DataComponents.BANNER_PATTERNS, DataComponents.TOOLTIP_DISPLAY);
    }

    protected Iterable<Block> getKnownBlocks() {
        return BuiltInRegistries.BLOCK.entrySet().stream().filter(e -> ((ResourceKey)e.getKey()).location().getNamespace().equals("pillager_deterrent")).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    private void createComponentSavingTable(Block block, ItemLike item, DataComponentType<?> ... dataComponents) {
        LootPoolSingletonContainer.Builder lti = LootItem.lootTableItem((ItemLike)item);
        lti.apply((LootItemFunction.Builder)CopyNameFunction.copyName((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY));
        CopyComponentsFunction.Builder copyComponentsFunctionBuilder = CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY);
        for (DataComponentType<?> dataComponent : dataComponents) {
            copyComponentsFunctionBuilder.include(dataComponent);
        }
        lti.apply((LootItemFunction.Builder)copyComponentsFunctionBuilder);
        LootPool.Builder builder = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)lti);
        this.add(block, LootTable.lootTable().withPool(builder));
    }
}

