/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.pillagerdeterrent.datagen;

import dev.willyelton.pillagerdeterrent.datagen.PillagerDeterrentBlockLootTables;
import dev.willyelton.pillagerdeterrent.datagen.PillagerDeterrentBlockTags;
import dev.willyelton.pillagerdeterrent.datagen.PillagerDeterrentChestLootTables;
import dev.willyelton.pillagerdeterrent.datagen.PillagerDeterrentGlobalLootModifiers;
import dev.willyelton.pillagerdeterrent.datagen.PillagerDeterrentItemTags;
import dev.willyelton.pillagerdeterrent.datagen.PillagerDeterrentModels;
import dev.willyelton.pillagerdeterrent.datagen.PillagerDeterrentRecipes;
import java.util.Collections;
import java.util.List;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="pillager_deterrent")
public class DataGeneration {
    @SubscribeEvent
    public static void dataGen(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        generator.addProvider(true, (DataProvider)new PillagerDeterrentModels(packOutput));
        event.createProvider(PillagerDeterrentRecipes.Runner::new);
        generator.addProvider(true, (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(PillagerDeterrentBlockLootTables::new, LootContextParamSets.BLOCK), new LootTableProvider.SubProviderEntry(PillagerDeterrentChestLootTables::new, LootContextParamSets.CHEST)), event.getLookupProvider()));
        PillagerDeterrentBlockTags blockTags = new PillagerDeterrentBlockTags(packOutput, event.getLookupProvider());
        generator.addProvider(true, (DataProvider)blockTags);
        generator.addProvider(true, (DataProvider)new PillagerDeterrentItemTags(packOutput, event.getLookupProvider(), blockTags.contentsGetter()));
        generator.addProvider(true, (DataProvider)new PillagerDeterrentGlobalLootModifiers(packOutput, event.getLookupProvider()));
    }
}

