/*
 * Decompiled with CFR 0.152.
 */
package net.gobies.moreartifacts.client.overlay;

import net.gobies.moreartifacts.config.ClientConfig;
import net.gobies.moreartifacts.config.CommonConfig;
import net.gobies.moreartifacts.event.ClientEvents;
import net.gobies.moreartifacts.init.MAItems;
import net.gobies.moreartifacts.util.CurioHandler;
import net.gobies.moreartifacts.util.MAUtils;
import net.gobies.moreartifacts.util.Teleport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EnderianEyeOverlay {
    private static final ResourceLocation TELEPORT_BAR_LOCATION = new ResourceLocation("moreartifacts:textures/gui/teleport_bar.png");
    private static final ResourceLocation FILL_BAR_LOCATION = new ResourceLocation("moreartifacts:textures/gui/fill_bar.png");

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onRenderGameOverlay(RenderGuiEvent.Post event) {
        Player player;
        Minecraft mc = Minecraft.m_91087_();
        LivingEntity entity = (LivingEntity)mc.m_91288_();
        if (((Boolean)ClientConfig.ENDERIAN_EYE_OVERLAY.get()).booleanValue() && entity instanceof Player && Teleport.hasTeleported(player = (Player)entity) && CurioHandler.isCurioEquipped((LivingEntity)player, (Item)MAItems.EnderianEye.get())) {
            double cooldown = (Double)CommonConfig.ENDERIAN_EYE_COOLDOWN.get();
            GuiGraphics guiGraphics = event.getGuiGraphics();
            double cooldownTimer = MAUtils.getCooldownTimer(player, cooldown);
            if (MAUtils.isReadyForTeleport(player, cooldown)) {
                if (ClientEvents.EYE_TELEPORT_KEY.m_90859_()) {
                    MAUtils.updateCooldown(player);
                }
            } else if (cooldownTimer < cooldown && mc.f_91066_.m_92176_().m_90612_()) {
                int width = event.getWindow().m_85445_();
                int height = event.getWindow().m_85446_();
                int barWidth = (int)(cooldownTimer / cooldown * 14.0);
                int barHeight = 4;
                int x = (int)((double)width * 0.5 - 7.8);
                int y = (int)((double)height * 0.5) + 5;
                guiGraphics.m_280163_(TELEPORT_BAR_LOCATION, x, y, 0.0f, 8.0f, 15, barHeight, 15, 3);
                int middleBarHeight = 1;
                int middleBarStartY = y + (barHeight - middleBarHeight) / 2;
                guiGraphics.m_280163_(FILL_BAR_LOCATION, x + 14 - barWidth, middleBarStartY, 0.0f, 0.0f, barWidth, middleBarHeight, 15, 1);
            }
        }
    }
}

