/*
 * Decompiled with CFR 0.152.
 */
package net.gobies.moreartifacts.event;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.gobies.moreartifacts.compat.spartanweaponry.SpartanWeaponryCompat;
import net.gobies.moreartifacts.config.CommonConfig;
import net.gobies.moreartifacts.init.MAEffects;
import net.gobies.moreartifacts.init.MAItems;
import net.gobies.moreartifacts.util.CurioHandler;
import net.gobies.moreartifacts.util.DamageCalculator;
import net.gobies.moreartifacts.util.MAUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class DamageEvents {
    private static final Map<Player, Double> generalDamageReductionMap = new HashMap<Player, Double>();
    private static final Map<Player, Double> fireDamageReductionMap = new HashMap<Player, Double>();
    private static final Map<Player, Double> generalDamageIncreaseMap = new HashMap<Player, Double>();
    private static final Map<Player, Map<Item, Boolean>> equippedArtifactsMap = new HashMap<Player, Map<Item, Boolean>>();
    private static final Map<Player, Long> lastHealTimeMap = new HashMap<Player, Long>();
    private static final Map<UUID, Integer> BLEEDING_ENTITIES = new HashMap<UUID, Integer>();

    public static double getTotalDamageReduction(Player player) {
        return generalDamageReductionMap.getOrDefault(player, 0.0);
    }

    public static double getFireDamageReduction(Player player) {
        return fireDamageReductionMap.getOrDefault(player, 0.0);
    }

    public static double getTotalDamageIncrease(Player player) {
        return generalDamageIncreaseMap.getOrDefault(player, 0.0);
    }

    public static void updateDamageReduction(Player player) {
        double totalReduction = DamageCalculator.calculateTotalDamageReduction(player);
        double fireReduction = DamageCalculator.calculateFireDamageReduction(player);
        generalDamageReductionMap.put(player, totalReduction);
        fireDamageReductionMap.put(player, fireReduction);
    }

    public static void updateDamageIncrease(Player player) {
        double generalIncrease = DamageCalculator.calculateDamageIncrease(player);
        generalDamageIncreaseMap.put(player, generalIncrease);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onLivingHurt(LivingHurtEvent event) {
        Entity generalReduction2;
        Player player;
        DamageSource source = event.getSource();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Entity entity;
            player = (Player)livingEntity;
            double generalReduction2 = DamageEvents.getTotalDamageReduction(player);
            double fireReduction = DamageEvents.getFireDamageReduction(player);
            double finalReduction = event.getAmount();
            if (MAUtils.isFire(event)) {
                double combinedFireReduction = generalReduction2 + fireReduction;
                finalReduction = combinedFireReduction >= 1.0 ? 0.0 : finalReduction * (1.0 - combinedFireReduction);
                MAUtils.logDebug("Fire Damage Reduction for " + player.m_7755_().getString() + ": " + String.format("%.2f", fireReduction * 100.0) + "%");
            } else {
                finalReduction *= 1.0 - generalReduction2;
            }
            if (CurioHandler.isCurioEquipped((LivingEntity)player, (Item)MAItems.TaintedMirror.get()) && source.m_7639_() != null && (entity = source.m_7639_()) instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)entity;
                float damageToReflect = event.getAmount();
                if (attacker instanceof Player) {
                    damageToReflect *= (Boolean)CommonConfig.TAINTED_MIRROR_PLAYER_DAMAGE.get() != false ? 1.0f : 0.5f;
                }
                attacker.m_6469_(event.getSource(), damageToReflect);
                player.f_19802_ += 12;
            }
            event.setAmount((float)finalReduction);
            MAUtils.logDebug("Total Damage Reduction for " + player.m_7755_().getString() + ": " + String.format("%.2f", generalReduction2 * 100.0) + "%");
        }
        if ((generalReduction2 = event.getSource().m_7639_()) instanceof Player) {
            player = (Player)generalReduction2;
            LivingEntity target = event.getEntity();
            RandomSource random = player.m_217043_();
            double generalIncrease = 0.0;
            if (CurioHandler.isCurioEquipped((LivingEntity)player, (Item)MAItems.GildedScarf.get())) {
                generalIncrease += DamageCalculator.getDamageIncrease(player, (Item)MAItems.GildedScarf.get(), (Double)CommonConfig.GILDED_DAMAGE_DEALT.get());
            }
            int dragonClawCount = CurioHandler.getCurioCount((LivingEntity)player, (Item)MAItems.EnderDragonClaw.get());
            if ((double)player.m_217043_().m_188501_() < (Double)CommonConfig.ENDER_DRAGON_CLAW_CHANCE.get()) {
                for (int i = 0; i < dragonClawCount; ++i) {
                    float randomPitch = 1.3f + random.m_188501_() * 0.2f;
                    player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_11895_, SoundSource.PLAYERS, 0.6f, randomPitch);
                    generalIncrease += DamageCalculator.getDamageIncrease(player, (Item)MAItems.EnderDragonClaw.get(), (Double)CommonConfig.ENDER_DRAGON_CLAW_DAMAGE.get());
                }
            }
            int luckyRingCount = CurioHandler.getCurioCount((LivingEntity)player, (Item)MAItems.LuckyEmeraldRing.get());
            for (int i = 0; i < luckyRingCount; ++i) {
                if (target.m_6336_() != MobType.f_21643_) continue;
                generalIncrease += DamageCalculator.getDamageIncrease(player, (Item)MAItems.LuckyEmeraldRing.get(), (Double)CommonConfig.EMERALD_RING_DAMAGE.get());
            }
            int venomStoneCount = CurioHandler.getCurioCount((LivingEntity)player, (Item)MAItems.VenomStone.get());
            for (int i = 0; i < venomStoneCount; ++i) {
                if (target.m_21023_(MobEffects.f_19614_) || target.m_21023_((MobEffect)MAEffects.Virulent.get())) {
                    generalIncrease += DamageCalculator.getDamageIncrease(player, (Item)MAItems.VenomStone.get(), (Double)CommonConfig.VENOM_STONE_DAMAGE.get());
                    MobEffectInstance poisonEffect = target.m_21124_(MobEffects.f_19614_);
                    if (poisonEffect == null) continue;
                    int poisonDuration = poisonEffect.m_19557_();
                    int poisonAmplifier = poisonEffect.m_19564_();
                    double deadlyChance = (Double)CommonConfig.VENOM_STONE_DEADLY_CHANCE.get() * (double)venomStoneCount;
                    if (!((double)random.m_188501_() < deadlyChance)) continue;
                    target.m_21195_(MobEffects.f_19614_);
                    target.m_7292_(new MobEffectInstance((MobEffect)MAEffects.Virulent.get(), poisonDuration, poisonAmplifier));
                    continue;
                }
                if (target.m_21023_((MobEffect)MAEffects.Virulent.get())) continue;
                double poisonChance = (Double)CommonConfig.VENOM_STONE_CHANCE.get() * (double)venomStoneCount;
                if (!((double)random.m_188501_() < poisonChance)) continue;
                target.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 20 * (Integer)CommonConfig.VENOM_STONE_DURATION.get(), (Integer)CommonConfig.VENOM_STONE_LEVEL.get() - 1));
            }
            int decayStoneCount = CurioHandler.getCurioCount((LivingEntity)player, (Item)MAItems.DecayStone.get());
            for (int i = 0; i < decayStoneCount; ++i) {
                if (target.m_21023_(MobEffects.f_19615_)) {
                    generalIncrease += DamageCalculator.getDamageIncrease(player, (Item)MAItems.DecayStone.get(), (Double)CommonConfig.DECAY_STONE_DAMAGE.get());
                    long currentTime = player.m_9236_().m_46467_();
                    Long lastHealTime = lastHealTimeMap.get(player);
                    if (lastHealTime == null || currentTime - lastHealTime > 20L) {
                        int healAmount = (Integer)CommonConfig.DECAY_STONE_HEAL_AMOUNT.get() * decayStoneCount;
                        player.m_5634_((float)(2 * healAmount));
                        lastHealTimeMap.put(player, currentTime);
                    }
                }
                double decayChance = (Double)CommonConfig.DECAY_STONE_CHANCE.get() * (double)decayStoneCount;
                if (!((double)random.m_188501_() < decayChance)) continue;
                target.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 20 * (Integer)CommonConfig.DECAY_STONE_DURATION.get(), (Integer)CommonConfig.DECAY_STONE_LEVEL.get() - 1));
            }
            int fireStoneCount = CurioHandler.getCurioCount((LivingEntity)player, (Item)MAItems.FireStone.get());
            for (int i = 0; i < fireStoneCount; ++i) {
                if (target.m_6060_()) {
                    generalIncrease += DamageCalculator.getDamageIncrease(player, (Item)MAItems.FireStone.get(), (Double)CommonConfig.FIRE_STONE_DAMAGE.get());
                }
                double fireChance = (Double)CommonConfig.FIRE_STONE_CHANCE.get() * (double)fireStoneCount;
                if (!((double)random.m_188501_() < fireChance)) continue;
                target.m_20254_(((Integer)CommonConfig.FIRE_STONE_DURATION.get()).intValue());
            }
            int iceStoneCount = CurioHandler.getCurioCount((LivingEntity)player, (Item)MAItems.IceStone.get());
            for (int i = 0; i < iceStoneCount; ++i) {
                if (target.m_21023_(MobEffects.f_19597_) || target.m_203117_()) {
                    generalIncrease += DamageCalculator.getDamageIncrease(player, (Item)MAItems.IceStone.get(), (Double)CommonConfig.ICE_STONE_DAMAGE.get());
                }
                double iceChance = (Double)CommonConfig.ICE_STONE_CHANCE.get() * (double)iceStoneCount;
                if (!((double)random.m_188501_() < iceChance)) continue;
                target.m_146917_(100 * (Integer)CommonConfig.ICE_STONE_DURATION.get());
                target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20 * (Integer)CommonConfig.ICE_STONE_DURATION.get(), 0));
            }
            if (event.getSource().m_276093_(DamageTypes.f_268739_) || SpartanWeaponryCompat.isArmorPiercingBolt(event.getSource())) {
                int magicQuiverCount = CurioHandler.getCurioCount((LivingEntity)player, (Item)MAItems.MagicQuiver.get());
                for (int i = 0; i < magicQuiverCount; ++i) {
                    generalIncrease += DamageCalculator.getDamageIncrease(player, (Item)MAItems.MagicQuiver.get(), (Double)CommonConfig.MAGIC_QUIVER_DAMAGE.get());
                }
                int envenomedQuiverCount = CurioHandler.getCurioCount((LivingEntity)player, (Item)MAItems.EnvenomedQuiver.get());
                for (int i = 0; i < envenomedQuiverCount; ++i) {
                    generalIncrease += DamageCalculator.getDamageIncrease(player, (Item)MAItems.EnvenomedQuiver.get(), (Double)CommonConfig.ENVENOMED_QUIVER_DAMAGE.get());
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 20 * (Integer)CommonConfig.ENVENOMED_QUIVER_POISON_DURATION.get(), ((Integer)CommonConfig.ENVENOMED_QUIVER_POISON_LEVEL.get()).intValue()));
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 20 * (Integer)CommonConfig.ENVENOMED_QUIVER_WITHER_DURATION.get(), ((Integer)CommonConfig.ENVENOMED_QUIVER_WITHER_LEVEL.get()).intValue()));
                }
                int moltenQuiverCount = CurioHandler.getCurioCount((LivingEntity)player, (Item)MAItems.MoltenQuiver.get());
                for (int i = 0; i < moltenQuiverCount; ++i) {
                    generalIncrease += DamageCalculator.getDamageIncrease(player, (Item)MAItems.MoltenQuiver.get(), (Double)CommonConfig.MOLTEN_QUIVER_DAMAGE.get());
                    target.m_20254_(((Integer)CommonConfig.MOLTEN_QUIVER_DURATION.get()).intValue());
                    if (!target.m_6060_()) continue;
                    generalIncrease += DamageCalculator.getDamageIncrease(player, (Item)MAItems.MoltenQuiver.get(), (Double)CommonConfig.MOLTEN_QUIVER_ONFIRE_DAMAGE.get());
                }
                if (CurioHandler.isCurioEquipped((LivingEntity)player, (Item)MAItems.WoodenHeadgear.get())) {
                    event.setAmount((float)((double)event.getAmount() * (Double)CommonConfig.WOODEN_HEADGEAR_ARROW_DAMAGE_TAKEN.get()));
                }
                if (CurioHandler.isCurioEquipped((LivingEntity)player, (Item)MAItems.GoldenHeadgear.get())) {
                    event.setAmount((float)((double)event.getAmount() * (Double)CommonConfig.GOLDEN_HEADGEAR_ARROW_DAMAGE_TAKEN.get()));
                }
                if (CurioHandler.isCurioEquipped((LivingEntity)player, (Item)MAItems.NetheriteHeadgear.get())) {
                    event.setAmount((float)((double)event.getAmount() * (Double)CommonConfig.NETHERITE_HEADGEAR_ARROW_DAMAGE_TAKEN.get()));
                }
            }
            if (CurioHandler.isCurioEquipped((LivingEntity)player, (Item)MAItems.VanirMask.get())) {
                event.setAmount((float)((double)event.getAmount() + (Double)CommonConfig.VANIR_MASK_DAMAGE_INCREASE.get()));
            }
            int rubyRingCount = CurioHandler.getCurioCount((LivingEntity)player, (Item)MAItems.RubyRing.get());
            for (int i = 0; i < rubyRingCount; ++i) {
                float maxHealth = player.m_21233_();
                float additionalDamagePercentage = 1.0f;
                double configDamageIncrease = (Double)CommonConfig.RUBY_RING_DAMAGE_INCREASE.get();
                double healthThreshold = (Double)CommonConfig.RUBY_RING_HEALTH_THRESHOLD.get();
                double healthThresholdCap = (Double)CommonConfig.RUBY_RING_HEALTH_CAP.get();
                int maxAllowedThresholds = (int)(healthThresholdCap / healthThreshold);
                int thresholdCount = (int)((double)maxHealth / healthThreshold);
                thresholdCount = Math.min(thresholdCount, maxAllowedThresholds);
                for (int h = 0; h < thresholdCount; ++h) {
                    additionalDamagePercentage += (float)configDamageIncrease;
                }
                generalIncrease += DamageCalculator.getDamageIncrease(player, (Item)MAItems.RubyRing.get(), additionalDamagePercentage);
            }
            generalIncrease = Math.min(generalIncrease, (Double)CommonConfig.MAX_DAMAGE_INCREASE.get());
            event.setAmount((float)((double)event.getAmount() * (1.0 + generalIncrease)));
            MAUtils.logDebug("Total Damage Increase for " + player.m_7755_().getString() + ": " + String.format("%.2f", generalIncrease * 100.0) + "%");
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent event) {
        Map equippedArtifacts;
        Map<Item, Boolean> currentEquippedState;
        Player player = event.player;
        if (player != null && !(currentEquippedState = DamageCalculator.getCurrentEquipState(player)).equals(equippedArtifacts = (Map)equippedArtifactsMap.getOrDefault(player, new HashMap()))) {
            DamageEvents.updateDamageReduction(player);
            DamageEvents.updateDamageIncrease(player);
            equippedArtifactsMap.put(player, currentEquippedState);
            MAUtils.logDebug("Artifacts equipped for " + player.m_7755_().getString() + ": " + currentEquippedState);
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        LivingEntity target = event.getEntity();
        Entity entity = event.getSource().m_7640_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!event.getSource().m_276093_(DamageTypes.f_268464_)) {
            return;
        }
        if (target instanceof AbstractSkeleton || target instanceof AbstractGolem || target instanceof Slime) {
            return;
        }
        ResourceLocation entityName = ForgeRegistries.ENTITY_TYPES.getKey((Object)target.m_6095_());
        if (entityName != null && ((List)CommonConfig.BLEED_BLACKLISTED_ENTITIES.get()).contains(entityName.toString())) {
            return;
        }
        int clawCount = CurioHandler.getCurioCount((LivingEntity)player, (Item)MAItems.MechanicalClaw.get());
        for (int i = 0; i < clawCount; ++i) {
            int bleedDuration = (Integer)CommonConfig.MECHANICAL_CLAW_BLEED_DURATION.get() * 20 * clawCount;
            double bleedChance = (Double)CommonConfig.MECHANICAL_CLAW_BLEED_CHANCE.get() * (double)clawCount;
            UUID targetId = target.m_20148_();
            if (!((double)target.m_217043_().m_188501_() < bleedChance)) continue;
            BLEEDING_ENTITIES.put(targetId, bleedDuration);
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_9236_().f_46443_) {
            return;
        }
        UUID entityId = entity.m_20148_();
        if (BLEEDING_ENTITIES.containsKey(entityId)) {
            int remainingTicks = BLEEDING_ENTITIES.get(entityId);
            if (remainingTicks <= 0) {
                BLEEDING_ENTITIES.remove(entityId);
                return;
            }
            if (remainingTicks % 20 == 0) {
                DamageSource bleedDamage = new DamageSource((Holder)entity.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268515_));
                int prevInvulnerableTime = entity.f_19802_;
                entity.m_6469_(bleedDamage, (float)((Integer)CommonConfig.MECHANICAL_CLAW_BLEED_DAMAGE.get()).intValue());
                entity.f_19802_ = prevInvulnerableTime;
            }
            BLEEDING_ENTITIES.put(entityId, remainingTicks - 1);
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        LivingEntity target = event.getEntity();
        Entity source = event.getSource().m_7639_();
        if (source instanceof Player) {
            Player attacker = (Player)source;
            if (target.m_6060_() && CurioHandler.isCurioEquipped((LivingEntity)attacker, (Item)MAItems.FireStone.get())) {
                Level world = target.m_9236_();
                BlockPos targetPos = target.m_20183_();
                int radiusXZ = 7;
                int radiusY = 4;
                AABB area = new AABB(targetPos.m_7918_(-radiusXZ, -radiusY, -radiusXZ), targetPos.m_7918_(radiusXZ + 1, radiusY + 1, radiusXZ + 1));
                List nearbyEntities = world.m_45976_(LivingEntity.class, area);
                for (LivingEntity entity : nearbyEntities) {
                    if (entity instanceof TamableAnimal && ((TamableAnimal)entity).m_21824_() || entity == attacker || !attacker.m_142582_((Entity)entity)) continue;
                    entity.m_20254_(2 * (Integer)CommonConfig.FIRE_STONE_DURATION.get());
                }
            }
        }
    }
}

