/*
 * Decompiled with CFR 0.152.
 */
package net.gobies.moreartifacts.item.artifacts;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.gobies.moreartifacts.config.CommonConfig;
import net.gobies.moreartifacts.util.MAUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class AnkhCharmItem
extends Item
implements ICurioItem {
    public AnkhCharmItem(Item.Properties properties) {
        super(properties.m_41487_(1).m_41497_(Rarity.EPIC));
    }

    public static void additionalEffectImmunity(MobEffectEvent.Applicable event) {
        MobEffectInstance effects = event.getEffectInstance();
        ArrayList<MobEffectInstance> effectsToUpdate = new ArrayList<MobEffectInstance>(List.of(effects));
        for (MobEffectInstance effectInstance : effectsToUpdate) {
            MobEffect effect = effectInstance.m_19544_();
            ResourceLocation effectId = ForgeRegistries.MOB_EFFECTS.getKey((Object)effect);
            if (effectId == null || !((List)CommonConfig.ANKH_CHARM_ADDITIONAL_EFFECTS.get()).contains(effectId.toString())) continue;
            event.setResult(Event.Result.DENY);
        }
    }

    public static void removeAdditionalEffects(Player player) {
        for (MobEffect effect : ForgeRegistries.MOB_EFFECTS) {
            ResourceLocation effectId = ForgeRegistries.MOB_EFFECTS.getKey((Object)effect);
            if (effectId == null || !((List)CommonConfig.ANKH_CHARM_ADDITIONAL_EFFECTS.get()).contains(effectId.toString()) || !player.m_21023_(effect)) continue;
            player.m_21195_(effect);
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            MAUtils.removeHarmfulEffects(player);
            AnkhCharmItem.removeAdditionalEffects(player);
        }
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.moreartifacts.ankh_charm").m_130940_(ChatFormatting.GOLD));
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }
}

