/*
 * Decompiled with CFR 0.152.
 */
package net.gobies.moreartifacts.item.artifacts;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.gobies.moreartifacts.config.CommonConfig;
import net.gobies.moreartifacts.init.MAItems;
import net.gobies.moreartifacts.util.CurioHandler;
import net.gobies.moreartifacts.util.MAUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class AnkhShieldItem
extends ShieldItem
implements ICurioItem {
    private static final UUID KNOCKBACK_RESISTANCE = UUID.randomUUID();

    public AnkhShieldItem(Item.Properties properties) {
        super(properties.m_41487_(1).m_41497_(Rarity.EPIC).m_41486_().m_41503_(1500));
    }

    public static void additionalEffectImmunity(MobEffectEvent.Applicable event) {
        MobEffectInstance effects = event.getEffectInstance();
        ArrayList<MobEffectInstance> effectsToUpdate = new ArrayList<MobEffectInstance>(List.of(effects));
        for (MobEffectInstance effectInstance : effectsToUpdate) {
            MobEffect effect = effectInstance.m_19544_();
            ResourceLocation effectId = ForgeRegistries.MOB_EFFECTS.getKey((Object)effect);
            if (effectId == null || !((List)CommonConfig.ANKH_SHIELD_ADDITIONAL_EFFECTS.get()).contains(effectId.toString())) continue;
            event.setResult(Event.Result.DENY);
        }
    }

    public static void removeAdditionalEffects(Player player) {
        for (MobEffect effect : ForgeRegistries.MOB_EFFECTS) {
            ResourceLocation effectId = ForgeRegistries.MOB_EFFECTS.getKey((Object)effect);
            if (effectId == null || !((List)CommonConfig.ANKH_SHIELD_ADDITIONAL_EFFECTS.get()).contains(effectId.toString()) || !player.m_21023_(effect)) continue;
            player.m_21195_(effect);
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player && CurioHandler.isCurioEquipped((LivingEntity)(player = (Player)livingEntity), (Item)MAItems.AnkhShield.get())) {
            MAUtils.removeHarmfulEffects(player);
            AnkhShieldItem.removeAdditionalEffects(player);
        }
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            MAUtils.addAttributes(player, Attributes.f_22278_, 1.0, AttributeModifier.Operation.ADDITION, String.valueOf(KNOCKBACK_RESISTANCE));
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            MAUtils.removeAttributes(player, Attributes.f_22278_, String.valueOf(KNOCKBACK_RESISTANCE));
        }
    }

    public boolean m_6832_(ItemStack toRepair, @NotNull ItemStack repair) {
        return toRepair.m_41720_() == this && repair.m_41720_() == Items.f_41999_;
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        double fireDamageReduction = (1.0 - (Double)CommonConfig.ANKH_SHIELD_FIRE_DAMAGE_TAKEN.get()) * 100.0;
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.moreartifacts.ankh_shield.immunity").m_130940_(ChatFormatting.GOLD));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.moreartifacts.ankh_shield.immunity_debuff").m_130940_(ChatFormatting.GOLD));
        pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.moreartifacts.ankh_shield.fire_damage", (Object[])new Object[]{String.format("%.1f", fireDamageReduction)}).m_130940_(ChatFormatting.DARK_AQUA));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.moreartifacts.hold.ctrl").m_130940_(ChatFormatting.GRAY));
        if (Screen.m_96637_()) {
            pTooltipComponents.remove(4);
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.moreartifacts.normal.shield").m_130940_(ChatFormatting.GRAY));
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.moreartifacts.shield.obsidian").m_130940_(ChatFormatting.GRAY));
            super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        }
    }
}

