/*
 * Decompiled with CFR 0.152.
 */
package net.gobies.moreartifacts.item.artifacts;

import java.util.List;
import java.util.UUID;
import net.gobies.moreartifacts.config.CommonConfig;
import net.gobies.moreartifacts.util.MAUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class BlazingTreadsItem
extends Item
implements ICurioItem {
    private static final UUID SPEED = UUID.randomUUID();

    public BlazingTreadsItem(Item.Properties properties) {
        super(properties.m_41487_(1).m_41497_(Rarity.RARE).m_41486_());
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            MAUtils.addAttributes(player, Attributes.f_22279_, (Double)CommonConfig.BLAZING_TREADS_SPEED.get(), AttributeModifier.Operation.MULTIPLY_BASE, String.valueOf(SPEED));
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            MAUtils.removeAttributes(player, Attributes.f_22279_, String.valueOf(SPEED));
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_20142_() && player.m_9236_().f_46443_) {
            this.spawnFireParticles(player);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnFireParticles(Player player) {
        Level level = player.m_9236_();
        double offsetX = (Math.random() - 0.5) * 0.3;
        double offsetZ = (Math.random() - 0.5) * 0.3;
        double feetX = player.m_20185_() + offsetX;
        double feetY = player.m_20186_() - 0.1;
        double feetZ = player.m_20189_() + offsetZ;
        level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, feetX, feetY, feetZ, 0.0, 0.05, 0.0);
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        double movementSpeed = (Double)CommonConfig.BLAZING_TREADS_SPEED.get() * 100.0;
        pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.moreartifacts.blazing_treads.speed", (Object[])new Object[]{String.format("%.1f", movementSpeed)}).m_130940_(ChatFormatting.DARK_AQUA));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.moreartifacts.hot_block_immune").m_130940_(ChatFormatting.GOLD));
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }
}

