/*
 * Decompiled with CFR 0.152.
 */
package net.gobies.moreartifacts.item.artifacts;

import java.util.List;
import java.util.UUID;
import net.gobies.moreartifacts.config.CommonConfig;
import net.gobies.moreartifacts.util.MAUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class DuneTreadsItem
extends Item
implements ICurioItem {
    private static final UUID SPEED = UUID.randomUUID();
    private static final UUID SAND_SPEED_BONUS = UUID.randomUUID();

    public DuneTreadsItem(Item.Properties properties) {
        super(properties.m_41487_(1).m_41497_(Rarity.UNCOMMON));
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            MAUtils.addAttributes(player, Attributes.f_22279_, (Double)CommonConfig.DUNE_TREADS_SPEED.get(), AttributeModifier.Operation.MULTIPLY_BASE, String.valueOf(SPEED));
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            MAUtils.removeAttributes(player, Attributes.f_22279_, String.valueOf(SPEED));
            MAUtils.removeAttributes(player, Attributes.f_22279_, String.valueOf(SAND_SPEED_BONUS));
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.updateSpeedModifier(player);
        }
    }

    private void updateSpeedModifier(Player player) {
        BlockState blockState = player.m_9236_().m_8055_(player.m_20183_().m_7495_());
        if (blockState.m_204336_(Tags.Blocks.SAND)) {
            MAUtils.addAttributes(player, Attributes.f_22279_, (Double)CommonConfig.DUNE_TREADS_SAND_SPEED.get(), AttributeModifier.Operation.MULTIPLY_BASE, String.valueOf(SAND_SPEED_BONUS));
        } else {
            MAUtils.removeAttributes(player, Attributes.f_22279_, String.valueOf(SAND_SPEED_BONUS));
        }
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        double movementSpeed = (Double)CommonConfig.DUNE_TREADS_SPEED.get() * 100.0;
        double sandSpeed = (Double)CommonConfig.DUNE_TREADS_SAND_SPEED.get() * 100.0;
        pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.moreartifacts.dune_treads.speed", (Object[])new Object[]{String.format("%.1f", movementSpeed)}).m_130940_(ChatFormatting.DARK_AQUA));
        pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.moreartifacts.dune_treads.bonus_on_sand", (Object[])new Object[]{String.format("%.1f", sandSpeed)}).m_130940_(ChatFormatting.DARK_AQUA));
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }
}

