/*
 * Decompiled with CFR 0.152.
 */
package net.gobies.moreartifacts.item.artifacts;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.gobies.moreartifacts.config.CommonConfig;
import net.gobies.moreartifacts.init.MAItems;
import net.gobies.moreartifacts.util.CurioHandler;
import net.gobies.moreartifacts.util.MAUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class EchoGloveItem
extends Item
implements ICurioItem {
    private static final UUID ATTACK_DAMAGE_UUID;
    private static final UUID ATTACK_SPEED_UUID;

    public EchoGloveItem(Item.Properties properties) {
        super(properties.m_41487_(1).m_41497_(Rarity.RARE));
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            MAUtils.addAttributes(player, Attributes.f_22281_, (Double)CommonConfig.ECHO_GLOVE_DAMAGE.get(), AttributeModifier.Operation.MULTIPLY_BASE, String.valueOf(ATTACK_DAMAGE_UUID));
            MAUtils.addAttributes(player, Attributes.f_22283_, (Double)CommonConfig.ECHO_GLOVE_ATTACK_SPEED.get(), AttributeModifier.Operation.MULTIPLY_BASE, String.valueOf(ATTACK_SPEED_UUID));
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            MAUtils.removeAttributes(player, Attributes.f_22281_, String.valueOf(ATTACK_DAMAGE_UUID));
            MAUtils.removeAttributes(player, Attributes.f_22283_, String.valueOf(ATTACK_SPEED_UUID));
        }
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        Entity entity;
        if (!event.isCanceled() && (entity = event.getSource().m_7639_()) instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            LivingEntity attackedEntity = event.getEntity();
            int gloveCount = CurioHandler.getCurioCount(attacker, (Item)MAItems.EchoGlove.get());
            for (int i = 0; i < gloveCount; ++i) {
                RandomSource random = attacker.m_217043_();
                double ignoreChance = (Double)CommonConfig.ECHO_GLOVE_IGNORE_CHANCE.get() * (double)gloveCount;
                if (!((double)random.m_188501_() < ignoreChance)) continue;
                attackedEntity.f_19802_ = Math.max(0, attackedEntity.f_19802_ - 5);
            }
        }
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        double attackDamage = (Double)CommonConfig.ECHO_GLOVE_DAMAGE.get() * 100.0;
        double attackSpeed = (Double)CommonConfig.ECHO_GLOVE_ATTACK_SPEED.get() * 100.0;
        double ignoreChance = (Double)CommonConfig.ECHO_GLOVE_IGNORE_CHANCE.get() * 100.0;
        pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.moreartifacts.echo_glove.damage", (Object[])new Object[]{String.format("%.1f", attackDamage)}).m_130940_(ChatFormatting.DARK_AQUA));
        pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.moreartifacts.echo_glove.speed", (Object[])new Object[]{String.format("%.1f", attackSpeed)}).m_130940_(ChatFormatting.DARK_AQUA));
        pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.moreartifacts.echo_glove.ignore_chance", (Object[])new Object[]{String.format("%.1f", ignoreChance)}).m_130940_(ChatFormatting.DARK_AQUA));
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    static {
        MinecraftForge.EVENT_BUS.register(EchoGloveItem.class);
        ATTACK_DAMAGE_UUID = UUID.randomUUID();
        ATTACK_SPEED_UUID = UUID.randomUUID();
    }
}

