/*
 * Decompiled with CFR 0.152.
 */
package net.gobies.moreartifacts.item.artifacts;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.gobies.moreartifacts.config.CommonConfig;
import net.gobies.moreartifacts.init.MAItems;
import net.gobies.moreartifacts.util.MAUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class EnderianTreadsItem
extends Item
implements ICurioItem {
    private static final UUID SPEED = UUID.randomUUID();
    private static final Map<UUID, Long> cooldownMap = new HashMap<UUID, Long>();

    public EnderianTreadsItem(Item.Properties properties) {
        super(properties.m_41487_(1).m_41497_(Rarity.EPIC));
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            MAUtils.addAttributes(player, Attributes.f_22279_, (Double)CommonConfig.ENDERIAN_TREADS_SPEED.get(), AttributeModifier.Operation.MULTIPLY_BASE, String.valueOf(SPEED));
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            MAUtils.removeAttributes(player, Attributes.f_22279_, String.valueOf(SPEED));
        }
    }

    public static boolean canUseAbility(Player player) {
        Long lastUsed = cooldownMap.get(player.m_20148_());
        long currentTime = System.currentTimeMillis();
        long cooldownDuration = (long)(1000.0 * (Double)CommonConfig.ENDERIAN_TREADS_COOLDOWN.get());
        if (lastUsed == null) {
            MAUtils.logDebug("Teleported: {}" + player.m_20148_());
            return true;
        }
        long timeSinceLastUse = currentTime - lastUsed;
        return timeSinceLastUse >= cooldownDuration;
    }

    public static void teleportPlayer(ServerPlayer player) {
        double x = player.m_20185_();
        double y = player.m_20186_();
        double z = player.m_20189_();
        for (int i = 0; i < 20; ++i) {
            double offsetX = Math.random() * 7.0 + 10.0;
            double offsetY = Math.random() * 7.0 - 3.0;
            double offsetZ = Math.random() * 7.0 + 10.0;
            int offsetXInt = (int)Math.round(offsetX);
            int offsetYInt = (int)Math.round(offsetY);
            int offsetZInt = (int)Math.round(offsetZ);
            BlockPos targetPos = player.m_20183_().m_7918_(offsetXInt, offsetYInt, offsetZInt);
            BlockPos targetPosBelow = targetPos.m_7495_();
            if (player.m_9236_().m_8055_(targetPosBelow).m_60734_().equals(Blocks.f_50016_) || !player.m_9236_().m_8055_(targetPos).m_60734_().equals(Blocks.f_50016_)) continue;
            player.m_6021_(x + offsetX, y + offsetY, z + offsetZ);
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 2.0f, 1.0f);
            player.m_5661_((Component)Component.m_237115_((String)"message.moreartifacts.enderian_treads.evade").m_130940_(ChatFormatting.LIGHT_PURPLE), true);
            player.m_36335_().m_41524_((Item)MAItems.EnderianTreads.get(), (int)(20.0 * (Double)CommonConfig.ENDERIAN_TREADS_COOLDOWN.get()));
            break;
        }
    }

    public static void setCooldown(Player player) {
        cooldownMap.put(player.m_20148_(), System.currentTimeMillis());
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        double movementSpeed = (Double)CommonConfig.ENDERIAN_TREADS_SPEED.get() * 100.0;
        double evadeCooldown = (Double)CommonConfig.ENDERIAN_TREADS_COOLDOWN.get();
        pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.moreartifacts.enderian_treads.speed", (Object[])new Object[]{String.format("%.1f", movementSpeed)}).m_130940_(ChatFormatting.DARK_AQUA));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.moreartifacts.enderian_treads.evade").m_130940_(ChatFormatting.GOLD));
        pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.moreartifacts.enderian_treads.cooldown", (Object[])new Object[]{evadeCooldown}).m_130940_(ChatFormatting.DARK_AQUA));
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }
}

