/*
 * Decompiled with CFR 0.152.
 */
package net.gobies.moreartifacts.item.artifacts;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.gobies.moreartifacts.config.CommonConfig;
import net.gobies.moreartifacts.util.ModLoadedUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class HeroShieldItem
extends Item
implements ICurioItem {
    public HeroShieldItem(Item.Properties properties) {
        super(properties.m_41487_(1).m_41497_(Rarity.EPIC).m_41486_());
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player && !(player = (Player)livingEntity).m_21023_(MobEffects.f_19606_)) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, -1, (Integer)CommonConfig.HERO_SHIELD_RES_LEVEL.get() - 1, false, false));
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.m_21195_(MobEffects.f_19606_);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (event.getSource().m_7639_() != null) {
                CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> handler.findFirstCurio(stack -> stack.m_41720_() instanceof HeroShieldItem).ifPresent(slotResult -> {
                    ItemStack stack = slotResult.stack();
                    if (stack.m_41720_() instanceof HeroShieldItem) {
                        ItemStack pStack = slotResult.stack();
                        CompoundTag tag = pStack.m_41784_();
                        int hitCount = tag.m_128451_("HitCount");
                        Random random = new Random();
                        tag.m_128405_("HitCount", ++hitCount);
                        if (hitCount % (Integer)CommonConfig.IGNORE_DAMAGE_CHANCE.get() == 0 && !event.isCanceled()) {
                            event.setCanceled(true);
                            player.m_5661_((Component)Component.m_237115_((String)"message.moreartifacts.hero_shield.damage_text").m_130940_(ChatFormatting.GOLD), true);
                            float randomPitch = 1.0f + random.nextFloat() * 0.2f;
                            player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_11668_, SoundSource.PLAYERS, 0.3f, randomPitch);
                            tag.m_128405_("HitCount", 0);
                        }
                        if (event.getSource().m_276093_(DamageTypes.f_268565_) || event.getSource().m_276093_(DamageTypes.f_268448_)) {
                            event.setAmount((float)((double)event.getAmount() * (Double)CommonConfig.EXPLOSION_DAMAGE_TAKEN.get()));
                        }
                    }
                }));
            }
        }
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        CompoundTag tag = pStack.m_41783_();
        int hitCount = tag != null ? tag.m_128451_("HitCount") : 0;
        int ignoreDamage = (Integer)CommonConfig.IGNORE_DAMAGE_CHANCE.get();
        double explosionDamage = (1.0 - (Double)CommonConfig.EXPLOSION_DAMAGE_TAKEN.get()) * 100.0;
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.moreartifacts.hero_shield.resistance").m_130940_(ChatFormatting.GOLD));
        pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.moreartifacts.hero_shield.damage_ignore", (Object[])new Object[]{ignoreDamage, hitCount, ignoreDamage}).m_130940_(ChatFormatting.DARK_AQUA));
        pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.moreartifacts.hero_shield.explosion_damage", (Object[])new Object[]{String.format("%.1f", explosionDamage)}).m_130940_(ChatFormatting.DARK_AQUA));
        if (ModLoadedUtil.isEnhancedVisualsLoaded() && ((Boolean)CommonConfig.HERO_SHIELD_COMPAT.get()).booleanValue()) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.moreartifacts.hold.ctrl"));
            if (Screen.m_96637_()) {
                pTooltipComponents.remove(4);
                pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.moreartifacts.hero_shield.enhanced_visuals").m_130940_(ChatFormatting.GRAY));
            }
            super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        }
    }

    static {
        MinecraftForge.EVENT_BUS.register(HeroShieldItem.class);
    }
}

