/*
 * Decompiled with CFR 0.152.
 */
package net.gobies.moreartifacts.item.artifacts;

import java.util.List;
import javax.annotation.Nullable;
import net.gobies.moreartifacts.config.CommonConfig;
import net.gobies.moreartifacts.util.ModLoadedUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class IceStoneItem
extends Item
implements ICurioItem {
    public IceStoneItem(Item.Properties properties) {
        super(properties.m_41487_(1).m_41497_(Rarity.RARE));
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_203117_()) {
            player.m_146917_(-1);
        }
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        double iceChance = (Double)CommonConfig.ICE_STONE_CHANCE.get() * 100.0;
        int iceDuration = (Integer)CommonConfig.ICE_STONE_DURATION.get();
        double increasedDamage = ((Double)CommonConfig.ICE_STONE_DAMAGE.get() - 1.0) * 100.0;
        double encaseChance = (Double)CommonConfig.ICE_STONE_ENCASED_CHANCE.get() * 100.0;
        int encaseDuration = (Integer)CommonConfig.ICE_STONE_ENCASED_DURATION.get();
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.moreartifacts.ice_stone.immunity").m_130940_(ChatFormatting.AQUA));
        pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.moreartifacts.ice_stone.freeze", (Object[])new Object[]{String.format("%.1f", iceChance), iceDuration}).m_130940_(ChatFormatting.DARK_AQUA));
        pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.moreartifacts.ice_stone.increased_damage", (Object[])new Object[]{String.format("%.1f", increasedDamage)}).m_130940_(ChatFormatting.DARK_AQUA));
        if (ModLoadedUtil.isIceandFireLoaded() && ((Boolean)CommonConfig.ICE_STONE_COMPAT.get()).booleanValue()) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.moreartifacts.hold.ctrl"));
            if (Screen.m_96637_()) {
                pTooltipComponents.remove(4);
                pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.moreartifacts.ice_stone.encased", (Object[])new Object[]{String.format("%.1f", encaseChance), encaseDuration}).m_130940_(ChatFormatting.DARK_AQUA));
            }
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }
}

