/*
 * Decompiled with CFR 0.152.
 */
package net.gobies.moreartifacts.item.artifacts;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.gobies.moreartifacts.config.CommonConfig;
import net.gobies.moreartifacts.init.MAItems;
import net.gobies.moreartifacts.util.CurioHandler;
import net.gobies.moreartifacts.util.MAUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class LuckyEmeraldRingItem
extends Item
implements ICurioItem {
    private static final UUID LUCK;

    public LuckyEmeraldRingItem(Item.Properties properties) {
        super(properties.m_41487_(1).m_41497_(Rarity.EPIC));
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (event.getEntity() != null) {
                LivingEntity target = event.getEntity();
                if (CurioHandler.isCurioEquipped((LivingEntity)player, (Item)MAItems.LuckyEmeraldRing.get()) && target instanceof LivingEntity && (double)player.m_9236_().f_46441_.m_188501_() < (Double)CommonConfig.EMERALD_RING_EMERALDS.get()) {
                    target.m_20000_((ItemLike)Items.f_42616_, 1);
                    player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_144242_, SoundSource.PLAYERS, 1.0f, 1.8f);
                }
            }
        }
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            MAUtils.addAttributes(player, Attributes.f_22286_, ((Integer)CommonConfig.EMERALD_RING_LUCK.get()).intValue(), AttributeModifier.Operation.ADDITION, String.valueOf(LUCK));
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            MAUtils.removeAttributes(player, Attributes.f_22286_, String.valueOf(LUCK));
        }
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        int luckIncrease = (Integer)CommonConfig.EMERALD_RING_LUCK.get();
        double emeraldChance = (Double)CommonConfig.EMERALD_RING_EMERALDS.get() * 100.0;
        double damageIncrease = ((Double)CommonConfig.EMERALD_RING_DAMAGE.get() - 1.0) * 100.0;
        pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.moreartifacts.lucky_emerald_ring.luck", (Object[])new Object[]{luckIncrease}).m_130940_(ChatFormatting.DARK_AQUA));
        pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.moreartifacts.lucky_emerald_ring.chance", (Object[])new Object[]{String.format("%.1f", emeraldChance)}).m_130940_(ChatFormatting.DARK_AQUA));
        pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.moreartifacts.lucky_emerald_ring.damage", (Object[])new Object[]{String.format("%.1f", damageIncrease)}).m_130940_(ChatFormatting.DARK_AQUA));
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    static {
        MinecraftForge.EVENT_BUS.register(LuckyEmeraldRingItem.class);
        LUCK = UUID.randomUUID();
    }
}

