/*
 * Decompiled with CFR 0.152.
 */
package net.gobies.moreartifacts.item.artifacts;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.gobies.moreartifacts.config.CommonConfig;
import net.gobies.moreartifacts.util.MAUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class MechanicalClawItem
extends Item
implements ICurioItem {
    private static final UUID ATTACK_DAMAGE_UUID = UUID.randomUUID();

    public MechanicalClawItem(Item.Properties properties) {
        super(properties.m_41487_(1).m_41497_(Rarity.RARE));
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            MAUtils.addAttributes(player, Attributes.f_22281_, (Double)CommonConfig.MECHANICAL_CLAW_DAMAGE.get(), AttributeModifier.Operation.MULTIPLY_BASE, String.valueOf(ATTACK_DAMAGE_UUID));
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            MAUtils.removeAttributes(player, Attributes.f_22281_, String.valueOf(ATTACK_DAMAGE_UUID));
        }
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        double clawDamage = (Double)CommonConfig.MECHANICAL_CLAW_DAMAGE.get() * 100.0;
        double bleedChance = (Double)CommonConfig.MECHANICAL_CLAW_BLEED_CHANCE.get() * 100.0;
        int bleedDamage = (Integer)CommonConfig.MECHANICAL_CLAW_BLEED_DAMAGE.get();
        int bleedDuration = (Integer)CommonConfig.MECHANICAL_CLAW_BLEED_DURATION.get();
        pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.moreartifacts.mechanical_claw.damage", (Object[])new Object[]{String.format("%.1f", clawDamage)}).m_130940_(ChatFormatting.DARK_AQUA));
        pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.moreartifacts.mechanical_claw.bleed_chance", (Object[])new Object[]{String.format("%.1f", bleedChance)}).m_130940_(ChatFormatting.DARK_AQUA));
        pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.moreartifacts.mechanical_claw.bleed_damage_duration", (Object[])new Object[]{bleedDamage, bleedDuration}).m_130940_(ChatFormatting.DARK_AQUA));
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }
}

