/*
 * Decompiled with CFR 0.152.
 */
package net.gobies.moreartifacts.item.artifacts;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.gobies.moreartifacts.config.CommonConfig;
import net.gobies.moreartifacts.util.MAUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class MelodyPlushieItem
extends Item
implements ICurioItem {
    private static final UUID MAX_HEALTH = UUID.randomUUID();

    public MelodyPlushieItem(Item.Properties properties) {
        super(properties.m_41487_(1).m_41497_(Rarity.EPIC));
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player && !(player = (Player)livingEntity).m_21023_(MobEffects.f_19605_)) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, -1, (Integer)CommonConfig.PLUSHIE_REGEN_LEVEL.get() - 1, false, false));
        }
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            MAUtils.addAttributes(player, Attributes.f_22276_, (Double)CommonConfig.PLUSHIE_HEALTH.get(), AttributeModifier.Operation.MULTIPLY_BASE, String.valueOf(MAX_HEALTH));
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.m_21195_(MobEffects.f_19605_);
            MAUtils.removeAttributes(player, Attributes.f_22276_, String.valueOf(MAX_HEALTH));
            if (!player.m_7500_() && !player.m_5833_()) {
                player.m_21153_(player.m_21223_() - 0.1f);
            }
        }
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        double maxHealth = (Double)CommonConfig.PLUSHIE_HEALTH.get() * 100.0;
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.moreartifacts.melody_plushie.regen").m_130940_(ChatFormatting.LIGHT_PURPLE));
        pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.moreartifacts.melody_plushie.health", (Object[])new Object[]{String.format("%.1f", maxHealth)}).m_130940_(ChatFormatting.DARK_AQUA));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.moreartifacts.melody_plushie.sleep").m_130940_(ChatFormatting.DARK_AQUA));
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }
}

