/*
 * Decompiled with CFR 0.152.
 */
package net.gobies.moreartifacts.item.artifacts;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.gobies.moreartifacts.config.CommonConfig;
import net.gobies.moreartifacts.util.MAUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class NaturesMantleItem
extends Item
implements ICurioItem {
    private int standStillCounter = 0;
    private int randomDuration = 0;
    private static final UUID SPEED = UUID.randomUUID();

    public NaturesMantleItem(Item.Properties properties) {
        super(properties.m_41487_(1).m_41497_(Rarity.UNCOMMON));
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            Level level = player.m_9236_();
            if (level.m_46461_()) {
                if (!player.f_267362_.m_267780_() && !player.m_20142_()) {
                    if (this.standStillCounter == 0) {
                        this.standStillCounter = 1;
                        this.randomDuration = level.f_46441_.m_188503_(400) + 400;
                    } else {
                        ++this.standStillCounter;
                        if (this.standStillCounter >= this.randomDuration && !player.m_21023_(MobEffects.f_19605_)) {
                            player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 125, 0, false, false, false));
                            this.standStillCounter = 0;
                        }
                    }
                } else {
                    this.standStillCounter = 0;
                    if (player.m_21023_(MobEffects.f_19605_)) {
                        player.m_21195_(MobEffects.f_19605_);
                    }
                }
            } else {
                this.standStillCounter = 0;
                if (player.m_21023_(MobEffects.f_19605_)) {
                    player.m_21195_(MobEffects.f_19605_);
                }
            }
        }
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            MAUtils.addAttributes(player, Attributes.f_22279_, (Double)CommonConfig.NATURES_MANTLE_SPEED_INCREASE.get(), AttributeModifier.Operation.MULTIPLY_BASE, String.valueOf(SPEED));
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            MAUtils.removeAttributes(player, Attributes.f_22279_, String.valueOf(SPEED));
            if (player.m_21023_(MobEffects.f_19605_)) {
                player.m_21195_(MobEffects.f_19605_);
            }
        }
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        double speedIncrease = (Double)CommonConfig.NATURES_MANTLE_SPEED_INCREASE.get() * 100.0;
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.moreartifacts.natures_mantle.regeneration").m_130940_(ChatFormatting.GRAY));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.moreartifacts.natures_mantle.day").m_130940_(ChatFormatting.GRAY));
        pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.moreartifacts.natures_mantle.speed", (Object[])new Object[]{String.format("%.1f", speedIncrease)}).m_130940_(ChatFormatting.DARK_AQUA));
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }
}

