/*
 * Decompiled with CFR 0.152.
 */
package net.gobies.moreartifacts.item.artifacts;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.gobies.moreartifacts.config.CommonConfig;
import net.gobies.moreartifacts.util.MAUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class NetheriteHeadgearItem
extends Item
implements ICurioItem {
    private static final UUID ARMOR = UUID.randomUUID();

    public NetheriteHeadgearItem(Item.Properties properties) {
        super(properties.m_41487_(1).m_41497_(Rarity.RARE).m_41486_());
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            MAUtils.addAttributes(player, Attributes.f_22284_, (Double)CommonConfig.NETHERITE_HEADGEAR_ARMOR.get(), AttributeModifier.Operation.ADDITION, String.valueOf(ARMOR));
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            MAUtils.removeAttributes(player, Attributes.f_22284_, String.valueOf(ARMOR));
        }
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.f_11679_, 1.0f, 1.0f);
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        int increasedArmor = ((Double)CommonConfig.NETHERITE_HEADGEAR_ARMOR.get()).intValue();
        double arrowDamageReduction = (1.0 - (Double)CommonConfig.NETHERITE_HEADGEAR_ARROW_DAMAGE_TAKEN.get()) * 100.0;
        pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.moreartifacts.netherite_headgear.armor", (Object[])new Object[]{String.format("%d", increasedArmor)}).m_130940_(ChatFormatting.DARK_AQUA));
        pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.moreartifacts.netherite_headgear.arrow.damage", (Object[])new Object[]{String.format("%.1f", arrowDamageReduction)}).m_130940_(ChatFormatting.DARK_AQUA));
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }
}

