/*
 * Decompiled with CFR 0.152.
 */
package net.gobies.moreartifacts.item.artifacts;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.gobies.moreartifacts.config.CommonConfig;
import net.gobies.moreartifacts.util.MAUtils;
import net.gobies.moreartifacts.util.ModLoadedUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class TrueEnderianScarfItem
extends Item
implements ICurioItem {
    private static final UUID ENTITY_REACH = UUID.randomUUID();
    private static final UUID BLOCK_REACH = UUID.randomUUID();

    public TrueEnderianScarfItem(Item.Properties properties) {
        super(properties.m_41487_(1).m_41497_(Rarity.RARE));
    }

    public boolean isEnderMask(SlotContext slotContext, EnderMan enderMan, ItemStack stack) {
        LivingEntity var5 = slotContext.entity();
        return var5 instanceof Player && stack.m_41720_() instanceof TrueEnderianScarfItem;
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            MAUtils.addAttributes(player, (Attribute)ForgeMod.ENTITY_REACH.get(), (Double)CommonConfig.TRUE_ENDERIAN_REACH.get(), AttributeModifier.Operation.ADDITION, String.valueOf(ENTITY_REACH));
            MAUtils.addAttributes(player, (Attribute)ForgeMod.BLOCK_REACH.get(), (Double)CommonConfig.TRUE_ENDERIAN_REACH.get(), AttributeModifier.Operation.ADDITION, String.valueOf(BLOCK_REACH));
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            MAUtils.removeAttributes(player, (Attribute)ForgeMod.ENTITY_REACH.get(), String.valueOf(ENTITY_REACH));
            MAUtils.removeAttributes(player, (Attribute)ForgeMod.BLOCK_REACH.get(), String.valueOf(BLOCK_REACH));
        }
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        double scarfDamageTaken = 100.0 - (Double)CommonConfig.TRUE_ENDERIAN_DAMAGE_TAKEN.get() * 100.0;
        double scarfEvadeChance = (Double)CommonConfig.TRUE_ENDERIAN_EVADE.get() * 100.0;
        double scarfReach = (Double)CommonConfig.TRUE_ENDERIAN_REACH.get();
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.moreartifacts.true_enderian_scarf.neutral").m_130940_(ChatFormatting.LIGHT_PURPLE));
        pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.moreartifacts.true_enderian_scarf.damage_taken", (Object[])new Object[]{String.format("%.1f", scarfDamageTaken)}).m_130940_(ChatFormatting.DARK_AQUA));
        pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.moreartifacts.true_enderian_scarf.evade_chance", (Object[])new Object[]{String.format("%.1f", scarfEvadeChance)}).m_130940_(ChatFormatting.DARK_AQUA));
        pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.moreartifacts.true_enderian_scarf.reach", (Object[])new Object[]{scarfReach}).m_130940_(ChatFormatting.DARK_AQUA));
        if (ModLoadedUtil.isEnhancedVisualsLoaded() && ((Boolean)CommonConfig.TRUE_ENDERIAN_COMPAT.get()).booleanValue()) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.moreartifacts.hold.ctrl"));
            if (Screen.m_96637_()) {
                pTooltipComponents.remove(5);
                pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.moreartifacts.true_enderian_scarf.enhanced_visuals").m_130940_(ChatFormatting.GRAY));
            }
            super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        }
    }
}

