/*
 * Decompiled with CFR 0.152.
 */
package net.gobies.moreartifacts.item.artifacts;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.gobies.moreartifacts.config.CommonConfig;
import net.gobies.moreartifacts.util.MAUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class VanirMaskItem
extends Item
implements ICurioItem {
    private static final UUID ARMOR = UUID.randomUUID();
    private static final UUID ARMOR_TOUGHNESS = UUID.randomUUID();
    private static final UUID MAX_HEALTH = UUID.randomUUID();
    private static final UUID MOVEMENT_SPEED = UUID.randomUUID();

    public VanirMaskItem(Item.Properties properties) {
        super(properties.m_41487_(1).m_41497_(Rarity.EPIC));
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            MAUtils.addAttributes(player, Attributes.f_22284_, (Double)CommonConfig.VANIR_MASK_ARMOR_INCREASE.get(), AttributeModifier.Operation.MULTIPLY_BASE, String.valueOf(ARMOR));
            MAUtils.addAttributes(player, Attributes.f_22285_, (Double)CommonConfig.VANIR_MASK_ARMOR_TOUGHNESS_INCREASE.get(), AttributeModifier.Operation.MULTIPLY_BASE, String.valueOf(ARMOR_TOUGHNESS));
            MAUtils.addAttributes(player, Attributes.f_22276_, (Double)CommonConfig.VANIR_MASK_HEALTH_INCREASE.get(), AttributeModifier.Operation.MULTIPLY_BASE, String.valueOf(MAX_HEALTH));
            MAUtils.addAttributes(player, Attributes.f_22279_, (Double)CommonConfig.VANIR_MASK_SPEED_INCREASE.get(), AttributeModifier.Operation.MULTIPLY_BASE, String.valueOf(MOVEMENT_SPEED));
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            MAUtils.removeAttributes(player, Attributes.f_22284_, String.valueOf(ARMOR));
            MAUtils.removeAttributes(player, Attributes.f_22285_, String.valueOf(ARMOR_TOUGHNESS));
            MAUtils.removeAttributes(player, Attributes.f_22276_, String.valueOf(MAX_HEALTH));
            MAUtils.removeAttributes(player, Attributes.f_22279_, String.valueOf(MOVEMENT_SPEED));
        }
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        double damageIncrease = (Double)CommonConfig.VANIR_MASK_DAMAGE_INCREASE.get();
        double healthIncrease = (Double)CommonConfig.VANIR_MASK_HEALTH_INCREASE.get() * 100.0;
        double speedIncrease = (Double)CommonConfig.VANIR_MASK_SPEED_INCREASE.get() * 100.0;
        double armorIncrease = (Double)CommonConfig.VANIR_MASK_ARMOR_INCREASE.get() * 100.0;
        double armorToughnessIncrease = (Double)CommonConfig.VANIR_MASK_ARMOR_TOUGHNESS_INCREASE.get() * 100.0;
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.moreartifacts.vanir.mask.bloodflow").m_130940_(ChatFormatting.GOLD));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.moreartifacts.hold.ctrl"));
        if (Screen.m_96637_()) {
            pTooltipComponents.remove(2);
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.moreartifacts.vanir_mask.damage", (Object[])new Object[]{String.format("%.1f", damageIncrease)}).m_130940_(ChatFormatting.DARK_AQUA));
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.moreartifacts.vanir_mask.health", (Object[])new Object[]{String.format("%.1f", healthIncrease)}).m_130940_(ChatFormatting.DARK_AQUA));
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.moreartifacts.vanir_mask.speed", (Object[])new Object[]{String.format("%.1f", speedIncrease)}).m_130940_(ChatFormatting.DARK_AQUA));
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.moreartifacts.vanir_mask.armor", (Object[])new Object[]{String.format("%.1f", armorIncrease)}).m_130940_(ChatFormatting.DARK_AQUA));
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.moreartifacts.vanir_mask.armor_toughness", (Object[])new Object[]{String.format("%.1f", armorToughnessIncrease)}).m_130940_(ChatFormatting.DARK_AQUA));
            super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        }
    }
}

