/*
 * Decompiled with CFR 0.152.
 */
package net.gobies.moreartifacts.item.artifacts;

import java.util.List;
import javax.annotation.Nullable;
import net.gobies.moreartifacts.config.CommonConfig;
import net.gobies.moreartifacts.util.MAUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class VenomStoneItem
extends Item
implements ICurioItem {
    public VenomStoneItem(Item.Properties properties) {
        super(properties.m_41487_(1).m_41497_(Rarity.RARE));
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            MAUtils.removeEffect(player, MobEffects.f_19614_);
        }
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        double poisonChance = (Double)CommonConfig.VENOM_STONE_CHANCE.get() * 100.0;
        int poisonLevel = (Integer)CommonConfig.VENOM_STONE_LEVEL.get();
        int poisonDuration = (Integer)CommonConfig.VENOM_STONE_DURATION.get();
        double increasedDamage = ((Double)CommonConfig.VENOM_STONE_DAMAGE.get() - 1.0) * 100.0;
        double deadlyChance = (Double)CommonConfig.VENOM_STONE_DEADLY_CHANCE.get() * 100.0;
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.moreartifacts.venom_stone.immunity").m_130940_(ChatFormatting.GREEN));
        pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.moreartifacts.venom_stone.inflict_poison", (Object[])new Object[]{String.format("%.1f", poisonChance), poisonLevel, poisonDuration}).m_130940_(ChatFormatting.DARK_AQUA));
        pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.moreartifacts.venom_stone.increased_damage", (Object[])new Object[]{String.format("%.1f", increasedDamage)}).m_130940_(ChatFormatting.DARK_AQUA));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.moreartifacts.hold.ctrl"));
        if (Screen.m_96637_()) {
            pTooltipComponents.remove(4);
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.moreartifacts.venom_stone.deadly.chance", (Object[])new Object[]{String.format("%.1f", deadlyChance)}).m_130940_(ChatFormatting.DARK_AQUA));
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    static {
        MinecraftForge.EVENT_BUS.register(VenomStoneItem.class);
    }
}

