/*
 * Decompiled with CFR 0.152.
 */
package net.gobies.moreartifacts.util;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CurioHandler {
    public static boolean isCurioEquipped(LivingEntity entity, Item targetItem) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).resolve().flatMap(curios -> curios.findFirstCurio(stack -> stack.m_41720_() == targetItem)).isPresent();
    }

    public static int getCurioCount(LivingEntity entity, Item item) {
        AtomicInteger count = new AtomicInteger();
        CuriosApi.getCuriosInventory((LivingEntity)entity).ifPresent(handler -> handler.getCurios().forEach((identifier, stacksHandler) -> {
            IDynamicStackHandler stackHandler = stacksHandler.getStacks();
            for (int i = 0; i < stackHandler.getSlots(); ++i) {
                if (stackHandler.getStackInSlot(i).m_41720_() != item) continue;
                count.getAndIncrement();
            }
        }));
        return count.get();
    }

    public static int getEquippedCuriosCount(LivingEntity entity, @NotNull Item targetItem, @Nullable Item optionalItem) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).resolve().map(handler -> (int)handler.getCurios().values().stream().flatMap(curio -> {
            int slots = curio.getSlots();
            return IntStream.range(0, slots).mapToObj(slotIndex -> curio.getStacks().getStackInSlot(slotIndex)).limit(slots);
        }).filter(itemStack -> {
            Item stackItem = itemStack.m_41720_();
            return stackItem == targetItem || optionalItem != null && stackItem == optionalItem;
        }).count()).orElse(0);
    }
}

