/*
 * Decompiled with CFR 0.152.
 */
package net.gobies.moreartifacts.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.gobies.moreartifacts.config.CommonConfig;
import net.gobies.moreartifacts.init.MAItems;
import net.gobies.moreartifacts.util.CurioHandler;
import net.gobies.moreartifacts.util.ShieldHandler;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.RegistryObject;

public abstract class DamageCalculator {
    private static final List<Item> itemsToCheck = MAItems.getAllArtifacts().stream().map(RegistryObject::get).toList();

    public static double calculateTotalDamageReduction(Player player) {
        double generalReduction = 0.0;
        generalReduction += DamageCalculator.getDamageReduction(player, (Item)MAItems.EnderianScarf.get(), (Double)CommonConfig.ENDERIAN_DAMAGE_TAKEN.get());
        generalReduction += DamageCalculator.getDamageReduction(player, (Item)MAItems.GildedScarf.get(), (Double)CommonConfig.GILDED_DAMAGE_TAKEN.get());
        return Math.min(generalReduction += DamageCalculator.getDamageReduction(player, (Item)MAItems.TrueEnderianScarf.get(), (Double)CommonConfig.TRUE_ENDERIAN_DAMAGE_TAKEN.get()), (Double)CommonConfig.MAX_DAMAGE_REDUCTION.get());
    }

    public static double calculateFireDamageReduction(Player player) {
        double fireReduction = 0.0;
        fireReduction += DamageCalculator.getDamageReduction(player, (Item)MAItems.ObsidianSkull.get(), (Double)CommonConfig.SKULL_FIRE_DAMAGE_TAKEN.get());
        fireReduction += DamageCalculator.getDamageReduction(player, (Item)MAItems.ObsidianShield.get(), (Double)CommonConfig.OBSIDIAN_SHIELD_FIRE_DAMAGE_TAKEN.get());
        return Math.min(fireReduction += DamageCalculator.getDamageReduction(player, (Item)MAItems.AnkhShield.get(), (Double)CommonConfig.ANKH_SHIELD_FIRE_DAMAGE_TAKEN.get()), (Double)CommonConfig.MAX_FIRE_DAMAGE_REDUCTION.get());
    }

    public static double calculateDamageIncrease(Player player) {
        double generalIncrease = 0.0;
        generalIncrease += DamageCalculator.getDamageIncrease(player, (Item)MAItems.GildedScarf.get(), (Double)CommonConfig.GILDED_DAMAGE_DEALT.get());
        generalIncrease += DamageCalculator.getDamageIncrease(player, (Item)MAItems.EnderDragonClaw.get(), (Double)CommonConfig.ENDER_DRAGON_CLAW_DAMAGE.get());
        generalIncrease += DamageCalculator.getDamageIncrease(player, (Item)MAItems.LuckyEmeraldRing.get(), (Double)CommonConfig.EMERALD_RING_DAMAGE.get());
        generalIncrease += DamageCalculator.getDamageIncrease(player, (Item)MAItems.VenomStone.get(), (Double)CommonConfig.VENOM_STONE_DAMAGE.get());
        generalIncrease += DamageCalculator.getDamageIncrease(player, (Item)MAItems.DecayStone.get(), (Double)CommonConfig.DECAY_STONE_DAMAGE.get());
        generalIncrease += DamageCalculator.getDamageIncrease(player, (Item)MAItems.FireStone.get(), (Double)CommonConfig.FIRE_STONE_DAMAGE.get());
        generalIncrease += DamageCalculator.getDamageIncrease(player, (Item)MAItems.IceStone.get(), (Double)CommonConfig.ICE_STONE_DAMAGE.get());
        generalIncrease += DamageCalculator.getDamageIncrease(player, (Item)MAItems.MagicQuiver.get(), (Double)CommonConfig.MAGIC_QUIVER_DAMAGE.get());
        generalIncrease += DamageCalculator.getDamageIncrease(player, (Item)MAItems.EnvenomedQuiver.get(), (Double)CommonConfig.ENVENOMED_QUIVER_DAMAGE.get());
        generalIncrease += DamageCalculator.getDamageIncrease(player, (Item)MAItems.MoltenQuiver.get(), (Double)CommonConfig.MOLTEN_QUIVER_DAMAGE.get());
        generalIncrease += DamageCalculator.getDamageIncrease(player, (Item)MAItems.MoltenQuiver.get(), (Double)CommonConfig.MOLTEN_QUIVER_ONFIRE_DAMAGE.get());
        return Math.min(generalIncrease += DamageCalculator.getDamageIncrease(player, (Item)MAItems.RubyRing.get(), 0.1), (Double)CommonConfig.MAX_DAMAGE_INCREASE.get());
    }

    public static double getDamageReduction(Player player, Item item, double configValue) {
        if (item == MAItems.ObsidianShield.get() || item == MAItems.AnkhShield.get()) {
            return CurioHandler.isCurioEquipped((LivingEntity)player, item) ? 1.0 - configValue : (ShieldHandler.isShieldEquipped(player, item) ? 1.0 - configValue : 0.0);
        }
        return CurioHandler.isCurioEquipped((LivingEntity)player, item) ? 1.0 - configValue : 0.0;
    }

    public static double getDamageIncrease(Player player, Item item, double configValue) {
        return CurioHandler.isCurioEquipped((LivingEntity)player, item) ? configValue - 1.0 : 0.0;
    }

    public static Map<Item, Boolean> getCurrentEquipState(Player player) {
        HashMap<Item, Boolean> currentEquippedState = new HashMap<Item, Boolean>();
        for (Item item : itemsToCheck) {
            boolean isEquipped = CurioHandler.isCurioEquipped((LivingEntity)player, item);
            if (!isEquipped) continue;
            currentEquippedState.put(item, true);
        }
        for (Item item : Arrays.asList((Item)MAItems.CobaltShield.get(), (Item)MAItems.ObsidianShield.get(), (Item)MAItems.AnkhShield.get())) {
            if (!ShieldHandler.isShieldEquipped(player, item)) continue;
            currentEquippedState.put(item, true);
        }
        return currentEquippedState;
    }
}

