/*
 * Decompiled with CFR 0.152.
 */
package net.gobies.moreartifacts.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.gobies.moreartifacts.config.CommonConfig;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModList;

public class MAUtils {
    private static final Map<Player, Long> cooldownMap = new HashMap<Player, Long>();

    public static boolean isFire(LivingHurtEvent event) {
        return event.getSource().m_276093_(DamageTypes.f_268468_) || event.getSource().m_276093_(DamageTypes.f_268631_);
    }

    public static void makeBurningImmune(LivingAttackEvent event) {
        if (event.getSource().m_276093_(DamageTypes.f_268434_)) {
            event.setCanceled(true);
        }
    }

    public static void makeFreezingImmune(LivingAttackEvent event) {
        if (event.getSource().m_276093_(DamageTypes.f_268444_)) {
            event.setCanceled(true);
        }
    }

    public static void harmfulEffectImmunity(MobEffectEvent event) {
        MobEffect effect;
        List<MobEffect> harmfulEffects = Arrays.asList(MobEffects.f_19614_, MobEffects.f_19615_, MobEffects.f_19612_, MobEffects.f_19604_, MobEffects.f_19597_, MobEffects.f_19620_, MobEffects.f_19599_, MobEffects.f_19613_, MobEffects.f_19610_, MobEffects.f_216964_);
        if (harmfulEffects.contains(effect = Objects.requireNonNull(event.getEffectInstance()).m_19544_())) {
            event.setResult(Event.Result.DENY);
        }
    }

    public static void harmfulSpecificEffectImmune(MobEffectEvent event, MobEffect ... specificEffects) {
        MobEffect effect;
        List<MobEffect> effectsList = Arrays.asList(specificEffects);
        if (effectsList.contains(effect = Objects.requireNonNull(event.getEffectInstance()).m_19544_())) {
            event.setResult(Event.Result.DENY);
        }
    }

    public static void removeHarmfulEffects(Player player) {
        List<MobEffect> harmfulEffects = Arrays.asList(MobEffects.f_19614_, MobEffects.f_19615_, MobEffects.f_19612_, MobEffects.f_19604_, MobEffects.f_19597_, MobEffects.f_19620_, MobEffects.f_19599_, MobEffects.f_19613_, MobEffects.f_19610_, MobEffects.f_216964_);
        for (MobEffect effect : harmfulEffects) {
            MAUtils.removeEffect(player, effect);
        }
    }

    public static void removeEffect(Player player, MobEffect ... effects) {
        for (MobEffect effect : effects) {
            if (!player.m_21023_(effect)) continue;
            player.m_21195_(effect);
        }
    }

    public static void addAttributes(Player player, Attribute attribute, double amount, AttributeModifier.Operation operation, String name) {
        AttributeInstance attributeInstance;
        UUID modifierId = UUID.nameUUIDFromBytes((player.m_20148_() + name).getBytes());
        if (player.m_21051_(attribute) != null && Objects.requireNonNull(attributeInstance = player.m_21051_(attribute)).m_22111_(modifierId) == null) {
            AttributeModifier modifier = new AttributeModifier(modifierId, attribute.m_22087_(), amount, operation);
            attributeInstance.m_22118_(modifier);
        }
    }

    public static void removeAttributes(Player player, Attribute attribute, String name) {
        AttributeInstance attributeInstance;
        AttributeModifier modifier;
        UUID modifierId = UUID.nameUUIDFromBytes((player.m_20148_() + name).getBytes());
        if (player.m_21051_(attribute) != null && (modifier = Objects.requireNonNull(attributeInstance = player.m_21051_(attribute)).m_22111_(modifierId)) != null) {
            attributeInstance.m_22120_(modifierId);
        }
    }

    public static double getCooldownTimer(Player player, double cooldown) {
        long currentTime = System.currentTimeMillis();
        long lastTeleportTime = cooldownMap.getOrDefault(player, 0L);
        return (double)(currentTime - lastTeleportTime) / 1000.0;
    }

    public static void updateCooldown(Player player) {
        cooldownMap.put(player, System.currentTimeMillis());
    }

    public static boolean isReadyForTeleport(Player player, double cooldown) {
        return MAUtils.getCooldownTimer(player, cooldown) >= cooldown;
    }

    public static void resetCooldownTimer(Player player) {
        cooldownMap.put(player, 0L);
    }

    public static float lootingValues() {
        if (ModList.get().isLoaded("jlme")) {
            return 0.005f;
        }
        return 0.01f;
    }

    public static void logDebug(String message) {
        if (((Boolean)CommonConfig.ENABLE_DEBUG.get()).booleanValue()) {
            System.out.println(message);
        }
    }
}

