/*
 * Decompiled with CFR 0.152.
 */
package net.gobies.moreartifacts.util;

import java.util.HashMap;
import java.util.Map;
import net.gobies.moreartifacts.config.CommonConfig;
import net.gobies.moreartifacts.init.MAItems;
import net.gobies.moreartifacts.item.artifacts.EnderianEyeItem;
import net.gobies.moreartifacts.util.MAUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class Teleport {
    private static final Map<Player, Boolean> teleportStatus = new HashMap<Player, Boolean>();

    public static Vec3 solveTeleportDestination(Level level, LivingEntity entity, BlockPos ignoreblockPos, Vec3 vec3) {
        Vec3 start = entity.m_20299_(1.0f);
        Vec3 direction = entity.m_20252_(1.0f);
        double distance = Math.min((double)((Integer)CommonConfig.ENDERIAN_EYE_RADIUS.get()).intValue(), entity.m_20299_(1.0f).m_82554_(vec3));
        Vec3 end = start.m_82549_(direction.m_82490_(distance));
        BlockHitResult hitResult = level.m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity));
        Vec3 hitVec = hitResult.m_82450_();
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos topPos;
            BlockPos hitPos = BlockPos.m_274446_((Position)hitVec);
            Vec3 adjustedPos = hitVec.m_82546_(direction.m_82490_(0.2));
            BlockPos standPos = BlockPos.m_274446_((Position)adjustedPos);
            if (Math.abs(direction.f_82480_) < 0.9 && level.m_8055_(topPos = hitPos.m_7494_()).m_60795_() && level.m_8055_(topPos.m_7494_()).m_60795_() && !level.m_8055_(hitPos).m_60795_()) {
                return new Vec3((double)hitPos.m_123341_() + 0.5, (double)topPos.m_123342_(), (double)hitPos.m_123343_() + 0.5);
            }
            if (!level.m_8055_(standPos.m_7495_()).m_60795_() && level.m_8055_(standPos).m_60795_() && level.m_8055_(standPos.m_7494_()).m_60795_()) {
                return new Vec3(adjustedPos.f_82479_, (double)standPos.m_123342_(), adjustedPos.f_82481_);
            }
        } else {
            int searchDepth;
            BlockPos groundPos = BlockPos.m_274446_((Position)hitVec);
            int maxSearchDepth = 5;
            for (searchDepth = 0; groundPos.m_123342_() > level.m_141937_() && level.m_8055_(groundPos).m_60795_() && searchDepth < maxSearchDepth; ++searchDepth) {
                groundPos = groundPos.m_7495_();
            }
            if (searchDepth < maxSearchDepth && !level.m_8055_(groundPos).m_60795_() && level.m_8055_(groundPos.m_7494_()).m_60795_() && level.m_8055_(groundPos.m_6630_(2)).m_60795_()) {
                return new Vec3(hitVec.f_82479_, (double)groundPos.m_123342_() + 1.0, hitVec.f_82481_);
            }
        }
        Vec3 fallbackPos = hitVec.m_82546_(direction.m_82490_(0.3));
        return new Vec3(fallbackPos.f_82479_, fallbackPos.f_82480_, fallbackPos.f_82481_);
    }

    public static void teleportPlayer(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Vec3 currentPosition = entity.m_20182_();
        Vec3 start = entity.m_20299_(1.0f);
        Vec3 end = start.m_82549_(entity.m_20252_(1.0f).m_82490_((double)((Integer)CommonConfig.ENDERIAN_EYE_RADIUS.get()).intValue()));
        Vec3 targetPosition = Teleport.solveTeleportDestination((Level)world, (LivingEntity)entity, new BlockPos((int)x, (int)y, (int)z), end);
        if (MAUtils.isReadyForTeleport(player, (Double)CommonConfig.ENDERIAN_EYE_COOLDOWN.get())) {
            entity.m_6021_(targetPosition.f_82479_, targetPosition.f_82480_, targetPosition.f_82481_);
            entity.m_183634_();
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                EnderianEyeItem.enderianEyeParticles(player, currentPosition);
                serverPlayer.f_8906_.m_9774_(targetPosition.f_82479_, targetPosition.f_82480_, targetPosition.f_82481_, entity.m_146908_(), entity.m_146909_());
                MAUtils.updateCooldown(player);
                Teleport.updateTeleportStatus(player, true);
                Level level = (Level)world;
                if (!level.m_5776_()) {
                    level.m_6263_(null, targetPosition.f_82479_, targetPosition.f_82480_, targetPosition.f_82481_, SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 2.0f, 1.0f);
                    EnderianEyeItem.enderianEyeParticles(player, Teleport.solveTeleportDestination(level, (LivingEntity)entity, entity.m_20183_(), entity.m_20299_(1.0f)));
                    serverPlayer.m_36335_().m_41524_((Item)MAItems.EnderianEye.get(), (int)(20.0 * (Double)CommonConfig.ENDERIAN_EYE_COOLDOWN.get()));
                }
            }
        } else if (!MAUtils.isReadyForTeleport(player, (Double)CommonConfig.ENDERIAN_EYE_COOLDOWN.get())) {
            Teleport.updateTeleportStatus(player, false);
        }
    }

    public static boolean hasTeleported(Player player) {
        return teleportStatus.getOrDefault(player, false);
    }

    public static void updateTeleportStatus(Player player, boolean hasTeleported) {
        teleportStatus.put(player, hasTeleported);
    }
}

