/*
 * Decompiled with CFR 0.152.
 */
package org.milkteamc.autotreechop;

import java.io.File;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.milkteamc.autotreechop.AutoTreeChopAPI;
import org.milkteamc.autotreechop.AutoTreeChopExpansion;
import org.milkteamc.autotreechop.Config;
import org.milkteamc.autotreechop.Metrics;
import org.milkteamc.autotreechop.PlayerConfig;
import org.milkteamc.autotreechop.command.Command;
import org.milkteamc.autotreechop.command.TabCompleter;
import org.milkteamc.autotreechop.database.DatabaseManager;
import org.milkteamc.autotreechop.hooks.GriefPreventionHook;
import org.milkteamc.autotreechop.hooks.LandsHook;
import org.milkteamc.autotreechop.hooks.ResidenceHook;
import org.milkteamc.autotreechop.hooks.WorldGuardHook;
import org.milkteamc.autotreechop.libs.tinytranslations.BukkitTinyTranslations;
import org.milkteamc.autotreechop.libs.tinytranslations.GlobalMessages;
import org.milkteamc.autotreechop.libs.tinytranslations.Message;
import org.milkteamc.autotreechop.libs.tinytranslations.MessageBuilder;
import org.milkteamc.autotreechop.libs.tinytranslations.MessageTranslator;
import org.milkteamc.autotreechop.libs.tinytranslations.TinyTranslations;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.ComponentLike;
import org.milkteamc.autotreechop.libs.tinytranslations.storage.properties.PropertiesMessageStorage;
import org.milkteamc.autotreechop.libs.tinytranslations.storage.properties.PropertiesStyleStorage;
import org.milkteamc.autotreechop.libs.updatechecker.UpdateCheckSource;
import org.milkteamc.autotreechop.libs.updatechecker.UpdateChecker;
import org.milkteamc.autotreechop.libs.updatechecker.UserAgentBuilder;
import org.milkteamc.autotreechop.tasks.PlayerDataSaveTask;
import org.milkteamc.autotreechop.utils.CooldownManager;
import org.milkteamc.autotreechop.utils.EffectUtils;
import org.milkteamc.autotreechop.utils.PermissionUtils;
import org.milkteamc.autotreechop.utils.TreeChopUtils;

public class AutoTreeChop
extends JavaPlugin
implements Listener,
CommandExecutor {
    public static final Message noResidencePermissions = new MessageBuilder("noResidencePermissions").withDefault("<prefix_negative>You don't have permission to use AutoTreeChop here.</prefix_negative>").build();
    public static final Message ENABLED_MESSAGE = new MessageBuilder("enabled").withDefault("<prefix>Auto tree chopping enabled.</prefix>").build();
    public static final Message DISABLED_MESSAGE = new MessageBuilder("disabled").withDefault("<prefix_negative>Auto tree chopping disabled.</prefix_negative>").build();
    public static final Message NO_PERMISSION_MESSAGE = new MessageBuilder("no-permission").withDefault(GlobalMessages.NO_PERM_CMD).build();
    public static final Message ONLY_PLAYERS_MESSAGE = new MessageBuilder("only-players").withDefault(GlobalMessages.CMD_PLAYER_ONLY).build();
    public static final Message HIT_MAX_USAGE_MESSAGE = new MessageBuilder("hitmaxusage").withDefault("<prefix_negative>You've reached the daily usage limit.</prefix_negative>").build();
    public static final Message HIT_MAX_BLOCK_MESSAGE = new MessageBuilder("hitmaxblock").withDefault("<prefix_negative>You have reached your daily block breaking limit.</prefix_negative>").build();
    public static final Message USAGE_MESSAGE = new MessageBuilder("usage").withDefault("<prefix>You have used the AutoTreeChop {current_uses}/{max_uses} times today.</prefix>").build();
    public static final Message BLOCKS_BROKEN_MESSAGE = new MessageBuilder("blocks-broken").withDefault("<prefix>You have broken {current_blocks}/{max_blocks} blocks today.</prefix>").build();
    public static final Message ENABLED_BY_OTHER_MESSAGE = new MessageBuilder("enabledByOther").withDefault("<prefix>Auto tree chopping enabled by {player}.</prefix>").build();
    public static final Message ENABLED_FOR_OTHER_MESSAGE = new MessageBuilder("enabledForOther").withDefault("<prefix>Auto tree chopping enabled for {player}</prefix>").build();
    public static final Message DISABLED_BY_OTHER_MESSAGE = new MessageBuilder("disabledByOther").withDefault("<prefix_negative>Auto tree chopping disabled by {player}.</prefix_negative>").build();
    public static final Message DISABLED_FOR_OTHER_MESSAGE = new MessageBuilder("disabledForOther").withDefault("<prefix_negative>Auto tree chopping disabled for {player}</prefix_negative>").build();
    public static final Message STILL_IN_COOLDOWN_MESSAGE = new MessageBuilder("stillInCooldown").withDefault("<prefix_negative>You are still in cooldown! Try again after {cooldown_time} seconds.</prefix_negative>").build();
    public static final Message CONSOLE_NAME = new MessageBuilder("consoleName").withDefault("console").build();
    public static final Message SNEAK_ENABLED_MESSAGE = new MessageBuilder("sneakEnabled").withDefault("<prefix>Auto tree chopping enabled by sneaking.</prefix>").build();
    public static final Message SNEAK_DISABLED_MESSAGE = new MessageBuilder("sneakDisabled").withDefault("<prefix_negative>Auto tree chopping disabled by stopping sneak.</prefix_negative>").build();
    private static final String SPIGOT_RESOURCE_ID = "113071";
    private static final List<String> SUPPORTED_VERSIONS = Arrays.asList("1.21.10", "1.21.9", "1.21.8", "1.21.7", "1.21.6", "1.21.5", "1.21.4", "1.21.3", "1.21.2", "1.21.1", "1.21", "1.20.6", "1.20.5", "1.20.4", "1.20.3", "1.20.2", "1.20.1", "1.20", "1.19.4", "1.19.3", "1.19.2", "1.19.1", "1.19", "1.18.2", "1.18.1", "1.18", "1.17.1", "1.17");
    private static final long SAVE_INTERVAL = 1200L;
    private static final int SAVE_THRESHOLD = 15;
    private final Set<Location> checkedLocations = new HashSet<Location>();
    private final Set<Location> processingLocations = new HashSet<Location>();
    private Config config;
    private AutoTreeChopAPI autoTreeChopAPI;
    private Map<UUID, PlayerConfig> playerConfigs = new ConcurrentHashMap<UUID, PlayerConfig>();
    private String bukkitVersion = this.getServer().getBukkitVersion();
    private Metrics metrics;
    private MessageTranslator translations;
    private boolean worldGuardEnabled = false;
    private boolean residenceEnabled = false;
    private boolean griefPreventionEnabled = false;
    private boolean landsEnabled = false;
    private WorldGuardHook worldGuardHook = null;
    private ResidenceHook residenceHook = null;
    private GriefPreventionHook griefPreventionHook = null;
    private LandsHook landsHook = null;
    private CooldownManager cooldownManager;
    private boolean enableSneakToggle = true;
    private DatabaseManager databaseManager;
    private PlayerDataSaveTask saveTask;

    public static void sendMessage(CommandSender sender, ComponentLike message) {
        BukkitTinyTranslations.sendMessageIfNotEmpty(sender, message);
    }

    public static boolean isFolia() {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public void onEnable() {
        this.saveDefaultConfig();
        this.config = new Config(this);
        if (this.bukkitVersion.length() > 14) {
            this.bukkitVersion = this.bukkitVersion.substring(0, this.bukkitVersion.length() - 14);
            if (!SUPPORTED_VERSIONS.contains(this.bukkitVersion)) {
                this.getLogger().warning("Your Minecraft version didn't fully tested yet.");
                this.getLogger().warning("IF you have any issues, feel free to report it at our GitHub: https://github.com/milkteamc/AutoTreeChop/issues");
            }
        }
        this.metrics = new Metrics((Plugin)this, 20053);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        Command command = new Command(this);
        Objects.requireNonNull(this.getCommand("autotreechop")).setExecutor((CommandExecutor)command);
        Objects.requireNonNull(this.getCommand("atc")).setExecutor((CommandExecutor)command);
        Objects.requireNonNull(this.getCommand("autotreechop")).setTabCompleter((org.bukkit.command.TabCompleter)new TabCompleter());
        Objects.requireNonNull(this.getCommand("atc")).setTabCompleter((org.bukkit.command.TabCompleter)new TabCompleter());
        this.translations = BukkitTinyTranslations.application((Plugin)this);
        this.translations.setMessageStorage(new PropertiesMessageStorage(new File(this.getDataFolder(), "/lang/")));
        this.translations.setStyleStorage(new PropertiesStyleStorage(new File(this.getDataFolder(), "/lang/styles.properties")));
        this.translations.addMessages(TinyTranslations.messageFieldsFromClass(AutoTreeChop.class));
        this.loadLocale();
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new AutoTreeChopExpansion(this).register();
            this.getLogger().info("PlaceholderAPI expansion for AutoTreeChop has been registered.");
        } else {
            this.getLogger().warning("PlaceholderAPI not found. Placeholder expansion for AutoTreeChop will not work.");
        }
        new UpdateChecker(this, UpdateCheckSource.SPIGOT, SPIGOT_RESOURCE_ID).checkEveryXHours(24.0).setDonationLink("https://ko-fi.com/maoyue").setChangelogLink("https://modrinth.com/plugin/autotreechop/version/latest").setDownloadLink("https://modrinth.com/plugin/autotreechop/version/latest").setNotifyOpsOnJoin(true).setNotifyByPermissionOnJoin("autotreechop.updatechecker").setUserAgent(new UserAgentBuilder().addPluginNameAndVersion()).checkNow();
        this.databaseManager = new DatabaseManager((Plugin)this, this.config.isUseMysql(), this.config.getHostname(), this.config.getPort(), this.config.getDatabase(), this.config.getUsername(), this.config.getPassword());
        this.saveTask = new PlayerDataSaveTask(this, 15);
        this.saveTask.runTaskTimerAsynchronously((Plugin)this, 1200L, 1200L);
        this.autoTreeChopAPI = new AutoTreeChopAPI(this);
        this.playerConfigs = new HashMap<UUID, PlayerConfig>();
        this.initializeHooks();
        this.cooldownManager = new CooldownManager(this);
        this.enableSneakToggle = this.config.getSneakToggle();
        this.getLogger().info("AutoTreeChop enabled!");
    }

    private void initializeHooks() {
        if (Bukkit.getPluginManager().getPlugin("Residence") != null) {
            try {
                this.residenceHook = new ResidenceHook(this.config.getResidenceFlag());
                this.residenceEnabled = true;
                this.getLogger().info("Residence support enabled");
            }
            catch (Exception e) {
                this.getLogger().warning("Residence can't be hook, please report this to our GitHub: https://github.com/milkteamc/AutoTreeChop/issues");
                this.residenceEnabled = false;
            }
        } else {
            this.residenceEnabled = false;
        }
        if (Bukkit.getPluginManager().getPlugin("GriefPrevention") != null) {
            try {
                this.griefPreventionHook = new GriefPreventionHook(this.config.getGriefPreventionFlag());
                this.griefPreventionEnabled = true;
                this.getLogger().info("GriefPrevention support enabled");
            }
            catch (Exception e) {
                this.getLogger().warning("GriefPrevention can't be hook, please report this to our GitHub: https://github.com/milkteamc/AutoTreeChop/issues");
                this.griefPreventionEnabled = false;
            }
        } else {
            this.griefPreventionEnabled = false;
        }
        if (Bukkit.getPluginManager().getPlugin("Lands") != null) {
            try {
                this.landsHook = new LandsHook((Plugin)this);
                this.landsEnabled = true;
                this.getLogger().info("Lands support enabled");
            }
            catch (Exception e) {
                this.getLogger().warning("Lands can't be hook, please report this to our GitHub: https://github.com/milkteamc/AutoTreeChop/issues");
                this.landsEnabled = false;
            }
        } else {
            this.landsEnabled = false;
        }
        if (Bukkit.getPluginManager().getPlugin("WorldGuard") != null) {
            try {
                this.worldGuardHook = new WorldGuardHook();
                this.worldGuardEnabled = true;
                this.getLogger().info("WorldGuard support enabled");
            }
            catch (NoClassDefFoundError e) {
                this.getLogger().warning("WorldGuard can't be hook, please report this to our GitHub: https://github.com/milkteamc/AutoTreeChop/issues");
                this.worldGuardEnabled = false;
            }
        } else {
            this.worldGuardEnabled = false;
        }
    }

    private void loadLocale() {
        this.saveResourceIfNotExists("lang/styles.properties");
        this.saveResourceIfNotExists("lang/de.properties");
        this.saveResourceIfNotExists("lang/es.properties");
        this.saveResourceIfNotExists("lang/fr.properties");
        this.saveResourceIfNotExists("lang/ja.properties");
        this.saveResourceIfNotExists("lang/ru.properties");
        this.saveResourceIfNotExists("lang/zh.properties");
        this.translations.setUseClientLocale(this.config.isUseClientLocale());
        this.translations.defaultLocale(this.config.getLocale() == null ? Locale.getDefault() : this.config.getLocale());
        this.translations.loadStyles();
        this.translations.loadLocales();
    }

    private void saveResourceIfNotExists(String resourcePath) {
        if (!new File(this.getDataFolder(), resourcePath).exists()) {
            this.saveResource(resourcePath, false);
        }
    }

    public void onDisable() {
        this.getLogger().info("Saving all player data before shutdown...");
        if (this.saveTask != null) {
            this.saveTask.cancel();
        }
        int savedCount = 0;
        for (Map.Entry<UUID, PlayerConfig> entry : this.playerConfigs.entrySet()) {
            if (!entry.getValue().isDirty()) continue;
            this.databaseManager.savePlayerDataSync(entry.getValue().getData());
            ++savedCount;
        }
        this.getLogger().info("Saved " + savedCount + " player data records");
        this.playerConfigs.clear();
        if (this.databaseManager != null) {
            this.databaseManager.close();
        }
        this.translations.close();
        this.metrics.shutdown();
        this.getLogger().info("AutoTreeChop disabled!");
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        ((CompletableFuture)this.databaseManager.loadPlayerDataAsync(playerUUID, this.config.getDefaultTreeChop()).thenAccept(data -> {
            PlayerConfig playerConfig = new PlayerConfig(playerUUID, (DatabaseManager.PlayerData)data);
            this.playerConfigs.put(playerUUID, playerConfig);
        })).exceptionally(ex -> {
            this.getLogger().warning("Failed to load data for player " + player.getName() + ": " + ex.getMessage());
            DatabaseManager.PlayerData defaultData = new DatabaseManager.PlayerData(playerUUID, this.config.getDefaultTreeChop(), 0, 0, LocalDate.now());
            this.playerConfigs.put(playerUUID, new PlayerConfig(playerUUID, defaultData));
            return null;
        });
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        PlayerConfig playerConfig = this.playerConfigs.get(playerUUID);
        if (playerConfig != null && playerConfig.isDirty()) {
            this.databaseManager.savePlayerDataSync(playerConfig.getData());
        }
        this.playerConfigs.remove(playerUUID);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        PlayerConfig playerConfig = this.getPlayerConfig(playerUUID);
        Block block = event.getBlock();
        ItemStack tool = player.getInventory().getItemInMainHand();
        if (this.processingLocations.contains(block.getLocation())) {
            return;
        }
        if (this.cooldownManager.isInCooldown(playerUUID)) {
            AutoTreeChop.sendMessage((CommandSender)player, (ComponentLike)STILL_IN_COOLDOWN_MESSAGE.insertNumber("cooldown_time", this.cooldownManager.getRemainingCooldown(playerUUID)));
            event.setCancelled(true);
            return;
        }
        Material material = block.getType();
        Location location = block.getLocation();
        BlockData blockData = block.getBlockData();
        if (playerConfig.isAutoTreeChopEnabled() && TreeChopUtils.isLog(material, this.config)) {
            if (!PermissionUtils.hasVipBlock(player, playerConfig, this.config) && playerConfig.getDailyBlocksBroken() >= this.config.getMaxBlocksPerDay()) {
                EffectUtils.sendMaxBlockLimitReachedMessage(player, block, HIT_MAX_BLOCK_MESSAGE);
                event.setCancelled(true);
                return;
            }
            if (!PermissionUtils.hasVipUses(player, playerConfig, this.config) && playerConfig.getDailyUses() >= this.config.getMaxUsesPerDay()) {
                BukkitTinyTranslations.sendMessage((CommandSender)player, HIT_MAX_USAGE_MESSAGE);
                return;
            }
            if (this.config.isVisualEffect()) {
                EffectUtils.showChopEffect(player, block);
            }
            event.setCancelled(true);
            this.checkedLocations.clear();
            TreeChopUtils.chopTree(block, player, this.config.isStopChoppingIfNotConnected(), tool, location, material, blockData, this, this.processingLocations, this.checkedLocations, this.config, playerConfig, this.worldGuardEnabled, this.residenceEnabled, this.griefPreventionEnabled, this.landsEnabled, this.landsHook, this.residenceHook, this.griefPreventionHook, this.worldGuardHook);
            this.checkedLocations.clear();
            if (this.saveTask != null) {
                this.saveTask.checkThreshold();
            }
        }
    }

    @EventHandler
    public void onPlayerToggleSneak(PlayerToggleSneakEvent event) {
        if (!this.enableSneakToggle) {
            return;
        }
        Player player = event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        if (!player.hasPermission("autotreechop.use")) {
            return;
        }
        PlayerConfig playerConfig = this.getPlayerConfig(playerUUID);
        if (event.isSneaking()) {
            playerConfig.setAutoTreeChopEnabled(true);
            if (this.config.getSneakMessage()) {
                AutoTreeChop.sendMessage((CommandSender)player, SNEAK_ENABLED_MESSAGE);
            }
        } else {
            playerConfig.setAutoTreeChopEnabled(false);
            if (this.config.getSneakMessage()) {
                AutoTreeChop.sendMessage((CommandSender)player, SNEAK_DISABLED_MESSAGE);
            }
        }
    }

    public PlayerConfig getPlayerConfig(UUID playerUUID) {
        PlayerConfig playerConfig = this.playerConfigs.get(playerUUID);
        if (playerConfig == null) {
            this.getLogger().warning("PlayerConfig not found for " + String.valueOf(playerUUID) + ", loading synchronously");
            try {
                DatabaseManager.PlayerData data = this.databaseManager.loadPlayerDataAsync(playerUUID, this.config.getDefaultTreeChop()).get();
                playerConfig = new PlayerConfig(playerUUID, data);
                this.playerConfigs.put(playerUUID, playerConfig);
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to load player data: " + e.getMessage());
                DatabaseManager.PlayerData defaultData = new DatabaseManager.PlayerData(playerUUID, this.config.getDefaultTreeChop(), 0, 0, LocalDate.now());
                playerConfig = new PlayerConfig(playerUUID, defaultData);
                this.playerConfigs.put(playerUUID, playerConfig);
            }
        }
        return playerConfig;
    }

    public int getPlayerDailyUses(UUID playerUUID) {
        return this.getPlayerConfig(playerUUID).getDailyUses();
    }

    public int getPlayerDailyBlocksBroken(UUID playerUUID) {
        return this.getPlayerConfig(playerUUID).getDailyBlocksBroken();
    }

    public AutoTreeChopAPI getAutoTreeChopAPI() {
        return this.autoTreeChopAPI;
    }

    public CooldownManager getCooldownManager() {
        return this.cooldownManager;
    }

    public Config getPluginConfig() {
        return this.config;
    }

    public Map<UUID, PlayerConfig> getAllPlayerConfigs() {
        return this.playerConfigs;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }
}

