/*
 * Decompiled with CFR 0.152.
 */
package org.milkteamc.autotreechop;

import java.time.LocalDate;
import java.util.UUID;
import org.milkteamc.autotreechop.database.DatabaseManager;

public class PlayerConfig {
    private final UUID playerUUID;
    private final DatabaseManager.PlayerData data;
    private boolean dirty = false;

    public PlayerConfig(UUID playerUUID, DatabaseManager.PlayerData data) {
        this.playerUUID = playerUUID;
        this.data = data;
    }

    private void checkAndUpdateDate() {
        if (!this.data.getLastUseDate().equals(LocalDate.now())) {
            this.data.setDailyUses(0);
            this.data.setDailyBlocksBroken(0);
            this.data.setLastUseDate(LocalDate.now());
            this.markDirty();
        }
    }

    public boolean isAutoTreeChopEnabled() {
        return this.data.isAutoTreeChopEnabled();
    }

    public void setAutoTreeChopEnabled(boolean enabled) {
        if (this.data.isAutoTreeChopEnabled() != enabled) {
            this.data.setAutoTreeChopEnabled(enabled);
            this.markDirty();
        }
    }

    public int getDailyUses() {
        this.checkAndUpdateDate();
        return this.data.getDailyUses();
    }

    public void incrementDailyUses() {
        this.checkAndUpdateDate();
        this.data.incrementDailyUses();
        this.markDirty();
    }

    public int getDailyBlocksBroken() {
        this.checkAndUpdateDate();
        return this.data.getDailyBlocksBroken();
    }

    public void incrementDailyBlocksBroken() {
        this.checkAndUpdateDate();
        this.data.incrementDailyBlocksBroken();
        this.markDirty();
    }

    public void markDirty() {
        this.dirty = true;
    }

    public void clearDirty() {
        this.dirty = false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public DatabaseManager.PlayerData getData() {
        return this.data;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }
}

