/*
 * Decompiled with CFR 0.152.
 */
package org.milkteamc.autotreechop.libs.tinytranslations.nanomessage.compiler;

import java.util.List;
import org.intellij.lang.annotations.Language;
import org.milkteamc.autotreechop.libs.tinytranslations.nanomessage.NanoMessageParser;
import org.milkteamc.autotreechop.libs.tinytranslations.nanomessage.NanoMessageTokenizer;
import org.milkteamc.autotreechop.libs.tinytranslations.nanomessage.compiler.ChoiceCompilation;
import org.milkteamc.autotreechop.libs.tinytranslations.nanomessage.compiler.CompilationStep;
import org.milkteamc.autotreechop.libs.tinytranslations.nanomessage.compiler.ContentTagCompilation;
import org.milkteamc.autotreechop.libs.tinytranslations.nanomessage.compiler.ObjectTagCompilation;
import org.milkteamc.autotreechop.libs.tinytranslations.nanomessage.compiler.PlaceholderCompilation;
import org.milkteamc.autotreechop.libs.tinytranslations.nanomessage.compiler.SelfClosingTagCompilation;
import org.milkteamc.autotreechop.libs.tinytranslations.util.compiler.SimpleStringParser;

public class NanoMessageCompiler {
    private final List<CompilationStep> compilationSteps = List.of(new ObjectTagCompilation(), new SelfClosingTagCompilation(), new PlaceholderCompilation(), new ChoiceCompilation(), new ContentTagCompilation(), (node, context) -> {
        node.getChildren().forEach(context::parse);
        return true;
    });

    public String compile(@Language(value="NanoMessage") String value) {
        NanoMessageTokenizer tokenizer = new NanoMessageTokenizer();
        List<NanoMessageTokenizer.TokenValue> tokens = tokenizer.tokenize(value);
        NanoMessageParser parser = new NanoMessageParser(tokens);
        SimpleStringParser.Node root = this.compile(parser.parse());
        return root.getText();
    }

    private SimpleStringParser.Node compile(SimpleStringParser.Node node) {
        for (CompilationStep compilationStep : this.compilationSteps) {
            if (compilationStep.apply(node, this::compile)) break;
        }
        return node;
    }
}

