/*
 * Decompiled with CFR 0.152.
 */
package org.milkteamc.autotreechop.utils;

import java.util.BitSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.milkteamc.autotreechop.Config;
import org.milkteamc.autotreechop.utils.ProtectionCheckUtils;

public class BlockDiscoveryUtils {
    public static Set<Location> discoverTreeBFS(Block startBlock, Config config, boolean connectedOnly, Player player, ProtectionCheckUtils.ProtectionHooks hooks) {
        HashSet<Location> treeBlocks = new HashSet<Location>();
        LinkedList<Block> queue = new LinkedList<Block>();
        HashSet<Location> visited = new HashSet<Location>();
        Material originalType = startBlock.getType();
        int maxBlocks = config.getMaxDiscoveryBlocks();
        queue.add(startBlock);
        visited.add(startBlock.getLocation());
        while (!queue.isEmpty() && treeBlocks.size() < maxBlocks) {
            Block current = (Block)queue.poll();
            Location loc = current.getLocation();
            if (!ProtectionCheckUtils.canModifyBlock(player, loc, hooks) || !BlockDiscoveryUtils.isLog(current.getType(), config) || config.isStopChoppingIfDifferentTypes() && current.getType() != originalType) continue;
            treeBlocks.add(loc);
            BlockDiscoveryUtils.addNeighborsToQueue(current, queue, visited, connectedOnly);
        }
        return treeBlocks;
    }

    public static Set<Block> discoverLeavesBFS(Block centerBlock, int radius, Config config, Set<Location> removedLogs) {
        HashSet<Block> leaves = new HashSet<Block>();
        HashSet<Location> visited = new HashSet<Location>();
        LinkedList<Block> queue = new LinkedList<Block>();
        Location center = centerBlock.getLocation();
        int radiusSquared = radius * radius;
        queue.add(centerBlock);
        visited.add(center);
        String mode = config.getLeafRemovalMode().toLowerCase();
        while (!queue.isEmpty()) {
            Block current = (Block)queue.poll();
            Location loc = current.getLocation();
            if (loc.distanceSquared(center) > (double)radiusSquared) continue;
            Material type = current.getType();
            if (BlockDiscoveryUtils.isLeafBlock(type, config)) {
                boolean shouldRemove = BlockDiscoveryUtils.shouldRemoveLeaf(current, mode, config, removedLogs);
                if (shouldRemove) {
                    leaves.add(current);
                }
                BlockDiscoveryUtils.addLeafNeighborsToQueue(current, queue, visited, center, radiusSquared);
                continue;
            }
            if (!BlockDiscoveryUtils.isLog(type, config)) continue;
            BlockDiscoveryUtils.addLeafNeighborsToQueue(current, queue, visited, center, radiusSquared);
        }
        return leaves;
    }

    public static Set<Block> discoverLeavesRadial(Block centerBlock, int radius, Config config, Set<Location> removedLogs) {
        HashSet<Block> leaves = new HashSet<Block>();
        Location center = centerBlock.getLocation();
        String mode = config.getLeafRemovalMode().toLowerCase();
        int size = radius * 2 + 1;
        BitSet visited = new BitSet(size * size * size);
        int radiusSquared = radius * radius;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    boolean shouldRemove;
                    int index;
                    Location loc = center.clone().add((double)x, (double)y, (double)z);
                    if (loc.distanceSquared(center) > (double)radiusSquared || visited.get(index = BlockDiscoveryUtils.getBitSetIndex(x, y, z, radius, size))) continue;
                    visited.set(index);
                    Block block = loc.getBlock();
                    Material type = block.getType();
                    if (!BlockDiscoveryUtils.isLeafBlock(type, config) || !(shouldRemove = BlockDiscoveryUtils.shouldRemoveLeaf(block, mode, config, removedLogs))) continue;
                    leaves.add(block);
                }
            }
        }
        return leaves;
    }

    private static boolean shouldRemoveLeaf(Block leafBlock, String mode, Config config, Set<Location> removedLogs) {
        switch (mode) {
            case "aggressive": {
                return true;
            }
            case "radius": {
                return !BlockDiscoveryUtils.hasNearbyActiveLog(leafBlock.getLocation(), config, removedLogs, 4);
            }
        }
        return BlockDiscoveryUtils.isOrphanedLeaf(leafBlock, config, removedLogs);
    }

    private static boolean isOrphanedLeaf(Block leafBlock, Config config, Set<Location> removedLogs) {
        Location leafLoc = leafBlock.getLocation();
        if (!BlockDiscoveryUtils.hasNearbyActiveLog(leafLoc, config, removedLogs, 6)) {
            return true;
        }
        HashSet<Location> visited = new HashSet<Location>();
        return !BlockDiscoveryUtils.isConnectedToActiveLog(leafBlock, config, removedLogs, visited, 0);
    }

    private static boolean hasNearbyActiveLog(Location leafLoc, Config config, Set<Location> removedLogs, int checkRadius) {
        for (int x = -checkRadius; x <= checkRadius; ++x) {
            for (int y = -checkRadius; y <= checkRadius; ++y) {
                for (int z = -checkRadius; z <= checkRadius; ++z) {
                    Location checkLoc;
                    Block block;
                    if (x == 0 && y == 0 && z == 0 || !BlockDiscoveryUtils.isLog((block = (checkLoc = leafLoc.clone().add((double)x, (double)y, (double)z)).getBlock()).getType(), config) || BlockDiscoveryUtils.isLocationInSet(checkLoc, removedLogs)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isConnectedToActiveLog(Block startBlock, Config config, Set<Location> removedLogs, Set<Location> visited, int depth) {
        if (depth > 8 || visited.size() > 100) {
            return false;
        }
        Location startLoc = startBlock.getLocation();
        if (visited.contains(startLoc)) {
            return false;
        }
        visited.add(startLoc);
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    Location checkLoc = startLoc.clone().add((double)x, (double)y, (double)z);
                    Block block = checkLoc.getBlock();
                    Material type = block.getType();
                    if (BlockDiscoveryUtils.isLog(type, config) && !BlockDiscoveryUtils.isLocationInSet(checkLoc, removedLogs)) {
                        return true;
                    }
                    if (!BlockDiscoveryUtils.isLeafBlock(type, config) || visited.contains(checkLoc) || !BlockDiscoveryUtils.isConnectedToActiveLog(block, config, removedLogs, visited, depth + 1)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static void addNeighborsToQueue(Block current, Queue<Block> queue, Set<Location> visited, boolean connectedOnly) {
        for (int yOffset = -1; yOffset <= 1; ++yOffset) {
            for (int xOffset = -1; xOffset <= 1; ++xOffset) {
                for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                    Block neighbor;
                    Location neighborLoc;
                    if (xOffset == 0 && yOffset == 0 && zOffset == 0 || visited.contains(neighborLoc = (neighbor = current.getRelative(xOffset, yOffset, zOffset)).getLocation()) || connectedOnly && BlockDiscoveryUtils.blockNotConnected(current, neighbor)) continue;
                    visited.add(neighborLoc);
                    queue.add(neighbor);
                }
            }
        }
    }

    private static void addLeafNeighborsToQueue(Block current, Queue<Block> queue, Set<Location> visited, Location center, int radiusSquared) {
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    Block neighbor;
                    Location neighborLoc;
                    if (x == 0 && y == 0 && z == 0 || visited.contains(neighborLoc = (neighbor = current.getRelative(x, y, z)).getLocation()) || neighborLoc.distanceSquared(center) > (double)radiusSquared) continue;
                    visited.add(neighborLoc);
                    queue.add(neighbor);
                }
            }
        }
    }

    private static int getBitSetIndex(int x, int y, int z, int radius, int size) {
        int nx = x + radius;
        int ny = y + radius;
        int nz = z + radius;
        return nx + ny * size + nz * size * size;
    }

    private static boolean blockNotConnected(Block block1, Block block2) {
        int dz;
        int dy;
        int dx = Math.abs(block1.getX() - block2.getX());
        return dx + (dy = Math.abs(block1.getY() - block2.getY())) + (dz = Math.abs(block1.getZ() - block2.getZ())) != 1;
    }

    private static boolean isLocationInSet(Location loc, Set<Location> locationSet) {
        return locationSet.stream().anyMatch(setLoc -> setLoc.getBlockX() == loc.getBlockX() && setLoc.getBlockY() == loc.getBlockY() && setLoc.getBlockZ() == loc.getBlockZ() && Objects.equals(setLoc.getWorld(), loc.getWorld()));
    }

    public static boolean isLog(Material material, Config config) {
        return config.getLogTypes().contains(material);
    }

    public static boolean isLeafBlock(Material material, Config config) {
        return config.getLeafTypes().contains(material);
    }
}

