/*
 * Decompiled with CFR 0.152.
 */
package org.milkteamc.autotreechop.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;

public class SessionManager {
    private final Map<UUID, Set<Location>> treeChopProcessingLocations = new ConcurrentHashMap<UUID, Set<Location>>();
    private final Map<String, Set<Location>> leafRemovalRemovedLogs = new ConcurrentHashMap<String, Set<Location>>();
    private final Set<String> activeLeafRemovalSessions = ConcurrentHashMap.newKeySet();
    private static SessionManager instance;

    private SessionManager() {
    }

    public static SessionManager getInstance() {
        if (instance == null) {
            instance = new SessionManager();
        }
        return instance;
    }

    public boolean isLocationProcessing(UUID playerUUID, Location location) {
        Set<Location> locations = this.treeChopProcessingLocations.get(playerUUID);
        if (locations == null) {
            return false;
        }
        return locations.stream().anyMatch(loc -> loc.getBlockX() == location.getBlockX() && loc.getBlockY() == location.getBlockY() && loc.getBlockZ() == location.getBlockZ() && Objects.equals(loc.getWorld(), location.getWorld()));
    }

    public void addTreeChopLocations(UUID playerUUID, Collection<Location> locations) {
        this.treeChopProcessingLocations.computeIfAbsent(playerUUID, k -> ConcurrentHashMap.newKeySet()).addAll(locations);
    }

    public void removeTreeChopLocations(UUID playerUUID, Collection<Location> locations) {
        Set<Location> playerLocations = this.treeChopProcessingLocations.get(playerUUID);
        if (playerLocations != null) {
            playerLocations.removeAll(locations);
            if (playerLocations.isEmpty()) {
                this.treeChopProcessingLocations.remove(playerUUID);
            }
        }
    }

    public void clearTreeChopSession(UUID playerUUID) {
        this.treeChopProcessingLocations.remove(playerUUID);
    }

    public boolean hasActiveLeafRemovalSession(String playerKey) {
        return this.activeLeafRemovalSessions.contains(playerKey);
    }

    public String startLeafRemovalSession(String playerKey) {
        if (this.hasActiveLeafRemovalSession(playerKey)) {
            return null;
        }
        String sessionId = playerKey + "_" + System.currentTimeMillis();
        this.leafRemovalRemovedLogs.put(sessionId, ConcurrentHashMap.newKeySet());
        this.activeLeafRemovalSessions.add(playerKey);
        return sessionId;
    }

    public void trackRemovedLog(String sessionId, Location location) {
        Set<Location> logs = this.leafRemovalRemovedLogs.get(sessionId);
        if (logs != null) {
            logs.add(location.clone());
        }
    }

    public void trackRemovedLogForPlayer(String playerKey, Location location) {
        for (Map.Entry<String, Set<Location>> entry : this.leafRemovalRemovedLogs.entrySet()) {
            if (!entry.getKey().startsWith(playerKey + "_")) continue;
            entry.getValue().add(location.clone());
        }
    }

    public Set<Location> getRemovedLogs(String sessionId) {
        return this.leafRemovalRemovedLogs.getOrDefault(sessionId, Collections.emptySet());
    }

    public boolean isLogRemoved(String sessionId, Location location) {
        Set<Location> logs = this.leafRemovalRemovedLogs.get(sessionId);
        if (logs == null) {
            return false;
        }
        return logs.stream().anyMatch(loc -> loc.getBlockX() == location.getBlockX() && loc.getBlockY() == location.getBlockY() && loc.getBlockZ() == location.getBlockZ() && Objects.equals(loc.getWorld(), location.getWorld()));
    }

    public void endLeafRemovalSession(String sessionId, String playerKey) {
        this.leafRemovalRemovedLogs.remove(sessionId);
        this.activeLeafRemovalSessions.remove(playerKey);
    }

    public boolean hasAnyActiveSession(UUID playerUUID) {
        return this.treeChopProcessingLocations.containsKey(playerUUID) || this.hasActiveLeafRemovalSession(playerUUID.toString());
    }

    public void clearAllPlayerSessions(UUID playerUUID) {
        this.clearTreeChopSession(playerUUID);
        String playerKey = playerUUID.toString();
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String sessionId2 : this.leafRemovalRemovedLogs.keySet()) {
            if (!sessionId2.startsWith(playerKey + "_")) continue;
            toRemove.add(sessionId2);
        }
        toRemove.forEach(sessionId -> this.endLeafRemovalSession((String)sessionId, playerKey));
    }

    public String getStats() {
        return String.format("TreeChop sessions: %d, LeafRemoval sessions: %d", this.treeChopProcessingLocations.size(), this.leafRemovalRemovedLogs.size());
    }
}

