/*
 * Decompiled with CFR 0.152.
 */
package org.milkteamc.autotreechop;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDate;
import java.util.UUID;
import org.milkteamc.autotreechop.AutoTreeChop;
import org.milkteamc.autotreechop.libs.hikari.HikariConfig;
import org.milkteamc.autotreechop.libs.hikari.HikariDataSource;

public class PlayerConfig {
    private final AutoTreeChop plugin;
    private final UUID playerUUID;
    private final Connection connection;
    private boolean autoTreeChopEnabled;
    private int dailyUses;
    private int dailyBlocksBroken;
    private LocalDate lastUseDate;

    public PlayerConfig(AutoTreeChop plugin, UUID playerUUID, boolean useMysql, String hostname, String database, int port, String username, String password, boolean defaultTreeChop) {
        this.playerUUID = playerUUID;
        this.plugin = plugin;
        this.connection = this.establishConnection(useMysql, hostname, port, database, username, password);
        this.createTable();
        this.loadConfig(defaultTreeChop);
    }

    private Connection establishConnection(boolean useMysql, String hostname, int port, String database, String username, String password) {
        if (useMysql) {
            try {
                HikariConfig config = new HikariConfig();
                config.setJdbcUrl("jdbc:mysql://" + hostname + ":" + port + "/" + database);
                config.setUsername(username);
                config.setPassword(password);
                config.setMaximumPoolSize(10);
                HikariDataSource dataSource = new HikariDataSource(config);
                return dataSource.getConnection();
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error establishing MySQL connection: " + e.getMessage());
                return null;
            }
        }
        try {
            HikariConfig config = new HikariConfig();
            config.setJdbcUrl("jdbc:sqlite:plugins/AutoTreeChop/player_data.db");
            config.setMaximumPoolSize(10);
            HikariDataSource dataSource = new HikariDataSource(config);
            return dataSource.getConnection();
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error establishing SQLite connection: " + e.getMessage());
            return null;
        }
    }

    private void createTable() {
        try (PreparedStatement statement = this.connection.prepareStatement("CREATE TABLE IF NOT EXISTS player_data (uuid VARCHAR(36) PRIMARY KEY,autoTreeChopEnabled BOOLEAN,dailyUses INT,dailyBlocksBroken INT,lastUseDate VARCHAR(10));");){
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Error creating database table: " + e.getMessage());
        }
    }

    private void loadConfig(boolean defaultTreeChop) {
        block17: {
            try (PreparedStatement statement = this.connection.prepareStatement("SELECT * FROM player_data WHERE uuid = ?");){
                statement.setString(1, this.playerUUID.toString());
                ResultSet resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    this.autoTreeChopEnabled = resultSet.getBoolean("autoTreeChopEnabled");
                    this.dailyUses = resultSet.getInt("dailyUses");
                    this.dailyBlocksBroken = resultSet.getInt("dailyBlocksBroken");
                    this.lastUseDate = LocalDate.parse(resultSet.getString("lastUseDate"));
                    break block17;
                }
                this.autoTreeChopEnabled = defaultTreeChop;
                this.dailyUses = 0;
                this.dailyBlocksBroken = 0;
                this.lastUseDate = LocalDate.now();
                try (PreparedStatement insertStatement = this.connection.prepareStatement("INSERT INTO player_data (uuid, autoTreeChopEnabled, dailyUses, dailyBlocksBroken, lastUseDate) VALUES (?, ?, ?, ?, ?)");){
                    insertStatement.setString(1, this.playerUUID.toString());
                    insertStatement.setBoolean(2, this.autoTreeChopEnabled);
                    insertStatement.setInt(3, this.dailyUses);
                    insertStatement.setInt(4, this.dailyBlocksBroken);
                    insertStatement.setString(5, this.lastUseDate.toString());
                    insertStatement.executeUpdate();
                }
                catch (SQLException e) {
                    this.plugin.getLogger().warning("Error inserting player data into database: " + e.getMessage());
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().warning("Error loading player data from database: " + e.getMessage());
            }
        }
    }

    public boolean isAutoTreeChopEnabled() {
        return this.autoTreeChopEnabled;
    }

    public void setAutoTreeChopEnabled(boolean enabled) {
        this.autoTreeChopEnabled = enabled;
        this.updateConfig();
    }

    public int getDailyUses() {
        this.checkAndUpdateDate();
        return this.dailyUses;
    }

    public void incrementDailyUses() {
        this.checkAndUpdateDate();
        ++this.dailyUses;
        this.updateConfig();
    }

    public int getDailyBlocksBroken() {
        this.checkAndUpdateDate();
        return this.dailyBlocksBroken;
    }

    private void initializeSQLiteTables(Connection connection) {
        try (Statement statement = connection.createStatement();){
            String createTableQuery = "CREATE TABLE IF NOT EXISTS player_data (uuid VARCHAR(36) PRIMARY KEY,autoTreeChopEnabled BOOLEAN,dailyUses INT,dailyBlocksBroken INT,lastUseDate VARCHAR(10))";
            statement.executeUpdate(createTableQuery);
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Error initializing database tables: " + e.getMessage());
        }
    }

    public void incrementDailyBlocksBroken() {
        this.checkAndUpdateDate();
        ++this.dailyBlocksBroken;
        this.updateConfig();
    }

    private void checkAndUpdateDate() {
        if (!this.lastUseDate.equals(LocalDate.now())) {
            this.dailyUses = 0;
            this.dailyBlocksBroken = 0;
            this.lastUseDate = LocalDate.now();
            this.updateConfig();
        }
    }

    private void updateConfig() {
        try (PreparedStatement statement = this.connection.prepareStatement("UPDATE player_data SET autoTreeChopEnabled = ?, dailyUses = ?, dailyBlocksBroken = ?, lastUseDate = ? WHERE uuid = ?");){
            statement.setBoolean(1, this.autoTreeChopEnabled);
            statement.setInt(2, this.dailyUses);
            statement.setInt(3, this.dailyBlocksBroken);
            statement.setString(4, this.lastUseDate.toString());
            statement.setString(5, this.playerUUID.toString());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Error updating player data in database: " + e.getMessage());
        }
    }
}

