/*
 * Decompiled with CFR 0.152.
 */
package org.milkteamc.autotreechop.libs.tinytranslations.nanomessage.tag;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.Component;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.ComponentLike;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.minimessage.Context;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.minimessage.ParsingException;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.minimessage.tag.Tag;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.milkteamc.autotreechop.libs.tinytranslations.tinyobject.InsertedObject;
import org.milkteamc.autotreechop.libs.tinytranslations.tinyobject.TinyObjectMapping;
import org.milkteamc.autotreechop.libs.tinytranslations.tinyobject.TinyObjectResolver;
import org.milkteamc.autotreechop.libs.tinytranslations.tinyobject.TinyObjectResolverImpl;

public class ObjectNotationTag {
    public static final String KEY = "object_notation";
    private static TinyObjectResolver RESOLVER = new TinyObjectResolverImpl();

    public static TagResolver resolver(final Map<String, InsertedObject> objectTable, final Collection<TinyObjectMapping> mappings) {
        return new TagResolver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public Tag resolve(@NotNull String name, @NotNull ArgumentQueue argumentQueue, @NotNull Context c) throws ParsingException {
                if (!name.equalsIgnoreCase(ObjectNotationTag.KEY) && !objectTable.containsKey(name)) {
                    return null;
                }
                if (name.equalsIgnoreCase(ObjectNotationTag.KEY) && !argumentQueue.hasNext()) {
                    throw c.newException("A object_notation must be used in combination with a dot notated object descriptor.");
                }
                String descriptor = name.equalsIgnoreCase(ObjectNotationTag.KEY) ? argumentQueue.pop().value() : name;
                LinkedList<String> path = new LinkedList<String>(Arrays.stream(descriptor.split("\\.")).toList());
                InsertedObject boxed = (InsertedObject)objectTable.get(path.poll());
                if (boxed == null) {
                    return Tag.inserting(Component.text("null"));
                }
                Object obj = boxed.object();
                ArrayList<TinyObjectMapping> fMappings = new ArrayList<TinyObjectMapping>(mappings);
                fMappings.addAll(boxed.resolvers());
                Object resolved = RESOLVER.resolveObject(obj, path, fMappings);
                try {
                    if (resolved == null) {
                        throw c.newException("Could not resolve object with path '" + descriptor + ":" + String.join((CharSequence)":", path) + "'.");
                    }
                    if (resolved instanceof TagResolver) {
                        TagResolver resolver = (TagResolver)resolved;
                        Tag tag = resolver.resolve("avoid_name_collisions", argumentQueue, c);
                        return tag;
                    }
                    if (resolved instanceof Tag) {
                        Tag tag;
                        Tag tag2 = tag = (Tag)resolved;
                        return tag2;
                    }
                    if (resolved instanceof ComponentLike) {
                        ComponentLike componentLike = (ComponentLike)resolved;
                        Tag tag = Tag.inserting(componentLike);
                        return tag;
                    }
                    Tag tag = Tag.inserting(Component.text(resolved.toString()));
                    return tag;
                }
                finally {
                    argumentQueue.reset();
                }
            }

            @Override
            public boolean has(@NotNull String name) {
                return name.equalsIgnoreCase(ObjectNotationTag.KEY) || objectTable.containsKey(name);
            }
        };
    }
}

