/*
 * Decompiled with CFR 0.152.
 */
package org.milkteamc.autotreechop.libs.tinytranslations.storage.properties;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.milkteamc.autotreechop.libs.tinytranslations.Message;
import org.milkteamc.autotreechop.libs.tinytranslations.TranslationKey;
import org.milkteamc.autotreechop.libs.tinytranslations.storage.FileMessageStorage;
import org.milkteamc.autotreechop.libs.tinytranslations.storage.MessageStorage;
import org.milkteamc.autotreechop.libs.tinytranslations.storage.StorageEntry;
import org.milkteamc.autotreechop.libs.tinytranslations.storage.properties.PropertiesUtils;

public class PropertiesMessageStorage
extends FileMessageStorage
implements MessageStorage {
    private static final Charset[] CHARSETS = new Charset[]{StandardCharsets.UTF_8, StandardCharsets.ISO_8859_1};

    public PropertiesMessageStorage(File directory) {
        this(directory, "", "");
    }

    public PropertiesMessageStorage(File directory, String prefix, String suffix) {
        super(directory, prefix, suffix + ".properties");
    }

    @Override
    public Map<TranslationKey, StorageEntry> readMessages(Locale locale) {
        File file = this.localeFileIfExists(locale);
        if (file == null) {
            return new HashMap<TranslationKey, StorageEntry>();
        }
        Map<String, StorageEntry> entries = this.readFile(file);
        HashMap<TranslationKey, StorageEntry> result = new HashMap<TranslationKey, StorageEntry>();
        entries.forEach((key, value) -> result.put(TranslationKey.of(key), (StorageEntry)value));
        return result;
    }

    @Override
    public Collection<Message> writeMessages(Collection<Message> messages, Locale locale, boolean override) {
        File file = this.localeFile(locale);
        HashSet<Message> written = new HashSet<Message>();
        Map<Object, Object> entries = override ? new HashMap() : this.readFile(file);
        for (Message msg : messages) {
            if (!msg.dictionary().containsKey(locale) || entries.containsKey(msg.getKey().key())) continue;
            entries.put(msg.key(), new StorageEntry(msg.getKey().key(), msg.dictionary().get(locale), msg.comment()));
            written.add(msg);
        }
        ArrayList<Object> sortedEntries = new ArrayList<Object>(entries.values());
        sortedEntries.sort(Comparator.comparing(StorageEntry::key));
        this.writeFile(file, sortedEntries);
        return written;
    }

    private void writeFile(File file, List<StorageEntry> entries) {
        try (FileWriter writer = new FileWriter(file, this.detectCharset(file, CHARSETS));){
            PropertiesUtils.write(writer, entries);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, StorageEntry> readFile(File file) {
        Map<String, StorageEntry> map;
        FileReader reader = new FileReader(file, StandardCharsets.UTF_8);
        try {
            map = PropertiesUtils.loadProperties(reader).stream().collect(Collectors.toMap(StorageEntry::key, e -> e));
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable t) {
                throw new RuntimeException("Error while parsing locale file '" + file.getAbsolutePath() + "'.", t);
            }
        }
        ((Reader)reader).close();
        return map;
    }
}

